/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldContentEdit
extends AbstractUndoableEdit {
    private IField field;
    private List<IFieldContent> newContent;
    private List<IFieldContent> oldContent;
    private String oldName;
    private String newName;
    private static String NAME = "fieldName";
    private JTree tree;
    private TreeNode node;

    private void initialise(IField field, String fieldName, List<IFieldContent> content, JTree tree, TreeNode node) {
        this.newName = fieldName;
        this.field = field;
        this.newContent = content;
        this.tree = tree;
        this.node = node;
        this.oldName = field.getAttribute(NAME);
        this.oldContent = new ArrayList<IFieldContent>();
        for (int i = 0; i < field.getContentCount(); ++i) {
            this.oldContent.add(field.getContentAt(i));
        }
        this.redo();
    }

    public FieldContentEdit(IField field, List<IFieldContent> content, JTree tree, TreeNode node) {
        String newFieldName = field.getAttribute(NAME);
        this.initialise(field, newFieldName, content, tree, node);
    }

    public FieldContentEdit(IField field, String fieldName, List<IFieldContent> content, JTree tree, TreeNode node) {
        this.initialise(field, fieldName, content, tree, node);
    }

    @Override
    public void undo() {
        this.field.setAttribute(NAME, this.oldName);
        for (int i = this.field.getContentCount() - 1; i >= 0; --i) {
            this.field.removeContent(i);
        }
        for (IFieldContent newItem : this.oldContent) {
            this.field.addContent(newItem);
        }
        this.notifySelect();
    }

    @Override
    public void redo() {
        this.field.setAttribute(NAME, this.newName);
        for (int i = this.field.getContentCount() - 1; i >= 0; --i) {
            this.field.removeContent(i);
        }
        for (IFieldContent newItem : this.newContent) {
            this.field.addContent(newItem);
        }
        this.notifySelect();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    private void notifySelect() {
        this.notifyNodeChanged();
        TreeModelMethods.selectNode(this.node, this.tree);
    }

    @Override
    public String getPresentationName() {
        return "Edit Step Content";
    }

    private void notifyNodeChanged() {
        if (this.tree != null && this.node != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            treeModel.nodeChanged(this.node);
        }
    }
}

