/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.Field;
import org.openmicroscopy.shoola.agents.editor.model.FieldNode;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldSplitEdit
extends AbstractUndoableEdit {
    private IField field;
    private IField newField;
    private List<IFieldContent> newContent1;
    private List<IFieldContent> newContent2;
    private List<IFieldContent> oldContent;
    private String oldName;
    private String newName;
    private static String NAME = "fieldName";
    private JTree tree;
    private TreeNode node;
    private DefaultMutableTreeNode newNode;
    private DefaultMutableTreeNode parentNode;
    private DefaultTreeModel treeModel;

    private void initialise(IField field, String fieldName, List<IFieldContent> content1, List<IFieldContent> content2, JTree tree, TreeNode node) {
        this.newName = fieldName;
        this.field = field;
        this.newContent1 = content1;
        this.newContent2 = content2;
        this.tree = tree;
        this.node = node;
        this.parentNode = (DefaultMutableTreeNode)node.getParent();
        this.treeModel = (DefaultTreeModel)tree.getModel();
        this.oldName = field.getAttribute(NAME);
        this.oldContent = new ArrayList<IFieldContent>();
        for (int i = 0; i < field.getContentCount(); ++i) {
            this.oldContent.add(field.getContentAt(i));
        }
        this.newField = new Field();
        this.newNode = new FieldNode(this.newField);
        this.redo();
    }

    public FieldSplitEdit(IField field, List<IFieldContent> content1, List<IFieldContent> content2, JTree tree, TreeNode node) {
        String newFieldName = field.getAttribute(NAME);
        this.initialise(field, newFieldName, content1, content2, tree, node);
    }

    public FieldSplitEdit(IField field, String fieldName, List<IFieldContent> content1, List<IFieldContent> content2, JTree tree, TreeNode node) {
        this.initialise(field, fieldName, content1, content2, tree, node);
    }

    @Override
    public void undo() {
        int i;
        if (this.parentNode == null) {
            return;
        }
        this.treeModel.removeNodeFromParent(this.newNode);
        this.field.setAttribute(NAME, this.oldName);
        for (i = this.field.getContentCount() - 1; i >= 0; --i) {
            this.field.removeContent(i);
        }
        for (i = this.newField.getContentCount() - 1; i >= 0; --i) {
            this.newField.removeContent(i);
        }
        for (IFieldContent newItem : this.oldContent) {
            this.field.addContent(newItem);
        }
        this.notifyNodeChanged();
        this.tree.clearSelection();
        TreePath path = new TreePath(((DefaultMutableTreeNode)this.node).getPath());
        this.tree.setSelectionPath(path);
    }

    @Override
    public void redo() {
        if (this.parentNode == null) {
            return;
        }
        this.newField.setAttribute(NAME, this.newName);
        this.field.setAttribute(NAME, null);
        for (int i = this.field.getContentCount() - 1; i >= 0; --i) {
            this.field.removeContent(i);
        }
        for (IFieldContent newItem : this.newContent2) {
            this.field.addContent(newItem);
        }
        for (IFieldContent newItem : this.newContent1) {
            this.newField.addContent(newItem);
        }
        int indexToAdd = this.parentNode.getIndex(this.node);
        this.treeModel.insertNodeInto(this.newNode, this.parentNode, indexToAdd);
        this.tree.clearSelection();
        TreePath path = new TreePath(((DefaultMutableTreeNode)this.node).getPath());
        this.tree.setSelectionPath(path);
    }

    @Override
    public String getPresentationName() {
        return "Split Step";
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    private void notifyNodeChanged() {
        if (this.tree != null && this.node != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            treeModel.nodeChanged(this.node);
        }
    }
}

