/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.Note;
import org.openmicroscopy.shoola.agents.editor.model.ProtocolRootField;
import org.openmicroscopy.shoola.agents.editor.model.TreeIterator;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.TreeEdit;

public class RemoveExpInfo
extends AbstractUndoableEdit
implements TreeEdit {
    private ProtocolRootField field;
    private IAttributes expInfo;
    private DefaultMutableTreeNode node;
    DefaultTreeModel treeModel;
    private HashMap<IField, List<Note>> stepNotes;

    private void getStepNotes() {
        this.stepNotes = new HashMap();
        Object r = this.treeModel.getRoot();
        if (!(r instanceof TreeNode)) {
            return;
        }
        TreeNode root = (TreeNode)r;
        TreeIterator iterator = new TreeIterator(root);
        while (iterator.hasNext()) {
            IField f;
            int noteCount;
            DefaultMutableTreeNode node;
            Object userOb;
            TreeNode tn = (TreeNode)iterator.next();
            if (!(tn instanceof DefaultMutableTreeNode) || !((userOb = (node = (DefaultMutableTreeNode)tn).getUserObject()) instanceof IField) || (noteCount = (f = (IField)userOb).getNoteCount()) == 0) continue;
            ArrayList<Note> notes = new ArrayList<Note>();
            for (int i = 0; i < noteCount; ++i) {
                notes.add(f.getNoteAt(i));
            }
            this.stepNotes.put(f, notes);
        }
    }

    public RemoveExpInfo(JTree tree) {
        this.setTree(tree);
        this.doEdit();
    }

    public RemoveExpInfo(TreeModel treeModel) {
        this.treeModel = (DefaultTreeModel)treeModel;
        this.doEdit();
    }

    public void doEdit() {
        if (this.treeModel == null) {
            return;
        }
        this.node = (DefaultMutableTreeNode)this.treeModel.getRoot();
        Object ob = this.node.getUserObject();
        if (!(ob instanceof ProtocolRootField)) {
            return;
        }
        this.field = (ProtocolRootField)ob;
        this.expInfo = this.field.getExpInfo();
        this.getStepNotes();
        this.redo();
    }

    public void undo() {
        for (IField f : this.stepNotes.keySet()) {
            List<Note> notes = this.stepNotes.get(f);
            for (Note note : notes) {
                f.addNote(note);
            }
        }
        this.field.setExpInfo(this.expInfo);
        this.notifyNodeChanged();
    }

    public void redo() {
        for (IField f : this.stepNotes.keySet()) {
            List<Note> notes = this.stepNotes.get(f);
            for (Note note : notes) {
                f.removeNote(note);
            }
        }
        this.field.setExpInfo(null);
        this.notifyNodeChanged();
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public String getPresentationName() {
        return "Delete Experiment Info";
    }

    private void notifyNodeChanged() {
        if (this.treeModel != null) {
            this.treeModel.nodeChanged(this.node);
        }
    }

    public void setTree(JTree tree) {
        if (tree != null) {
            this.treeModel = (DefaultTreeModel)tree.getModel();
        }
    }
}

