/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.view;

import java.io.File;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.tree.TreeModel;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.model.CPEexport;

class Autosave
implements Runnable {
    private ScheduledThreadPoolExecutor executor;
    private Browser browser;
    private File tempFile;
    static int index = 1;

    Autosave(Browser browser) {
        this.browser = browser;
        this.executor = new ScheduledThreadPoolExecutor(1);
        long delaySecs = 60L;
        try {
            String delay = (String)EditorAgent.getRegistry().lookup("/services/editor/autosaveDelay");
            delaySecs = Long.parseLong(delay);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.executor.scheduleWithFixedDelay(this, delaySecs, delaySecs, TimeUnit.SECONDS);
    }

    private void makeTempFile() {
        String fileName = "RecoveredFile" + index + ".cpe.xml";
        String autosaveFolder = EditorAgent.getEditorAutosave();
        String filePath = autosaveFolder + File.separator + fileName;
        this.tempFile = new File(filePath);
        if (this.tempFile.exists()) {
            ++index;
            this.makeTempFile();
        }
    }

    public void run() {
        CPEexport xmlExport;
        boolean saved;
        TreeModel model = this.browser.getTreeModel();
        if (model == null) {
            return;
        }
        if (this.tempFile == null) {
            this.makeTempFile();
        }
        if (!(saved = (xmlExport = new CPEexport()).export(model, this.tempFile))) {
            this.makeTempFile();
        }
    }

    void shutDown() {
        this.executor.shutdownNow();
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }
}

