/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.view;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.util.ui.MessageBox;

public class AutosaveRecovery {
    public void checkForRecoveredFiles() {
        block2: {
            int option;
            int fileCount;
            File[] recoveredFiles;
            block3: {
                String path = EditorAgent.getEditorAutosave();
                File folder = new File(path);
                recoveredFiles = folder.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith("cpe.xml");
                    }
                });
                fileCount = recoveredFiles.length;
                if (fileCount <= 0) break block2;
                String message = fileCount + " Editor file" + (fileCount > 1 ? "s were " : " was ") + "recovered." + "\nThe application may not have shut down properly last time" + " it was used." + "\nDo you want to open the recovered files or delete them?";
                JFrame f = EditorAgent.getRegistry().getTaskBar().getFrame();
                MessageBox msg = new MessageBox(f, "Files Recovered", message);
                msg.addCancelButton();
                msg.setYesText("Open Files");
                msg.setNoText("Delete Files");
                msg.setCancelText("Ignore");
                option = msg.centerMsgBox();
                if (option != 1) break block3;
                for (int i = 0; i < fileCount; ++i) {
                    File file = recoveredFiles[i];
                    SwingUtilities.invokeLater(new FileOpener(file));
                }
                break block2;
            }
            if (option != 0) break block2;
            for (int i = 0; i < fileCount; ++i) {
                File file = recoveredFiles[i];
                file.delete();
            }
        }
    }

    private class FileOpener
    implements Runnable {
        private File file;

        FileOpener(File f) {
            this.file = f;
        }

        public void run() {
            Editor e = EditorAgent.openLocalFile(this.file);
            if (e != null) {
                e.setEdited(true);
            }
            this.file.delete();
        }
    }
}

