/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.view;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JCheckBox;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.actions.SaveLocallyCmd;
import org.openmicroscopy.shoola.agents.editor.actions.SaveNewCmd;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.view.Autosave;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.agents.editor.view.EditorControl;
import org.openmicroscopy.shoola.agents.editor.view.EditorFactory;
import org.openmicroscopy.shoola.agents.editor.view.EditorModel;
import org.openmicroscopy.shoola.agents.editor.view.EditorUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.FileAnnotationData;

class EditorComponent
extends AbstractComponent
implements Editor {
    private EditorModel model;
    private EditorControl controller;
    private EditorUI view;
    private Autosave autosave;

    EditorComponent(EditorModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new EditorControl(this);
        this.view = new EditorUI(model.getFileName());
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model);
        this.autosave = new Autosave(this.model.getBrowser());
    }

    EditorModel getModel() {
        return this.model;
    }

    void setNewExperiment() {
        this.model.setBlankFile(this.model.getFileName());
        this.view.displayFile();
        this.model.updateNameSpace();
        this.fireStateChange();
    }

    public void activate() {
        int state = this.model.getState();
        switch (state) {
            case 1: {
                if (this.model.getFileID() != 0L) {
                    this.model.fireFileLoading();
                    this.fireStateChange();
                    break;
                }
                if (this.view == null) break;
                this.view.setVisible(true);
                break;
            }
            case 4: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
            default: {
                if (this.view == null) break;
                this.view.setVisible(true);
            }
        }
    }

    public boolean hasDataToSave() {
        return this.model.hasDataToSave();
    }

    public void discard() {
        this.model.discard();
        this.autosave.shutDown();
        this.fireStateChange();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void close() {
        if (!EditorAgent.isServerAvailable()) {
            MessageBox msg = new MessageBox(this.view, "Exit Application", "Do you really want to close the Editor?");
            JCheckBox box = null;
            if (this.model.hasDataToSave()) {
                box = new JCheckBox("Save Data");
                box.setSelected(true);
                msg.addBodyComponent(box);
            }
            if (msg.centerMsgBox() != 1) return;
            if (box != null && box.isSelected()) {
                SaveLocallyCmd save = new SaveLocallyCmd(this);
                save.execute();
            }
            this.discard();
            return;
        }
        if (this.model.hasDataToSave() && this.isUserOwner()) {
            MessageBox msg = new MessageBox(this.view, "Save Data", "Before closing the Editor, do you want to save?");
            msg.addCancelButton();
            int option = msg.centerMsgBox();
            if (option != 1) {
                if (option != 0) return;
                this.discard();
                return;
            }
            boolean saved = this.saveCurrentFile();
            if (saved) {
                this.discard();
                return;
            }
            UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Save Data", "An error occurred whiletrying to save the data. Saving as a new file");
            SaveNewCmd save = new SaveNewCmd(this);
            save.execute();
            return;
        }
        this.discard();
    }

    public int getState() {
        return this.model.getState();
    }

    public void setStatus(String description, boolean hide) {
        this.view.setStatus(description, hide);
    }

    public void cancel() {
        if (this.model.getState() == 4) {
            return;
        }
        this.model.cancel();
    }

    public void setFileToEdit(FileAnnotationData fa, File file) {
        int state = this.model.getState();
        if (state != 2 && state != 1) {
            throw new IllegalStateException("This method should only be invoked in the LOADING or NEW states.");
        }
        if (fa != null) {
            this.model.setFileAnnotationData(fa);
        }
        if ("openmicroscopy.org/omero/import/companionFile".equals(this.model.getNameSpace())) {
            try {
                this.view.displayFile(this.model.readTextFile(file));
                if (!this.view.isVisible()) {
                    this.view.setVisible(true);
                }
            }
            catch (Exception e) {
                UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Reading...", "Problem while reading the text file.");
            }
        } else if (this.model.setFileToEdit(file)) {
            this.model.updateNameSpace();
            this.view.displayFile();
            this.model.getBrowser().setId(this.model.getAnnotationId());
            if (!this.view.isVisible()) {
                this.view.setVisible(true);
            }
        }
        this.fireStateChange();
    }

    public String getEditorTitle() {
        if (this.model.getState() == 4) {
            return "";
        }
        return this.model.getFileName();
    }

    public void openLocalFile(File file) {
        EditorAgent.openLocalFile(file);
    }

    public void newBlankFile() {
        Editor editor = EditorFactory.getNewBlankEditor();
        if (editor != null) {
            editor.setBlankFile();
            editor.activate();
        }
    }

    public void setBlankFile() {
        this.model.setBlankFile(null);
        this.view.displayFile();
        this.fireStateChange();
    }

    public boolean saveCurrentFile() {
        long fileID;
        Date lastSaved;
        String savedNamespace = this.model.getNameSpace();
        boolean fileIsExperiment = this.model.getBrowser().isModelExperiment();
        if ("openmicroscopy.org/omero/editor/protocol".equals(savedNamespace) && fileIsExperiment) {
            MessageBox msg = new MessageBox(this.view, "Save Experiment?", "Overwrite 'Protocol' with 'Experiment'?\n \n(Answer 'No' to 'Save As' a new file)");
            int option = msg.centerMsgBox();
            if (option != 1) {
                return false;
            }
        } else if (fileIsExperiment && this.model.getFileToEdit() != null && (lastSaved = this.model.getBrowser().getLastSavedDate()) != null) {
            MessageBox msg;
            int option;
            GregorianCalendar saved = new GregorianCalendar();
            saved.setTime(lastSaved);
            GregorianCalendar midnight = new GregorianCalendar();
            midnight.set(11, 0);
            SimpleDateFormat sdf = new SimpleDateFormat("d MMM yyyy 'at' HH:mm:ss");
            String savedDate = sdf.format(lastSaved);
            if (saved.before(midnight) && (option = (msg = new MessageBox(this.view, "Update Experiment?", "This Experiment was last saved on \n" + savedDate + ".\n \n" + "Do you want to overwrite with the current file?")).centerMsgBox()) != 1) {
                return false;
            }
        }
        if ((fileID = this.model.getFileID()) <= 0L) {
            boolean b = this.model.saveLocalFile();
            if (b) {
                this.model.updateNameSpace();
                UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
                un.notifyInfo("File Saved", "The File has been saved locally.");
            }
            return b;
        }
        String fileName = this.model.getFileName();
        int lastSlash = fileName.lastIndexOf(File.separator);
        if ((fileName = fileName.substring(lastSlash + 1)).length() == 0) {
            fileName = "new_protocol.cpe.xml";
        }
        this.model.fireFileSaving(fileName, true);
        this.model.updateNameSpace();
        return true;
    }

    private boolean saveFileLocally(File file) {
        if (this.model.saveFileAs(file)) {
            this.view.setTitle(this.model.getFileName());
            this.model.getBrowser().setId(this.model.getAnnotationId());
            return true;
        }
        return false;
    }

    public boolean save(Object object, int index) {
        switch (index) {
            case 0: {
                if (object instanceof File) {
                    return this.saveFileLocally((File)object);
                }
                return false;
            }
            case 1: {
                if (object instanceof String) {
                    this.saveFileServer((String)object, true);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void save(boolean asynch) {
        long fileID = this.model.getFileID();
        if (fileID <= 0L || !EditorAgent.isServerAvailable()) {
            this.model.saveLocalFile();
            return;
        }
        String fileName = this.model.getFileName();
        int lastSlash = fileName.lastIndexOf(File.separator);
        if ((fileName = fileName.substring(lastSlash + 1)).length() == 0) {
            fileName = "new_protocol.cpe.xml";
        }
        this.model.fireFileSaving(fileName, asynch);
    }

    private void saveFileServer(String fileName, boolean asynch) {
        if (EditorAgent.getRegistry().getTaskBar().login()) {
            int lastSlash = fileName.lastIndexOf(File.separator);
            if ((fileName = fileName.substring(lastSlash + 1)).length() == 0) {
                fileName = "new_protocol.cpe.xml";
            }
            this.model.setFileAnnotationData(null);
            this.model.fireFileSaving(fileName, asynch);
            this.fireStateChange();
        }
    }

    public void onFileSave(FileAnnotationData data) {
        UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
        String message = "An error occured while saving the file to the server.";
        if (data != null) {
            long id = data.getId();
            message = "The File has been saved to the server. \nID = " + id;
            this.model.setFileAnnotationData(data);
            this.model.getBrowser().setId(id);
        }
        un.notifyInfo("File Saved", message);
        this.model.setState(3);
        this.view.setTitle(this.model.getFileName());
        this.fireStateChange();
    }

    public void registerBrowserListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.model.getBrowser().addPropertyChangeListener(listener);
        }
    }

    public void setEdited(boolean editable) {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            browser.setEdited(editable);
        }
    }

    public boolean isExperiment() {
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            return false;
        }
        return browser.isModelExperiment();
    }

    public void deleteExperimentInfo() {
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        browser.deleteExperimentInfo();
    }

    public boolean isUserOwner() {
        return this.model.isUserOwner();
    }

    public String toString() {
        return this.view.getTitle();
    }
}

