/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import java.io.File;
import java.util.Collection;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportDialog;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportableObject;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterControl;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterModel;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class ImporterComponent
extends AbstractComponent
implements Importer {
    private ImporterModel model;
    private ImporterControl controller;
    private ImporterUI view;
    private ImportDialog chooser;

    private void showChooser(int type) {
        if (this.chooser == null) {
            this.chooser = new ImportDialog(this.view, this.model.getSupportedFormats(), this.model.getContainer(), type);
            this.chooser.addPropertyChangeListener(this.controller);
            this.chooser.pack();
        }
        UIUtilities.centerAndShow(this.chooser);
    }

    ImporterComponent(ImporterModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new ImporterControl(this);
        this.view = new ImporterUI();
    }

    void initialize() {
        this.controller.initialize(this.view);
        this.view.initialize(this.model, this.controller);
    }

    public void activate(int type) {
        switch (this.model.getState()) {
            case 1: {
                this.showChooser(type);
                this.model.setState(2);
                break;
            }
            case 3: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    public void discard() {
        if (this.model.getState() == 3) {
            this.model.discard();
        }
    }

    public int getState() {
        return this.model.getState();
    }

    public void cancel() {
        this.model.cancel();
    }

    public void importData(ImportableObject data) {
        if (this.model.getState() != 2) {
            return;
        }
        if (data == null || data.getFiles() == null || data.getFiles().size() == 0) {
            UserNotifier un = ImporterAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Import", "No Files to import.");
            return;
        }
        this.fireStateChange();
    }

    public void monitorDirectory(File dir) {
        if (this.model.getState() != 2) {
            return;
        }
        if (dir == null) {
            UserNotifier un = ImporterAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Import", "No directory to monitor.");
            return;
        }
        this.model.fireMonitorDirectory(dir);
        this.fireStateChange();
    }

    public void setExistingTags(Collection tags) {
        this.model.setTags(tags);
        if (this.chooser != null) {
            this.chooser.setTags(tags);
        }
    }

    public void loadExistingTags() {
        Collection tags = this.model.getTags();
        if (tags != null) {
            this.setExistingTags(tags);
        } else {
            this.model.fireTagsLoading();
        }
    }
}

