/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import pojos.ExperimenterData;

public class RenderingSettingsLoader
extends DataLoader {
    private long pixelsID;
    private CallHandle handle;
    private boolean single;
    private long ownerID;

    public RenderingSettingsLoader(ImViewer viewer, long pixelsID) {
        this(viewer, pixelsID, false);
    }

    public RenderingSettingsLoader(ImViewer viewer, long pixelsID, boolean single) {
        super(viewer);
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        this.pixelsID = pixelsID;
        this.single = single;
        this.ownerID = -1L;
    }

    public void setOwner(long ownerID) {
        this.ownerID = ownerID;
    }

    public void load() {
        if (this.single) {
            ExperimenterData exp = ImViewerAgent.getUserDetails();
            this.handle = this.ivView.getRenderingSettings(this.pixelsID, exp.getId(), this);
        } else {
            this.handle = this.ivView.getRenderingSettings(this.pixelsID, this);
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 7) {
            return;
        }
        Map map = (Map)result;
        if (this.single) {
            Set set = map.entrySet();
            Iterator i = set.iterator();
            long userID = ImViewerAgent.getUserDetails().getId();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ExperimenterData exp = (ExperimenterData)entry.getKey();
                if (userID != exp.getId()) continue;
                this.viewer.setSettingsToPaste((RndProxyDef)entry.getValue());
            }
        } else {
            this.viewer.setRenderingSettings(map, this.ownerID);
        }
    }
}

