/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerPreferences {
    public static final String RENDERER = "Renderer";
    public static final String WINDOWS_BOUNDS = "Viewer Bounds";
    public static final String HISTORY = "History";
    public static final String ZOOM_FACTOR = "Zoom factor";
    public static final String SCALE_BAR = "Scale bar settings";
    public static final String BG_COLOR = "Background color";
    private boolean renderer;
    private boolean history;
    private Rectangle viewerBounds;
    private Color bgColor;
    private int zoomIndex = -2;
    private int scaleBarIndex = -1;
    private Color scaleBarColor;
    private Map<String, Boolean> fields = new HashMap<String, Boolean>(5);

    public ViewerPreferences() {
        this.fields.put(RENDERER, true);
        this.fields.put(HISTORY, true);
        this.fields.put(SCALE_BAR, true);
        this.fields.put(BG_COLOR, true);
        this.fields.put(ZOOM_FACTOR, true);
    }

    void setSelectedFields(Map<String, Boolean> fields) {
        if (fields == null) {
            return;
        }
        this.fields = fields;
    }

    public boolean isHistory() {
        return this.history;
    }

    public boolean isRenderer() {
        return this.renderer;
    }

    public void setRenderer(boolean renderer) {
        if (this.isFieldSelected(RENDERER)) {
            this.renderer = renderer;
        }
    }

    public void setHistory(boolean history) {
        if (this.isFieldSelected(HISTORY)) {
            this.history = history;
        }
    }

    public Rectangle getViewerBounds() {
        return this.viewerBounds;
    }

    public void setViewerBounds(Rectangle viewerBounds) {
        this.viewerBounds = viewerBounds;
    }

    public int getZoomIndex() {
        return this.zoomIndex;
    }

    public void setZoomIndex(int zoomIndex) {
        if (this.isFieldSelected(ZOOM_FACTOR)) {
            this.zoomIndex = zoomIndex;
        }
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public void setBackgroundColor(Color bgColor) {
        if (this.isFieldSelected(BG_COLOR)) {
            this.bgColor = bgColor;
        }
    }

    public void setScaleBarIndex(int index) {
        if (this.isFieldSelected(SCALE_BAR)) {
            this.scaleBarIndex = index;
        }
    }

    public void setScaleBarColor(Color color) {
        if (this.isFieldSelected(SCALE_BAR)) {
            this.scaleBarColor = color;
        }
    }

    public int getScaleBarIndex() {
        return this.scaleBarIndex;
    }

    public Color getScaleBarColor() {
        return this.scaleBarColor;
    }

    public boolean isFieldSelected(String field) {
        if (this.fields == null) {
            return false;
        }
        Boolean value = this.fields.get(field);
        if (value == null) {
            return false;
        }
        return value;
    }
}

