/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement;

import java.util.List;
import org.openmicroscopy.shoola.agents.events.FocusGainedEvent;
import org.openmicroscopy.shoola.agents.events.SaveData;
import org.openmicroscopy.shoola.agents.events.iviewer.ChannelSelection;
import org.openmicroscopy.shoola.agents.events.iviewer.ImageRendered;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurePlane;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewerState;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ActivityProcessEvent;
import org.openmicroscopy.shoola.env.ui.DeleteActivity;
import pojos.ExperimenterData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementAgent
implements Agent,
AgentEventListener {
    private static Registry registry;

    private void handleMeasurementToolEvent(MeasurementTool evt) {
        PixelsData pixels = evt.getPixels();
        if (pixels == null) {
            return;
        }
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(pixels.getId());
        if (viewer == null) {
            viewer = MeasurementViewerFactory.getViewer(evt.getPixels(), evt.getImageID(), evt.getName(), evt.getRequesterBounds(), evt.getDefaultZ(), evt.getDefaultT(), evt.getMagnification(), evt.getActiveChannels(), evt.getChannelData());
        }
        if (viewer != null) {
            viewer.setIconImage(evt.getThumbnail());
            viewer.setRndImage(evt.getRenderedImage());
            MeasurementViewerFactory.addRequest(evt);
            viewer.activate(evt.getMeasurements(), evt.isHCSData());
        }
    }

    private void handleMeasurePlaneEvent(MeasurePlane evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(evt.getPixelsID());
        if (viewer != null) {
            viewer.setMagnifiedPlane(evt.getDefaultZ(), evt.getDefaultT(), evt.getMagnification());
        }
    }

    private void handleViewerStateEvent(ViewerState evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(evt.getPixelsID());
        if (viewer != null) {
            switch (evt.getIndex()) {
                case 0: {
                    viewer.discard();
                    break;
                }
                case 1: {
                    viewer.iconified(false);
                    break;
                }
                case 2: {
                    viewer.iconified(true);
                }
            }
        }
    }

    private void handleFocusGainedEvent(FocusGainedEvent evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(evt.getPixelsID());
        if (viewer == null) {
            return;
        }
        if (viewer.getState() != 6 || evt.getIndex() != 1) {
            // empty if block
        }
    }

    private void handleChannelSelectionEvent(ChannelSelection evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(evt.getPixelsID());
        if (viewer != null) {
            switch (evt.getIndex()) {
                case 1: {
                    viewer.setActiveChannels(evt.getChannels());
                    break;
                }
                case 0: {
                    viewer.setActiveChannelsColor(evt.getChannels());
                }
            }
        }
    }

    private void handleSaveData(SaveData evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(evt.getPixelsID());
        if (viewer != null && evt.getType() == 0) {
            viewer.saveROIToServer();
            viewer.discard();
        }
    }

    private void handleImageRenderedEvent(ImageRendered evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(evt.getPixelsID());
        if (viewer != null) {
            viewer.setIconImage(evt.getThumbnail());
            viewer.setRndImage(evt.getRenderedImage());
        }
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        MeasurementViewerFactory.onGroupSwitched(evt.isSuccessful());
    }

    private void handleActivityFinished(ActivityProcessEvent evt) {
        if (evt == null) {
            return;
        }
        ActivityComponent comp = evt.getActivity();
        if (comp instanceof DeleteActivity) {
            MeasurementViewerFactory.onROIDeleted(((DeleteActivity)comp).getImageID());
        }
    }

    public static Registry getRegistry() {
        return registry;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    @Override
    public void activate() {
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = ctx.getEventBus();
        bus.register((AgentEventListener)this, MeasurementTool.class);
        bus.register((AgentEventListener)this, MeasurePlane.class);
        bus.register((AgentEventListener)this, ViewerState.class);
        bus.register((AgentEventListener)this, ChannelSelection.class);
        bus.register((AgentEventListener)this, SaveData.class);
        bus.register((AgentEventListener)this, FocusGainedEvent.class);
        bus.register((AgentEventListener)this, ImageRendered.class);
        bus.register((AgentEventListener)this, UserGroupSwitched.class);
        bus.register((AgentEventListener)this, ActivityProcessEvent.class);
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        List<Object> instances = MeasurementViewerFactory.getInstancesToSave();
        if (instances == null || instances.size() == 0) {
            return null;
        }
        return new AgentSaveInfo("Measurements", instances);
    }

    @Override
    public void save(List<Object> instances) {
        MeasurementViewerFactory.saveInstances(instances);
    }

    @Override
    public void terminate() {
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof MeasurementTool) {
            this.handleMeasurementToolEvent((MeasurementTool)e);
        } else if (e instanceof MeasurePlane) {
            this.handleMeasurePlaneEvent((MeasurePlane)e);
        } else if (e instanceof ViewerState) {
            this.handleViewerStateEvent((ViewerState)e);
        } else if (e instanceof ChannelSelection) {
            this.handleChannelSelectionEvent((ChannelSelection)e);
        } else if (e instanceof SaveData) {
            this.handleSaveData((SaveData)e);
        } else if (e instanceof FocusGainedEvent) {
            this.handleFocusGainedEvent((FocusGainedEvent)e);
        } else if (e instanceof ImageRendered) {
            this.handleImageRenderedEvent((ImageRendered)e);
        } else if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        } else if (e instanceof ActivityProcessEvent) {
            this.handleActivityFinished((ActivityProcessEvent)e);
        }
    }
}

