/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureListener;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.measurement.view.WorkflowDialog;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.checkboxlist.CheckBoxList;
import org.openmicroscopy.shoola.util.ui.checkboxlist.CheckBoxModel;
import pojos.WorkflowData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkflowPanel
extends JDialog
implements ComponentListener {
    private JLabel label;
    private JLabel namespaceLabel;
    private JComboBox namespaceCombobox;
    private CheckBoxList keywords;
    private MeasurementViewerUI view;
    private MeasurementViewerModel model;
    private MeasurementViewerControl controller;
    private CheckBoxModel checkBoxModel;
    private WorkflowDialog workflowDialog;
    private MouseAdapter listener;

    private void init() {
        this.label = new JLabel("Keywords");
        this.namespaceLabel = new JLabel("Namespace");
        List<String> list = this.model.getWorkflows();
        String[] values = new String[list.size()];
        Iterator<String> i = list.iterator();
        int index = 0;
        while (i.hasNext()) {
            values[index] = this.view.getWorkflowDisplay(i.next());
        }
        this.namespaceCombobox = new JComboBox<String>(values);
        this.namespaceCombobox.addActionListener(this.controller.getAction(MeasurementViewerControl.SELECT_WORKFLOW));
        this.checkBoxModel = new CheckBoxModel();
        this.keywords = new CheckBoxList(this.checkBoxModel);
        this.listener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CheckBoxList checkBoxList = (CheckBoxList)e.getSource();
                List<String> keywords = checkBoxList.getTrueValues();
                String value = WorkflowPanel.this.view.getWorkflowFromDisplay((String)WorkflowPanel.this.namespaceCombobox.getSelectedItem());
                WorkflowPanel.this.model.setWorkflow(value);
                WorkflowPanel.this.model.setKeyword(keywords);
                WorkflowPanel.this.applyWorkflowToCollection(WorkflowPanel.this.view.getDrawingView().getSelectedFigures());
                WorkflowPanel.this.view.rebuildManagerTable();
                WorkflowPanel.this.view.refreshInspectorTable();
            }
        };
        this.keywords.addMouseListener(this.listener);
        this.addComponentListener(this);
        this.workflowDialog = new WorkflowDialog(this.view, this.model);
    }

    private void buildUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        JPanel j = new JPanel();
        j.setLayout(new BoxLayout(j, 0));
        j.add(this.namespaceLabel);
        Dimension d = new Dimension(200, 30);
        this.namespaceCombobox.setSize(d);
        this.namespaceCombobox.setMinimumSize(d);
        this.namespaceCombobox.setMaximumSize(d);
        this.namespaceCombobox.setPreferredSize(d);
        j.add(this.namespaceCombobox);
        panel.add(j);
        JPanel k = new JPanel();
        k.setLayout(new BoxLayout(k, 1));
        k.add(this.label);
        JScrollPane scrollPane = new JScrollPane(this.keywords);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        k.add(scrollPane);
        panel.add(k);
        JPanel bevelPanel = new JPanel();
        bevelPanel.setLayout(new BorderLayout());
        bevelPanel.setBorder(BorderFactory.createBevelBorder(1));
        bevelPanel.add((Component)panel, "Center");
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)bevelPanel, "Center");
        this.setVisible(false);
        this.setSize(300, 200);
    }

    private void applyWorkflowToCollection(Collection<Figure> figures) {
        for (Figure fig : figures) {
            ROIFigure roiFigure = (ROIFigure)fig;
            List<FigureListener> figureListeners = roiFigure.getFigureListeners();
            for (FigureListener listener : figureListeners) {
                roiFigure.removeFigureListener(listener);
            }
            this.applyWorkflow(roiFigure);
            for (FigureListener listener : figureListeners) {
                roiFigure.addFigureListener(listener);
            }
        }
    }

    private void applyWorkflow(ROIFigure fig) {
        fig.getROI().setAnnotation(AnnotationKeys.NAMESPACE, this.model.getWorkflow().getNameSpace());
        List<String> keywordList = this.model.getKeywords();
        String keywordString = "";
        for (int i = 0; i < keywordList.size(); ++i) {
            keywordString = keywordString + keywordList.get(i);
            if (i >= keywordList.size() - 1) continue;
            keywordString = keywordString + ", ";
        }
        fig.getROI().setAnnotation(AnnotationKeys.KEYWORDS, keywordString);
    }

    WorkflowPanel(MeasurementViewerUI view, MeasurementViewerModel model, MeasurementViewerControl controller) {
        this.view = view;
        this.model = model;
        this.controller = controller;
        this.init();
        this.buildUI();
    }

    void updateWorkflow() {
        WorkflowData workflow = this.model.getWorkflow();
        if (workflow == null) {
            this.namespaceCombobox.removeActionListener(this.controller.getAction(MeasurementViewerControl.SELECT_WORKFLOW));
            this.namespaceCombobox.setSelectedItem(WorkflowData.DEFAULTWORKFLOW);
            this.keywords.setModel(new CheckBoxModel(new ArrayList<String>()));
            this.namespaceCombobox.addActionListener(this.controller.getAction(MeasurementViewerControl.SELECT_WORKFLOW));
        } else {
            this.namespaceCombobox.removeActionListener(this.controller.getAction(MeasurementViewerControl.SELECT_WORKFLOW));
            this.namespaceCombobox.setSelectedItem(this.view.getWorkflowDisplay(workflow.getNameSpace()));
            this.namespaceCombobox.addActionListener(this.controller.getAction(MeasurementViewerControl.SELECT_WORKFLOW));
            List list = workflow.getKeywordsAsList();
            CheckBoxModel tableModel = new CheckBoxModel(list);
            this.keywords.setModel(tableModel);
            List<String> words = this.model.getKeywords();
            this.keywords.setTrueValues(words);
            this.repaint();
            if (!this.isVisible()) {
                UIUtilities.setLocationRelativeToAndSizeToWindow(this.view, (Component)this, new Dimension(this.getWidth(), this.getHeight()));
            }
        }
    }

    void addedWorkflow() {
        this.namespaceCombobox.removeActionListener(this.controller.getAction(MeasurementViewerControl.SELECT_WORKFLOW));
        this.namespaceCombobox.removeAllItems();
        List<String> list = this.model.getWorkflows();
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            this.namespaceCombobox.addItem(this.view.getWorkflowDisplay(i.next()));
        }
        this.namespaceCombobox.addActionListener(this.controller.getAction(MeasurementViewerControl.SELECT_WORKFLOW));
    }

    void createWorkflow() {
        UIUtilities.centerAndShow(this.workflowDialog);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

