/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import omero.ResourceError;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.log.LogMessage;

public class ScriptLoader
extends EditorLoader {
    private CallHandle handle;
    private long scriptID;

    public ScriptLoader(Editor viewer, long scriptID) {
        super(viewer);
        if (scriptID < 0L) {
            throw new IllegalArgumentException("No script specified.");
        }
        this.scriptID = scriptID;
    }

    public void load() {
        this.handle = this.mhView.loadScript(this.scriptID, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        this.viewer.setScript((ScriptObject)result);
    }

    public void handleException(Throwable exc) {
        this.viewer.setStatus(false);
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        if (exc instanceof ProcessException) {
            ProcessException se = (ProcessException)exc;
            s = se.getMessage();
            Throwable cause = se.getCause();
            if (cause instanceof ResourceError) {
                ResourceError re = (ResourceError)cause;
                s = s + String.format("\nError: \"%s\"", re.message);
            } else if (cause != null && cause.getMessage() != null) {
                s = s + ":" + cause.getMessage();
            }
            this.registry.getUserNotifier().notifyInfo("Running Script", s + "\nPlease contact your administrator.");
        } else {
            this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        }
    }
}

