/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.DataObjectListCellRenderer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.AnalysisResultsHandlingParam;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.BMPFilter;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.filter.file.TIFFFilter;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.TagAnnotationData;

class DocComponent
extends JPanel
implements ActionListener,
PropertyChangeListener {
    static final int LOAD_FROM_SERVER = 0;
    static final int LOAD_FROM_LOCAL = 1;
    private static final int UNLINK = 0;
    private static final int EDIT = 1;
    private static final int DOWNLOAD = 2;
    private static final int OPEN = 3;
    private static final int DELETE = 4;
    private static final int MENU = 5;
    private static final int PLOT = 6;
    private static final List<CustomizedFileFilter> FILTERS = new ArrayList<CustomizedFileFilter>();
    private Object data;
    private EditorModel model;
    private JMenuItem unlinkButton;
    private JMenuItem editButton;
    private JMenuItem downloadButton;
    private JMenuItem openButton;
    private JMenuItem plotButton;
    private JMenuItem deleteButton;
    private JLabel label;
    private Point popupPoint;
    private String originalDescription;
    private String originalName;
    private JButton menuButton;
    private int imageToLoad;
    private Icon thumbnail;
    private JPopupMenu popMenu;
    private boolean deletable;

    private boolean setControlsEnabled(boolean enabled) {
        boolean b = enabled;
        boolean link = enabled;
        int count = 0;
        if (enabled && this.data != null) {
            b = this.model.isUserOwner(this.data);
            link = this.model.isLinkOwner(this.data);
        }
        if (this.unlinkButton != null) {
            this.unlinkButton.setEnabled(link);
            this.unlinkButton.setVisible(link);
            if (link) {
                ++count;
            }
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(b);
            this.editButton.setVisible(b);
            if (b) {
                ++count;
            }
        }
        if (this.downloadButton != null) {
            this.downloadButton.setEnabled(link);
            this.downloadButton.setVisible(link);
            if (link) {
                ++count;
            }
        }
        if (this.openButton != null) {
            this.openButton.setEnabled(link);
            this.openButton.setVisible(link);
            if (link) {
                ++count;
            }
        }
        if (this.plotButton != null) {
            this.plotButton.setEnabled(link);
            this.plotButton.setVisible(link);
            if (link) {
                ++count;
            }
        }
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(b);
            this.deleteButton.setVisible(b);
            if (b) {
                ++count;
            }
        }
        return count > 0;
    }

    private void openFile() {
        if (!(this.data instanceof FileAnnotationData)) {
            return;
        }
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        bus.post(new EditFileEvent((FileAnnotationData)this.data));
    }

    private void showMenu(JComponent invoker, Point p) {
        if (this.popMenu == null) {
            this.popMenu = new JPopupMenu();
            if (this.editButton != null) {
                this.popMenu.add(this.editButton);
            }
            if (this.unlinkButton != null) {
                this.popMenu.add(this.unlinkButton);
            }
            if (this.downloadButton != null) {
                this.popMenu.add(this.downloadButton);
            }
            if (this.openButton != null) {
                this.popMenu.add(this.openButton);
            }
            if (this.plotButton != null) {
                this.popMenu.add(this.plotButton);
            }
            if (this.deleteButton != null) {
                this.popMenu.add(this.deleteButton);
            }
        }
        this.popMenu.show(invoker, p.x, p.y);
    }

    private void checkAnnotators(StringBuffer buf, AnnotationData annotation) {
        List<ExperimenterData> annotators = this.model.getAnnotators(annotation);
        if (annotators.size() == 0) {
            return;
        }
        Iterator<ExperimenterData> i = annotators.iterator();
        buf.append("<b>Added by:</b><br>");
        while (i.hasNext()) {
            ExperimenterData annotator = i.next();
            buf.append(EditorUtil.formatExperimenter(annotator) + "<br>");
        }
        if (annotators.size() > 1) {
            String text = this.label.getText();
            text = text + " [" + annotators.size() + "]";
            this.label.setText(text);
        }
    }

    private String formatTootTip(AnnotationData annotation) {
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        ExperimenterData exp = null;
        if (annotation.getId() > 0L) {
            exp = this.model.getOwner((DataObject)annotation);
        }
        if (exp != null) {
            buf.append("<b>");
            buf.append("Owner: ");
            buf.append("</b>");
            buf.append(EditorUtil.formatExperimenter(exp));
            buf.append("<br>");
        }
        if (this.data instanceof FileAnnotationData) {
            String ns = ((FileAnnotationData)this.data).getNameSpace();
            if ("openmicroscopy.org/omero/editor/experiment".equals(ns)) {
                buf.append("<b>");
                buf.append("Editor File: ");
                buf.append("</b>");
                buf.append("Experiment");
                buf.append("<br>");
                buf.append("<b>");
            } else if ("openmicroscopy.org/omero/editor/protocol".equals(ns)) {
                buf.append("<b>");
                buf.append("Editor File: ");
                buf.append("</b>");
                buf.append("Protocol");
                buf.append("<br>");
                buf.append("<b>");
            }
            if (annotation.getId() > 0L) {
                buf.append("<b>");
                buf.append("File ID: ");
                buf.append("</b>");
                FileAnnotationData fa = (FileAnnotationData)this.data;
                buf.append(fa.getFileID());
                buf.append("<br>");
                buf.append("<b>");
                buf.append("Date Added: ");
                buf.append("</b>");
                buf.append(UIUtilities.formatWDMYDate(annotation.getLastModified()));
                buf.append("<br>");
                buf.append("<b>");
            }
            buf.append("Size: ");
            buf.append("</b>");
            long size = ((FileAnnotationData)annotation).getFileSize();
            buf.append(UIUtilities.formatFileSize(size / 1000L));
            buf.append("<br>");
            this.checkAnnotators(buf, annotation);
        } else if (this.data instanceof TagAnnotationData) {
            this.checkAnnotators(buf, annotation);
        }
        buf.append("</body></html>");
        return buf.toString();
    }

    private void postFileClicked() {
        if (this.data == null) {
            return;
        }
        if (this.data instanceof FileAnnotationData) {
            FileAnnotationData f = (FileAnnotationData)this.data;
            Registry reg = MetadataViewerAgent.getRegistry();
            reg.getEventBus().post(new EditFileEvent(f));
        }
    }

    private void initButtons() {
        IconManager icons = IconManager.getInstance();
        this.menuButton = new JButton(icons.getIcon(96));
        UIUtilities.unifiedButtonLookAndFeel(this.menuButton);
        this.menuButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.menuButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                DocComponent.this.showMenu(DocComponent.this.menuButton, p);
            }
        });
        this.unlinkButton = new JMenuItem(icons.getIcon(57));
        this.unlinkButton.setText("Unlink");
        this.unlinkButton.addActionListener(this);
        this.unlinkButton.setActionCommand("0");
        if (this.data instanceof FileAnnotationData) {
            FileAnnotationData fa = (FileAnnotationData)this.data;
            this.unlinkButton.setToolTipText("Remove the attachment.");
            if (fa.getId() > 0L) {
                if (this.deletable) {
                    this.deleteButton = new JMenuItem(icons.getIcon(83));
                    this.deleteButton.setText("Delete");
                    this.deleteButton.addActionListener(this);
                    this.deleteButton.setActionCommand("4");
                }
                this.downloadButton = new JMenuItem(icons.getIcon(59));
                this.downloadButton.setText("Download...");
                this.downloadButton.setToolTipText("Download the selected file.");
                this.downloadButton.setActionCommand("2");
                this.downloadButton.addActionListener(this);
                String ns = fa.getNameSpace();
                this.openButton = new JMenuItem(icons.getIcon(60));
                this.openButton.setText("View");
                this.openButton.setToolTipText("View the file.");
                this.openButton.setActionCommand("3");
                this.openButton.addActionListener(this);
                if ("openmicroscopy.org/omero/analysis/flim".equals(ns)) {
                    this.plotButton = new JMenuItem(icons.getIcon(113));
                    this.plotButton.setText("Plot");
                    this.plotButton.setToolTipText("Plot the results.");
                    this.plotButton.setActionCommand("6");
                    this.plotButton.addActionListener(this);
                }
                if ("openmicroscopy.org/omero/import/companionFile".equals(ns) || "openmicroscopy.org/omero/measurement".equals(ns)) {
                    this.unlinkButton = null;
                }
            }
        } else if (this.data instanceof TagAnnotationData) {
            this.unlinkButton.setToolTipText("Remove the Tag.");
            this.editButton = new JMenuItem(icons.getIcon(54));
            this.editButton.setText("Edit");
            this.editButton.setActionCommand("1");
            this.editButton.addActionListener(this);
            this.editButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    DocComponent.this.popupPoint = e.getPoint();
                }
            });
        }
    }

    private void initComponents() {
        this.imageToLoad = -1;
        if (this.model.isUserOwner(this.data)) {
            this.initButtons();
        }
        this.label = new JLabel();
        this.label.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        if (this.data == null) {
            this.label.setText("None");
        } else if (this.data instanceof FileAnnotationData) {
            FileAnnotationData f = (FileAnnotationData)this.data;
            String fileName = f.getFileName();
            if ("openmicroscopy.org/omero/measurement".equals(fileName)) {
                this.label.setText(f.getDescription());
            } else {
                this.label.setText(EditorUtil.getPartialName(fileName));
            }
            this.label.setToolTipText(this.formatTootTip((AnnotationData)f));
            Iterator<CustomizedFileFilter> i = FILTERS.iterator();
            long id = f.getId();
            while (i.hasNext()) {
                CustomizedFileFilter filter = i.next();
                if (!filter.accept(fileName)) continue;
                this.imageToLoad = id > 0L ? 0 : 1;
                break;
            }
            this.initButtons();
            if (id < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
            switch (this.imageToLoad) {
                case 1: {
                    if (this.thumbnail != null) break;
                    this.setThumbnail(f.getFilePath());
                }
            }
        } else if (this.data instanceof File) {
            this.initButtons();
            File f = (File)this.data;
            this.label.setText(f.getName());
            this.label.setForeground(Color.BLUE);
        } else if (this.data instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)this.data;
            this.label.setText(tag.getTagValue());
            this.label.setToolTipText(this.formatTootTip((AnnotationData)tag));
            this.initButtons();
            if (tag.getId() < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
        }
        this.label.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    if (e.isPopupTrigger()) {
                        DocComponent.this.showMenu(DocComponent.this.label, e.getPoint());
                    }
                } else if (e.getClickCount() == 2) {
                    DocComponent.this.postFileClicked();
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DocComponent.this.showMenu(DocComponent.this.label, e.getPoint());
                }
            }
        });
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.label);
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.setOpaque(true);
        boolean b = this.setControlsEnabled(this.data != null);
        int count = 0;
        if (this.editButton != null) {
            ++count;
        }
        if (this.unlinkButton != null) {
            ++count;
        }
        if (this.downloadButton != null) {
            ++count;
        }
        if (this.plotButton != null) {
            ++count;
        }
        if (this.openButton != null) {
            ++count;
        }
        if (this.deleteButton != null) {
            ++count;
        }
        if (count > 0) {
            bar.add(this.menuButton);
            if (!b) {
                bar.add(Box.createHorizontalStrut(8));
            }
            this.add(bar);
        }
    }

    private void editDescription() {
        String text;
        TagAnnotationData tag = (TagAnnotationData)this.data;
        this.originalDescription = text = this.model.getTagDescription(tag);
        this.originalName = tag.getTagValue();
        SwingUtilities.convertPointToScreen(this.popupPoint, this);
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        EditorDialog d = new EditorDialog(f, (DataObject)tag, false, 1);
        d.addPropertyChangeListener(this);
        d.setOriginalDescription(this.originalDescription);
        d.setSize(300, 250);
        UIUtilities.showOnScreen(d, this.popupPoint);
    }

    private void download() {
        String name = null;
        if (this.data instanceof FileAnnotationData) {
            name = ((FileAnnotationData)this.data).getFileName();
        }
        JFrame f = EditorAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 1, "Download", "Select where to download the file.", null, true);
        if (name != null && name.trim().length() > 0) {
            chooser.setSelectedFileFull(name);
        }
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(78));
        chooser.setApproveButtonText("Download");
        chooser.addPropertyChangeListener(this);
        chooser.centerDialog();
    }

    private void plotResults() {
        String value = MetadataViewerAgent.getOmeroFilesHome();
        FileAnnotationData fa = (FileAnnotationData)this.data;
        OriginalFile of = (OriginalFile)fa.getContent();
        value = value + File.separator + fa.getFileName();
        DownloadActivityParam activity = new DownloadActivityParam(of, new File(value), null);
        AnalysisResultsHandlingParam p = new AnalysisResultsHandlingParam(0);
        activity.setResults(p);
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        un.notifyActivity(activity);
    }

    DocComponent(Object data, EditorModel model, boolean deletable) {
        if (model == null) {
            throw new IllegalArgumentException("No Model.");
        }
        this.originalDescription = null;
        this.model = model;
        this.data = data;
        this.deletable = deletable;
        this.initComponents();
        this.buildGUI();
    }

    DocComponent(Object data, EditorModel model) {
        this(data, model, true);
    }

    boolean hasThumbnailToLoad() {
        return false;
    }

    Object getData() {
        return this.data;
    }

    boolean hasBeenModified() {
        if (this.originalName == null) {
            return false;
        }
        if (this.data instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)this.data;
            if (!this.originalName.equals(tag.getTagValue())) {
                return true;
            }
            String txt = tag.getTagDescription();
            if (txt != null) {
                return !this.originalDescription.equals(txt);
            }
            return false;
        }
        return false;
    }

    boolean isImageLoaded() {
        return this.thumbnail != null;
    }

    boolean canUnlink() {
        if (this.unlinkButton == null) {
            return false;
        }
        return this.unlinkButton.isVisible();
    }

    void setThumbnail(String path) {
        if (path == null) {
            return;
        }
        this.thumbnail = Factory.createIcon(path, 48, 48);
        if (this.thumbnail != null) {
            this.label.setText("");
            this.label.setIcon(this.thumbnail);
            this.label.repaint();
            this.revalidate();
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.firePropertyChange("removeAnnotation", null, this);
                break;
            }
            case 4: {
                this.firePropertyChange("deleteAnnotation", null, this);
                break;
            }
            case 1: {
                this.editDescription();
                break;
            }
            case 2: {
                this.download();
                break;
            }
            case 3: {
                this.openFile();
                break;
            }
            case 6: {
                this.plotResults();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("createNoParent".equals(name)) {
            TagAnnotationData tag = (TagAnnotationData)this.data;
            this.label.setText(tag.getTagValue());
            this.label.setToolTipText(this.formatTootTip((AnnotationData)tag));
            this.firePropertyChange("editTag", null, this);
        } else if ("approveSelection".equals(name)) {
            File folder = (File)evt.getNewValue();
            if (folder == null) {
                folder = UIUtilities.getDefaultFolder();
            }
            UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
            if (this.data == null) {
                return;
            }
            FileAnnotationData fa = (FileAnnotationData)this.data;
            OriginalFile f = (OriginalFile)fa.getContent();
            IconManager icons = IconManager.getInstance();
            DownloadActivityParam activity = new DownloadActivityParam(f, folder, icons.getIcon(77));
            activity.setLegend(fa.getDescription());
            un.notifyActivity(activity);
        }
    }

    static {
        FILTERS.add(new TIFFFilter());
        FILTERS.add(new JPEGFilter());
        FILTERS.add(new PNGFilter());
        FILTERS.add(new BMPFilter());
    }
}

