/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.PropertiesUI;
import org.openmicroscopy.shoola.agents.metadata.editor.TextualAnnotationsUI;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.editorpreview.PreviewPanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.AnnotationData;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GeneralPaneUI
extends JScrollPane {
    private static final String DETAILS = "'s details";
    private static final String PROTOCOL = "Protocols and Experiments";
    private EditorControl controller;
    private EditorModel model;
    private EditorUI view;
    private PropertiesUI propertiesUI;
    private TextualAnnotationsUI textualAnnotationsUI;
    private AnnotationDataUI annotationUI;
    private JXTaskPane browserTaskPane;
    private JXTaskPane propertiesTaskPane;
    private JXTaskPane annotationTaskPane;
    private List<AnnotationUI> components;
    private JXTaskPane protocolTaskPane;
    private List<PreviewPanel> previews;
    private boolean init;
    private JXTaskPaneContainer container;

    private void loadParents(boolean b) {
        if (b) {
            this.controller.loadParents();
        } else {
            this.model.cancelParentsLoading();
        }
    }

    private void initComponents() {
        this.container = new JXTaskPaneContainer();
        this.container.setBackground(UIUtilities.BACKGROUND);
        if (this.container.getLayout() instanceof VerticalLayout) {
            VerticalLayout vl = (VerticalLayout)this.container.getLayout();
            vl.setGap(0);
        }
        if (this.model.getBrowser() != null) {
            this.browserTaskPane = EditorUtil.createTaskPane("Contained in");
            this.browserTaskPane.add((Component)this.model.getBrowser().getUI());
            this.browserTaskPane.addPropertyChangeListener((PropertyChangeListener)this.controller);
        }
        this.protocolTaskPane = EditorUtil.createTaskPane(PROTOCOL);
        this.propertiesUI = new PropertiesUI(this.model, this.controller);
        this.textualAnnotationsUI = new TextualAnnotationsUI(this.model, this.controller);
        this.annotationUI = new AnnotationDataUI(this.model, this.controller);
        this.components = new ArrayList<AnnotationUI>();
        this.components.add(this.propertiesUI);
        this.components.add(this.textualAnnotationsUI);
        this.components.add(this.annotationUI);
        Iterator<AnnotationUI> i = this.components.iterator();
        while (i.hasNext()) {
            i.next().addPropertyChangeListener("save", this.controller);
        }
        this.previews = new ArrayList<PreviewPanel>();
        this.propertiesTaskPane = EditorUtil.createTaskPane("");
        this.propertiesTaskPane.setCollapsed(false);
        this.propertiesTaskPane.add((Component)this.propertiesUI);
        this.annotationTaskPane = EditorUtil.createTaskPane("Annotations");
        this.annotationTaskPane.setCollapsed(false);
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.annotationUI);
        p.add(this.textualAnnotationsUI);
        this.annotationTaskPane.add((Component)p);
    }

    private void buildGUI() {
        this.container.add(this.propertiesTaskPane);
        this.container.add(this.annotationTaskPane);
        JViewport viewport = this.getViewport();
        viewport.add((Component)this.container);
        viewport.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    private JXTaskPaneContainer buildProtocolTaskPanes() {
        Collection list = this.model.getAttachments();
        if (list.size() == 0) {
            return null;
        }
        JXTaskPaneContainer paneContainer = new JXTaskPaneContainer();
        VerticalLayout vl = (VerticalLayout)paneContainer.getLayout();
        vl.setGap(0);
        paneContainer.setBackground(UIUtilities.BACKGROUND_COLOR);
        Iterator i = list.iterator();
        int index = 0;
        this.previews.clear();
        while (i.hasNext()) {
            String description;
            FileAnnotationData fa = (FileAnnotationData)i.next();
            String ns = fa.getNameSpace();
            boolean b = this.annotationUI.isEditorFile(fa.getFileName());
            if (!b) {
                b = this.annotationUI.isEditorFile(ns);
            }
            if (fa.getId() <= 0L || !b || (description = fa.getDescription()) == null) continue;
            PreviewPanel preview = new PreviewPanel(description, fa.getId());
            this.previews.add(preview);
            preview.addPropertyChangeListener(this.controller);
            JXTaskPane pane = EditorUtil.createTaskPane(fa.getFileName());
            pane.addPropertyChangeListener((PropertyChangeListener)this.controller);
            pane.add((Component)preview);
            paneContainer.add(pane);
            ++index;
        }
        if (index == 0) {
            return null;
        }
        return paneContainer;
    }

    GeneralPaneUI(EditorUI view, EditorModel model, EditorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.model = model;
        this.controller = controller;
        this.view = view;
        this.initComponents();
        this.init = false;
    }

    void layoutUI() {
        if (!this.init) {
            this.buildGUI();
            this.init = true;
        }
        this.propertiesUI.buildUI();
        this.annotationUI.buildUI();
        this.textualAnnotationsUI.buildUI();
        this.propertiesTaskPane.setTitle(this.propertiesUI.getText() + DETAILS);
        double h = 0.0;
        String s = "";
        boolean multi = this.model.isMultiSelection();
        Object refObject = this.model.getRefObject();
        if (refObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)refObject;
            if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                this.browserTaskPane.setCollapsed(true);
            } else if (!multi) {
                h = 1.0;
                s = "Contained in Tag Sets";
            }
        } else if (refObject instanceof FileAnnotationData) {
            if (!multi) {
                h = 1.0;
                s = "Attached to...";
            }
        } else if (refObject instanceof DatasetData) {
            if (!multi) {
                h = 1.0;
                s = "Contained in Projects";
            }
        } else if (refObject instanceof ImageData) {
            if (!multi) {
                h = 1.0;
                s = "Contained in Datasets";
                this.controller.loadChannelData();
            }
        } else if (refObject instanceof WellSampleData) {
            if (!multi) {
                this.controller.loadChannelData();
            }
        } else if (refObject instanceof ProjectData || refObject instanceof ScreenData || refObject instanceof WellSampleData) {
            this.browserTaskPane.setCollapsed(true);
        }
        this.browserTaskPane.setTitle(s);
        this.container.remove(this.protocolTaskPane);
        this.container.remove(this.browserTaskPane);
        this.protocolTaskPane.removeAll();
        JXTaskPaneContainer n = this.buildProtocolTaskPanes();
        if (n != null) {
            this.protocolTaskPane.add((Component)n);
            this.container.add(this.protocolTaskPane);
        }
        if (h > 0.0) {
            this.container.add(this.browserTaskPane);
            if (!this.browserTaskPane.isCollapsed()) {
                this.loadParents(true);
            }
        }
    }

    Map<Integer, List<AnnotationData>> prepareDataToSave() {
        if (!this.model.isMultiSelection()) {
            this.propertiesUI.updateDataObject();
        }
        ArrayList<AnnotationData> toAdd = new ArrayList<AnnotationData>();
        ArrayList<AnnotationData> toRemove = new ArrayList<AnnotationData>();
        List<AnnotationData> l = this.annotationUI.getAnnotationToSave();
        if (l != null && l.size() > 0) {
            toAdd.addAll(l);
        }
        if ((l = this.textualAnnotationsUI.getAnnotationToSave()) != null && l.size() > 0) {
            toAdd.addAll(l);
        }
        if ((l = this.annotationUI.getAnnotationToRemove()) != null && l.size() > 0) {
            toRemove.addAll(l);
        }
        if ((l = this.textualAnnotationsUI.getAnnotationToRemove()) != null && l.size() > 0) {
            toRemove.addAll(l);
        }
        HashMap<Integer, List<AnnotationData>> map = new HashMap<Integer, List<AnnotationData>>();
        map.put(0, toAdd);
        map.put(1, toRemove);
        return map;
    }

    void setParentRootObject() {
        this.propertiesUI.setParentRootObject();
    }

    void setRootObject() {
        TagAnnotationData tag;
        if (!this.init) {
            this.buildGUI();
            this.init = true;
        }
        this.clearData();
        this.textualAnnotationsUI.clearDisplay();
        this.propertiesUI.clearDisplay();
        this.annotationUI.clearDisplay();
        this.textualAnnotationsUI.clearDisplay();
        this.propertiesUI.buildUI();
        Object uo = this.model.getRefObject();
        int annotation = 0;
        int browser = 0;
        if (!(uo instanceof AnnotationData)) {
            annotation = 1;
            if (!this.model.isMultiSelection()) {
                browser = 1;
            }
        }
        if (uo instanceof FileAnnotationData) {
            if (!this.model.isMultiSelection()) {
                browser = 1;
            }
        } else if (uo instanceof TagAnnotationData && !"openmicroscopy.org/omero/insight/tagset".equals((tag = (TagAnnotationData)uo).getNameSpace()) && !this.model.isMultiSelection()) {
            browser = 1;
        }
        this.container.remove(this.annotationTaskPane);
        this.container.remove(this.protocolTaskPane);
        this.container.remove(this.browserTaskPane);
        if (annotation > 0) {
            this.container.add(this.annotationTaskPane);
        }
        if (this.protocolTaskPane.getComponentCount() > 0) {
            this.container.add(this.protocolTaskPane);
        }
        if (browser > 0) {
            this.container.add(this.browserTaskPane);
        }
        this.revalidate();
        this.repaint();
    }

    List<TagAnnotationData> getCurrentTagsSelection() {
        return this.annotationUI.getCurrentTagsSelection();
    }

    List<FileAnnotationData> getCurrentAttachmentsSelection() {
        return this.annotationUI.getCurrentAttachmentsSelection();
    }

    void setChannelData() {
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            this.propertiesUI.setChannelData(this.model.getChannelData());
        }
    }

    boolean hasDataToSave() {
        for (AnnotationUI ui : this.components) {
            if (!ui.hasDataToSave()) continue;
            return true;
        }
        for (PreviewPanel pp : this.previews) {
            if (!pp.hasDataToSave()) continue;
            return true;
        }
        return false;
    }

    void clearData() {
        for (AnnotationUI ui : this.components) {
            ui.clearData();
            ui.clearDisplay();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    void handleTaskPaneCollapsed(JXTaskPane source) {
        if (source == null) {
            return;
        }
        if (source.equals(this.browserTaskPane)) {
            this.loadParents(!this.browserTaskPane.isCollapsed());
        }
    }

    boolean attachFile(File file) {
        return this.annotationUI.attachFile(file);
    }

    void removeAttachedFile(Object file) {
        this.annotationUI.removeAttachedFile(file);
    }

    List<FileAnnotationData> removeAttachedFiles() {
        return this.annotationUI.removeAttachedFiles();
    }

    List<TagAnnotationData> removeTags() {
        return this.annotationUI.removeTags();
    }

    void removeTag(TagAnnotationData tag) {
        if (tag == null) {
            return;
        }
        this.annotationUI.removeTag(tag);
    }

    void handleObjectsSelection(Class type, Collection objects) {
        if (objects == null) {
            return;
        }
        this.annotationUI.handleObjectsSelection(type, objects, true);
    }
}

