/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openmicroscopy.shoola.util.ui.OptionsDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ChannelData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelSelectionDialog
extends OptionsDialog {
    public static final String CHANNEL_ANALYSIS_SELECTION_PROPERTY = "channelAnalysisSelection";
    private Map<JRadioButton, ChannelData> channelSelection;
    private int index;

    private void initialize(List<ChannelData> channels) {
        this.setYesText("Analyse");
        this.hideNoButton();
        this.addCancelButton();
        this.setResizable(true);
        this.channelSelection = new LinkedHashMap<JRadioButton, ChannelData>();
        Iterator<ChannelData> i = channels.iterator();
        int index = 0;
        ButtonGroup group = new ButtonGroup();
        while (i.hasNext()) {
            ChannelData data = i.next();
            JRadioButton box = new JRadioButton(data.getChannelLabeling());
            this.channelSelection.put(box, data);
            if (index == 0) {
                box.setSelected(true);
            }
            ++index;
            group.add(box);
        }
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        for (Map.Entry<JRadioButton, ChannelData> entry : this.channelSelection.entrySet()) {
            p.add(entry.getKey());
        }
        this.addBodyComponent(UIUtilities.buildComponentPanel(p));
    }

    @Override
    protected void onYesSelection() {
        Iterator<Map.Entry<JRadioButton, ChannelData>> i = this.channelSelection.entrySet().iterator();
        ChannelData data = null;
        while (i.hasNext()) {
            Map.Entry<JRadioButton, ChannelData> entry = i.next();
            JRadioButton b = entry.getKey();
            if (!b.isSelected()) continue;
            data = entry.getValue();
            break;
        }
        if (data == null) {
            return;
        }
        ArrayList<Object> l = new ArrayList<Object>(2);
        l.add(data);
        l.add(this.index);
        this.firePropertyChange(CHANNEL_ANALYSIS_SELECTION_PROPERTY, null, l);
    }

    public ChannelSelectionDialog(JFrame parent, Icon icon, List<ChannelData> channels, int index) {
        super(parent, "Channel Selection", "Select the channel to analyze.", icon);
        this.index = index;
        this.initialize(channels);
        this.buildGUI();
        this.setSize(450, 200);
    }
}

