/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private IconManager icons;
    private long currentUserID;
    private Font defaultFont;

    private void setIcon(Object usrObject) {
        Icon icon = null;
        if (usrObject instanceof ProjectData) {
            icon = this.icons.getIcon(8);
        } else if (usrObject instanceof DatasetData) {
            icon = this.icons.getIcon(9);
        } else if (usrObject instanceof ImageData) {
            icon = this.icons.getIcon(7);
        } else if (usrObject instanceof ImageData) {
            icon = this.icons.getIcon(7);
        } else if (usrObject instanceof ScreenData) {
            icon = this.icons.getIcon(47);
        } else if (usrObject instanceof PlateData) {
            icon = this.icons.getIcon(48);
        } else if (usrObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)usrObject;
            icon = "openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace()) ? this.icons.getIcon(58) : this.icons.getIcon(3);
        } else if (usrObject instanceof String) {
            icon = null;
        }
        this.setIcon(icon);
    }

    public TreeCellRenderer() {
        ExperimenterData exp = (ExperimenterData)MetadataViewerAgent.getRegistry().lookup("/current_user/details");
        this.currentUserID = exp.getId();
        this.icons = IconManager.getInstance();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!(value instanceof TreeBrowserDisplay)) {
            return this;
        }
        if (this.defaultFont == null) {
            this.defaultFont = this.getFont();
        }
        TreeBrowserDisplay node = (TreeBrowserDisplay)value;
        Object object = node.getUserObject();
        Icon icon = node.getDefaultIcon();
        if (object instanceof String) {
            this.setIcon(null);
        }
        this.setFont(this.defaultFont);
        if (icon != null) {
            this.setIcon(icon);
            if (object instanceof String) {
                this.setFont(this.defaultFont.deriveFont(2, 10.0f));
            }
        } else {
            this.setIcon(object);
        }
        return this;
    }
}

