/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.actions.AddAction;
import org.openmicroscopy.shoola.agents.metadata.actions.BrowseAction;
import org.openmicroscopy.shoola.agents.metadata.actions.MetadataViewerAction;
import org.openmicroscopy.shoola.agents.metadata.actions.RefreshAction;
import org.openmicroscopy.shoola.agents.metadata.actions.RemoveAction;
import org.openmicroscopy.shoola.agents.metadata.actions.RemoveAllAction;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerUI;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.AnalysisActivityParam;
import org.openmicroscopy.shoola.env.data.model.AnalysisParam;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ChannelData;
import pojos.ImageData;

class MetadataViewerControl
implements ChangeListener,
PropertyChangeListener {
    static final Integer REFRESH = 0;
    static final Integer BROWSE = 1;
    static final Integer REMOVE = 2;
    static final Integer REMOVE_ALL = 3;
    static final Integer ADD = 4;
    private MetadataViewer model;
    private MetadataViewerUI view;
    private Map<Integer, MetadataViewerAction> actionsMap;
    private LoadingWindow loadingWindow;

    private void createActions() {
        this.actionsMap.put(REFRESH, new RefreshAction(this.model));
        this.actionsMap.put(BROWSE, new BrowseAction(this.model));
        this.actionsMap.put(ADD, new AddAction(this.model));
        this.actionsMap.put(REMOVE, new RemoveAction(this.model));
        this.actionsMap.put(REMOVE_ALL, new RemoveAllAction(this.model));
    }

    MetadataViewerControl() {
    }

    void initialize(MetadataViewer model, MetadataViewerUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.actionsMap = new HashMap<Integer, MetadataViewerAction>();
        this.createActions();
        Registry reg = MetadataViewerAgent.getRegistry();
        this.loadingWindow = new LoadingWindow(reg.getTaskBar().getFrame());
        this.loadingWindow.setTitle("Saving Data");
        this.loadingWindow.setStatus("Batch annotations");
        model.addChangeListener(this);
    }

    MetadataViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void analyseFRAP(int channelIndex) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ImageData img = (ImageData)this.model.getRefObject();
        ids.add(img.getId());
        AnalysisParam param = new AnalysisParam(ids, ImageData.class, 1);
        ArrayList<Integer> channels = new ArrayList<Integer>();
        channels.add(channelIndex);
        param.setChannels(channels);
        IconManager icons = IconManager.getInstance();
        AnalysisActivityParam activity = new AnalysisActivityParam(param, icons.getIcon(85));
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        un.notifyActivity(activity);
    }

    public void stateChanged(ChangeEvent ce) {
        switch (this.model.getState()) {
            case 3: {
                this.model.setStatus(false);
                this.loadingWindow.setVisible(false);
                break;
            }
            case 5: {
                UIUtilities.centerAndShow(this.loadingWindow);
                break;
            }
            case 2: 
            case 6: {
                this.model.setStatus(true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("render_plane".equals(name)) {
            this.model.renderPlane();
        } else if ("applyToAll".equals(name)) {
            this.model.applyToAll();
        } else if ("selectedChannel".equals(name)) {
            this.model.onChannelSelected((Integer)evt.getNewValue());
        } else if ("channelColor".equals(name)) {
            this.model.onChannelColorChanged((Integer)evt.getNewValue());
        } else if ("Reload".equals(name)) {
            this.model.reloadRenderingControl((Boolean)evt.getNewValue());
        } else if ("channelAnalysisSelection".equals(name)) {
            List l = (List)evt.getNewValue();
            ChannelData data = (ChannelData)l.get(0);
            int index = (Integer)l.get(1);
            switch (index) {
                case 1: {
                    this.analyseFRAP(data.getIndex());
                }
            }
        } else if ("ViewedBy".equals(name)) {
            List l = (List)evt.getNewValue();
            this.view.setLocationAndSource((Component)l.get(0), (Point)l.get(1));
            this.model.loadViewedBy();
        }
    }
}

