/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CreateCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ImportAction
extends TreeViewerAction {
    private static final String NAME = "Import...";
    private static final String DESCRIPTION = "Import the selected images.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        this.setEnabled(false);
    }

    public ImportAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(90));
    }

    public void actionPerformed(ActionEvent e) {
        CreateCmd cmd = new CreateCmd(this.model, 5, true);
        cmd.execute();
    }
}

