/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ImporterVisibilityAction
extends TreeViewerAction {
    private static final String DESCRIPTION_HIDE = "Hide the Import view.";
    private static final String DESCRIPTION_SHOW = "Show the Import Viewer.";
    private IconManager icons;

    private void onDataImported() {
        if (this.model.setImporterVisibility()) {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_HIDE));
            this.putValue("SmallIcon", this.icons.getIcon(41));
        } else {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SHOW));
            this.putValue("SmallIcon", this.icons.getIcon(40));
        }
    }

    public ImporterVisibilityAction(TreeViewer model) {
        super(model);
        this.setEnabled(true);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_HIDE));
        this.icons = IconManager.getInstance();
        this.putValue("SmallIcon", this.icons.getIcon(41));
        model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("imported".equals(name)) {
                    ImporterVisibilityAction.this.onDataImported();
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        this.onDataImported();
    }
}

