/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.GroupData;

public class SwitchUserAction
extends TreeViewerAction
implements MouseListener {
    private static final String NAME = "Switch User...";
    private static final String DESCRIPTION = "Select another user and view his/her data.";
    private Point point;

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        if (browser.getBrowserType() == 107) {
            this.setEnabled(false);
            return;
        }
        if (browser.getState() == 15) {
            boolean enabled = false;
            GroupData group = this.model.getSelectedGroup();
            if (group == null) {
                this.setEnabled(false);
                return;
            }
            int level = this.model.getSelectedGroupPermissions();
            if (level == 100) {
                if (this.model.isLeaderOfSelectedGroup()) {
                    enabled = group.getExperimenters().size() > 1;
                }
            } else {
                enabled = group.getExperimenters().size() > 1;
            }
            this.setEnabled(enabled);
        } else {
            this.setEnabled(false);
        }
    }

    protected void onBrowserSelection(Browser browser) {
        this.onBrowserStateChange(browser);
    }

    public SwitchUserAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(23));
    }

    public void actionPerformed(ActionEvent e) {
        SwingUtilities.convertPointToScreen(this.point, (Component)e.getSource());
        this.model.retrieveUserGroups(this.point);
    }

    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

