/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.treeviewer.util.FileSelectionTable;
import org.openmicroscopy.shoola.agents.treeviewer.util.ImportableObject;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ScreenData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDialog
extends JDialog
implements ActionListener,
ChangeListener,
PropertyChangeListener {
    public static final String CANCEL_SELECTION_PROPERTY = "cancelSelection";
    public static final String IMPORT_PROPERTY = "import";
    public static final int IMPORT = 0;
    public static final int CANCEL = 1;
    private static final int REFRESH = 2;
    private static final int RESET = 3;
    private static final int APPLY_TO_ALL = 4;
    private static final String TITLE = "Import";
    private static final String MESSAGE = "Selects the files or directories to import";
    private static final String MESSAGE_PLATE = "Selects the plates to import";
    private static final String END = ".";
    private static final String SUB_MESSAGE = "The name of the file will be, by default, the absolute path. \n You can either edit the name or set the number of directories before the file's name.";
    private int option;
    private FileSelectionTable table;
    private JFileChooser chooser;
    private JButton cancelButton;
    private JButton importButton;
    private JButton refreshButton;
    private JButton resetButton;
    private JButton applyToAllButton;
    private JCheckBox archived;
    private JCheckBox partialName;
    private NumericalTextField numberOfFolders;
    private List<FileFilter> filters;
    private TitlePanel titlePane;

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImportDialog.this.cancelSelection();
            }
        });
    }

    private void initComponents() {
        this.archived = new JCheckBox();
        this.archived.setText("Archived files");
        this.numberOfFolders = new NumericalTextField();
        this.numberOfFolders.addPropertyChangeListener(this);
        this.numberOfFolders.setText("0");
        this.numberOfFolders.setColumns(3);
        this.numberOfFolders.setEnabled(false);
        this.partialName = new JCheckBox();
        this.partialName.setText("Partial path: Directories before the file's name:");
        this.partialName.addChangeListener(this);
        this.chooser = new JFileChooser();
        File f = UIUtilities.getDefaultFolder();
        if (f != null) {
            this.chooser.setCurrentDirectory(f);
        }
        this.chooser.addPropertyChangeListener(this);
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.setFileSelectionMode(2);
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.setApproveButtonText(TITLE);
        this.chooser.setApproveButtonToolTipText("Import the selected files or directories");
        if (this.filters != null) {
            Iterator<FileFilter> i = this.filters.iterator();
            while (i.hasNext()) {
                this.chooser.setFileFilter(i.next());
            }
        }
        this.chooser.setAcceptAllFileFilterUsed(true);
        this.table = new FileSelectionTable(this);
        this.table.addPropertyChangeListener(this);
        this.cancelButton = new JButton("Close");
        this.cancelButton.setToolTipText("Close the dialog and do not import.");
        this.cancelButton.setActionCommand("1");
        this.cancelButton.addActionListener(this);
        this.importButton = new JButton(TITLE);
        this.importButton.setToolTipText("Import the selected files or directories.");
        this.importButton.setActionCommand("0");
        this.importButton.addActionListener(this);
        this.importButton.setEnabled(false);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setToolTipText("Reloads the files view.");
        this.refreshButton.setActionCommand("2");
        this.refreshButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.setToolTipText("Resets the name of all files to either the full path or the partial name if selected.");
        this.resetButton.setActionCommand("3");
        this.resetButton.addActionListener(this);
        this.applyToAllButton = new JButton("Apply Partial Name");
        this.applyToAllButton.setToolTipText("Apply the partial name to all files in the queue.");
        this.applyToAllButton.setActionCommand("4");
        this.applyToAllButton.addActionListener(this);
        this.applyToAllButton.setEnabled(false);
    }

    private JPanel buildToolBarRight() {
        JPanel bar = new JPanel();
        bar.setLayout(new FlowLayout(2));
        bar.add(this.resetButton);
        bar.add(Box.createHorizontalStrut(20));
        bar.add(this.cancelButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.importButton);
        bar.add(Box.createHorizontalStrut(10));
        return bar;
    }

    private JPanel buildToolBarLeft() {
        JPanel bar = new JPanel();
        bar.setLayout(new FlowLayout(0));
        bar.add(this.refreshButton);
        return bar;
    }

    private String getContainerText(Object container) {
        if (container instanceof DatasetData) {
            return "Selects the files or directories to import into dataset: " + ((DatasetData)container).getName() + END;
        }
        if (container instanceof ScreenData) {
            return "Selects the plates to import into screen: " + ((ScreenData)container).getName() + END;
        }
        return "Selects the files or directories to import.";
    }

    private JPanel buildPathComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.partialName);
        p.add(Box.createHorizontalStrut(5));
        p.add(this.numberOfFolders);
        p.add(Box.createHorizontalStrut(5));
        return UIUtilities.buildComponentPanelRight(p);
    }

    private void buildGUI(Object container) {
        boolean supportsWindowDecorations;
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        IconManager icons = IconManager.getInstance();
        this.titlePane = new TitlePanel(TITLE, this.getContainerText(container), icons.getIcon(131));
        this.titlePane.setSubtitle(SUB_MESSAGE);
        c.add((Component)((Object)this.titlePane), "North");
        JSplitPane pane = new JSplitPane(1, this.chooser, this.table);
        c.add((Component)pane, "Center");
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        JPanel options = new JPanel();
        options.setLayout(new BoxLayout(options, 0));
        options.add(UIUtilities.buildComponentPanel(this.archived));
        options.add(this.buildPathComponent());
        controls.add(options);
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.buildToolBarLeft());
        bar.add(this.buildToolBarRight());
        controls.add(new JSeparator());
        controls.add(bar);
        c.add((Component)controls, "South");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(6);
        }
    }

    private void cancelSelection() {
        this.firePropertyChange(CANCEL_SELECTION_PROPERTY, (Object)false, (Object)true);
        this.option = 1;
        this.setVisible(false);
        this.dispose();
    }

    private void importFiles() {
        Integer number;
        this.option = 0;
        UIUtilities.setDefaultFolder(this.chooser.getCurrentDirectory().toString());
        Map<File, String> files = this.table.getFilesToImport();
        ImportableObject object = new ImportableObject(files, this.archived.isSelected());
        if (this.partialName.isSelected() && (number = (Integer)this.numberOfFolders.getValueAsNumber()) != null && number >= 0) {
            object.setDepth(number);
        }
        this.firePropertyChange(IMPORT_PROPERTY, null, object);
        this.setVisible(false);
        this.dispose();
    }

    private boolean isFileImportable(File f) {
        return true;
    }

    private void checkFile(File f, List<File> l) {
        File[] list;
        if (f == null || f.isHidden()) {
            return;
        }
        if (f.isFile()) {
            if (this.isFileImportable(f)) {
                l.add(f);
            }
        } else if (f.isDirectory() && (list = f.listFiles()) != null && list.length > 0) {
            l.add(f);
        }
    }

    String getDisplayedFileName(String fullPath) {
        if (fullPath == null || !this.partialName.isSelected()) {
            return fullPath;
        }
        Integer number = (Integer)this.numberOfFolders.getValueAsNumber();
        return UIUtilities.getDisplayedFileName(fullPath, number);
    }

    public ImportDialog(JFrame owner, List<FileFilter> filters, Object container) {
        super(owner);
        this.filters = filters;
        this.setProperties();
        this.initComponents();
        this.buildGUI(container);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(7 * (screenSize.width / 10), 7 * (screenSize.height / 10));
    }

    public void resetObject(Object container) {
        this.titlePane.setTextHeader(this.getContainerText(container));
        this.titlePane.setSubtitle(SUB_MESSAGE);
        this.table.removeAllFiles();
    }

    public int showDialog() {
        UIUtilities.setLocationRelativeToAndShow(this.getParent(), this);
        return this.option;
    }

    public int centerDialog() {
        UIUtilities.centerAndShow(this);
        return this.option;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Integer number;
        String name = evt.getPropertyName();
        if ("add".equals(name)) {
            File[] files = this.chooser.getSelectedFiles();
            if (files == null || files.length == 0) {
                return;
            }
            ArrayList<File> l = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                this.checkFile(files[i], l);
            }
            this.table.addFiles(l);
            this.importButton.setEnabled(this.table.hasFilesToImport());
        } else if ("remove".equals(name)) {
            this.importButton.setEnabled(this.table.hasFilesToImport());
        } else if ("SelectedFilesChangedProperty".equals(name)) {
            File[] files = this.chooser.getSelectedFiles();
            this.table.allowAddition(files != null && files.length > 0);
        } else if ("textUpdated".equals(name) && this.partialName.isSelected() && (number = (Integer)this.numberOfFolders.getValueAsNumber()) != null && number >= 0) {
            this.table.applyToAll();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int index = Integer.parseInt(evt.getActionCommand());
        switch (index) {
            case 0: {
                this.importFiles();
                break;
            }
            case 1: {
                this.cancelSelection();
                break;
            }
            case 2: {
                this.chooser.rescanCurrentDirectory();
                this.chooser.repaint();
                break;
            }
            case 3: {
                this.partialName.setSelected(false);
                this.table.resetFilesName();
                break;
            }
            case 4: {
                this.table.applyToAll();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.table.applyToAll();
        this.applyToAllButton.setEnabled(this.partialName.isSelected());
        this.numberOfFolders.setEnabled(this.partialName.isSelected());
    }
}

