/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserFactory;
import org.openmicroscopy.shoola.agents.events.SaveData;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.events.editor.ShowEditorEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.treeviewer.CopyItems;
import org.openmicroscopy.shoola.agents.events.treeviewer.DeleteObjectEvent;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.ImportManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.finder.ClearVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.util.AddExistingObjectsDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.AdminDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.GenericDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.ImportDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.ImportableObject;
import org.openmicroscopy.shoola.agents.treeviewer.util.NotDeletedObjectDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.OpenWithDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.DeleteBox;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerWin;
import org.openmicroscopy.shoola.agents.util.DataObjectRegistration;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.ContainerFinder;
import org.openmicroscopy.shoola.agents.util.browser.NodesFinder;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.agents.util.ui.UserManagerDialog;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.data.events.SwitchUserGroup;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.ImportObject;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.component.ObservableComponent;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.FileData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.MultiImageData;
import pojos.PermissionData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeViewerComponent
extends AbstractComponent
implements TreeViewer {
    private TreeViewerModel model;
    private TreeViewerControl controller;
    private TreeViewerWin view;
    private UserManagerDialog switchUserDialog;
    private ImportManager importManager;
    private ImportDialog importDialog;

    private void downloadFile(File folder, boolean override, FileAnnotationData fa, ApplicationData data) {
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        OriginalFile f = (OriginalFile)fa.getContent();
        IconManager icons = IconManager.getInstance();
        DownloadActivityParam activity = new DownloadActivityParam(f, folder, icons.getIcon(110));
        if (override) {
            activity.setFileName(fa.getFileName());
        }
        activity.setApplicationData(data);
        un.notifyActivity(activity);
    }

    private void prepareFile(List<Object> l, File f, int total) {
        if (f.isFile() && this.model.isFileImportable(f)) {
            l.add(f);
        } else if (f.isDirectory() && !f.isHidden()) {
            File[] list = f.listFiles();
            total += list.length;
            for (int k = 0; k < list.length; ++k) {
                File child = list[k];
                if (!child.isFile() || !this.model.isFileImportable(child)) continue;
                l.add(child);
            }
        }
    }

    private void displayUserGroups(Set groups, Point location) {
        JFrame f = (JFrame)((Object)TreeViewerAgent.getRegistry().getTaskBar());
        IconManager icons = IconManager.getInstance();
        this.switchUserDialog = new UserManagerDialog(f, this.model.getUserDetails(), groups, icons.getIcon(23), icons.getIcon(56));
        this.switchUserDialog.addPropertyChangeListener(this.controller);
        this.switchUserDialog.setDefaultSize();
        UIUtilities.showOnScreen(this.switchUserDialog, location);
    }

    private void showDataBrowser(Object object, TreeImageDisplay display, boolean visible) {
        Browser b;
        Object ho;
        DataBrowser db = null;
        TreeImageDisplay parent = null;
        Browser browser = this.model.getSelectedBrowser();
        if (display != null) {
            parent = display.getParentDisplay();
        }
        List<ApplicationData> app = null;
        if (display instanceof TreeImageTimeSet) {
            List l;
            db = DataBrowserFactory.getDataBrowser(display);
            if (db != null) {
                db.setComponentTitle("");
                if (visible) {
                    this.view.removeAllFromWorkingPane();
                    this.view.displayBrowser(db);
                }
            } else if (DataBrowserFactory.hasBeenDiscarded(display) && display.isChildrenLoaded() && display.containsImages() && (l = display.getChildrenDisplay()) != null) {
                HashSet<Object> s = new HashSet<Object>();
                for (TreeImageDisplay child : l) {
                    s.add(child.getUserObject());
                }
                this.setLeaves((TreeImageSet)display, s);
                db = DataBrowserFactory.getDataBrowser(display);
                List list = browser.getSelectedDataObjects();
                if (list != null && list.size() == 1) {
                    app = TreeViewerFactory.getApplications(this.model.getObjectMimeType(list.get(0)));
                }
                db.setSelectedNodes(list, app);
            }
            return;
        }
        if (object instanceof ImageData) {
            if (parent != null) {
                ho = parent.getUserObject();
                db = DataBrowserFactory.getDataBrowser(ho);
                if (db != null) {
                    List list;
                    db.setComponentTitle("");
                    if (visible) {
                        this.view.removeAllFromWorkingPane();
                        this.view.displayBrowser(db);
                    }
                    if ((list = browser.getSelectedDataObjects()) != null && list.size() == 1) {
                        app = TreeViewerFactory.getApplications(this.model.getObjectMimeType(list.get(0)));
                    }
                    db.setSelectedNodes(list, app);
                } else if (DataBrowserFactory.hasBeenDiscarded(ho)) {
                    List l;
                    if (parent.isChildrenLoaded() && (l = parent.getChildrenDisplay()) != null) {
                        TagAnnotationData tag;
                        HashSet<Object> s = new HashSet<Object>();
                        Iterator i = l.iterator();
                        if (ho instanceof DatasetData) {
                            while (i.hasNext()) {
                                TreeImageDisplay child = (TreeImageDisplay)i.next();
                                s.add(child.getUserObject());
                            }
                            this.setLeaves((TreeImageSet)parent, s);
                            db = DataBrowserFactory.getDataBrowser(ho);
                            List list = browser.getSelectedDataObjects();
                            if (list != null && list.size() == 1) {
                                app = TreeViewerFactory.getApplications(this.model.getObjectMimeType(list.get(0)));
                            }
                            db.setSelectedNodes(list, app);
                        } else if (ho instanceof GroupData) {
                            while (i.hasNext()) {
                                TreeImageDisplay child = (TreeImageDisplay)i.next();
                                s.add(child.getUserObject());
                            }
                            this.setLeaves((TreeImageSet)parent, s);
                            db = DataBrowserFactory.getDataBrowser(ho);
                            List list = browser.getSelectedDataObjects();
                            db.setSelectedNodes(list, app);
                        } else if (ho instanceof TagAnnotationData && (tag = (TagAnnotationData)ho).getTags() == null) {
                            while (i.hasNext()) {
                                TreeImageDisplay child = (TreeImageDisplay)i.next();
                                s.add(child.getUserObject());
                            }
                            this.setLeaves((TreeImageSet)parent, s);
                            db = DataBrowserFactory.getDataBrowser(ho);
                            List list = browser.getSelectedDataObjects();
                            if (list != null && list.size() == 1) {
                                app = TreeViewerFactory.getApplications(this.model.getObjectMimeType(list.get(0)));
                            }
                            db.setSelectedNodes(list, app);
                        }
                    }
                } else {
                    this.showDataBrowser(object, parent.getParentDisplay(), visible);
                }
            } else {
                this.view.removeAllFromWorkingPane();
            }
        } else if (object instanceof ExperimenterData && this.model.getSelectedBrowser().getBrowserType() == 107) {
            ho = null;
            if (display.getParentDisplay() != null) {
                ho = display.getParentDisplay().getUserObject();
                db = DataBrowserFactory.getDataBrowser(ho);
            } else {
                db = null;
            }
            if (db != null) {
                db.setComponentTitle("");
                if (visible) {
                    this.view.removeAllFromWorkingPane();
                    this.view.addComponent(db.getUI(this.model.isFullScreen()));
                }
                if (object instanceof DataObject) {
                    ArrayList<DataObject> nodes = new ArrayList<DataObject>();
                    nodes.add((DataObject)object);
                    db.setSelectedNodes(nodes, TreeViewerFactory.getApplications(this.model.getObjectMimeType(object)));
                }
            }
        } else {
            db = DataBrowserFactory.getDataBrowser(object);
            if (db != null) {
                db.setComponentTitle("");
                if (visible) {
                    this.view.removeAllFromWorkingPane();
                    this.view.addComponent(db.getUI(this.model.isFullScreen()));
                }
                if (object instanceof DataObject) {
                    ArrayList<DataObject> nodes = new ArrayList<DataObject>();
                    nodes.add((DataObject)object);
                    db.setSelectedNodes(nodes, TreeViewerFactory.getApplications(this.model.getObjectMimeType(object)));
                }
            } else {
                List l;
                this.view.removeAllFromWorkingPane();
                if (display != null && display.isChildrenLoaded() && (l = display.getChildrenDisplay()) != null) {
                    TagAnnotationData tag;
                    HashSet<Object> s = new HashSet<Object>();
                    Iterator i = l.iterator();
                    if (object instanceof DatasetData) {
                        while (i.hasNext()) {
                            TreeImageDisplay child = (TreeImageDisplay)i.next();
                            s.add(child.getUserObject());
                        }
                        this.setLeaves((TreeImageSet)display, s);
                        db = DataBrowserFactory.getDataBrowser(display.getUserObject());
                        List list = browser.getSelectedDataObjects();
                        if (list != null && list.size() == 1) {
                            app = TreeViewerFactory.getApplications(this.model.getObjectMimeType(list.get(0)));
                        }
                        db.setSelectedNodes(list, app);
                    } else if (object instanceof GroupData) {
                        while (i.hasNext()) {
                            TreeImageDisplay child = (TreeImageDisplay)i.next();
                            s.add(child.getUserObject());
                        }
                        this.setLeaves((TreeImageSet)display, s);
                        db = DataBrowserFactory.getDataBrowser(display.getUserObject());
                        List list = browser.getSelectedDataObjects();
                        db.setSelectedNodes(list, app);
                    } else if (object instanceof TagAnnotationData && (tag = (TagAnnotationData)object).getTags() == null) {
                        while (i.hasNext()) {
                            TreeImageDisplay child = (TreeImageDisplay)i.next();
                            s.add(child.getUserObject());
                        }
                        this.setLeaves((TreeImageSet)display, s);
                        db = DataBrowserFactory.getDataBrowser(display.getUserObject());
                        List list = browser.getSelectedDataObjects();
                        db.setSelectedNodes(list, null);
                    }
                }
            }
        }
        this.model.setDataViewer(db);
        if (db != null && (b = this.getSelectedBrowser()) != null && b.getBrowserType() == 103) {
            b.addComponent(db.getGridUI());
        }
    }

    TreeViewerComponent(TreeViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new TreeViewerControl(this);
        this.view = new TreeViewerWin();
        Finder f = new Finder(this);
        model.setFinder(f);
        f.addPropertyChangeListener(this.controller);
    }

    void initialize(Rectangle bounds) {
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model, bounds);
        this.model.getMetadataViewer().addPropertyChangeListener(this.controller);
    }

    void setRndSettings(ImageData image) {
        if (this.model.getState() == 2) {
            return;
        }
        this.model.setRndSettings(image);
    }

    void onRndSettingsCopied(Collection imageIds) {
        if (this.model.getState() == 2) {
            return;
        }
        MetadataViewer mv = this.model.getMetadataViewer();
        if (mv != null) {
            mv.onRndSettingsCopied(imageIds);
        }
    }

    TreeViewerModel getModel() {
        return this.model;
    }

    void setRecycled(boolean b) {
        this.model.setRecycled(b);
    }

    void saveOnClose(SaveData evt) {
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void activate() {
        switch (this.model.getState()) {
            case 1: {
                this.view.setOnScreen();
                this.view.selectFirstPane();
                this.model.getSelectedBrowser().activate();
                this.model.setState(7);
                break;
            }
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    @Override
    public Map getBrowsers() {
        return this.model.getBrowsers();
    }

    @Override
    public void discard() {
        Map browsers = this.getBrowsers();
        Iterator i = browsers.values().iterator();
        while (i.hasNext()) {
            ((Browser)i.next()).discard();
        }
        this.model.discard();
        this.fireStateChange();
    }

    @Override
    public Browser getSelectedBrowser() {
        return this.model.getSelectedBrowser();
    }

    @Override
    public void setSelectedBrowser(Browser browser) {
        Browser oldBrowser;
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        if (this.view.getDisplayMode() == 101) {
            this.view.showAdvancedFinder();
            this.view.removeAllFromWorkingPane();
        }
        if ((oldBrowser = this.model.getSelectedBrowser()) == null || !oldBrowser.equals(browser)) {
            this.model.setSelectedBrowser(browser);
            if (browser != null) {
                browser.activate();
                if (browser.getBrowserType() == 107) {
                    ExperimenterData exp = this.model.getUserDetails();
                    this.model.getMetadataViewer().setRootObject(null, exp.getId());
                }
            }
            this.removeEditor();
            this.model.getMetadataViewer().setSelectionMode(false);
            this.firePropertyChange("selectedBrowser", oldBrowser, browser);
        }
        this.view.updateMenuItems();
    }

    @Override
    public void displayBrowser(int browserType) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        Map browsers = this.model.getBrowsers();
        Browser browser = (Browser)browsers.get(browserType);
        if (browser.isDisplayed()) {
            this.view.removeBrowser(browser);
        } else {
            this.model.setSelectedBrowser(browser);
            this.view.addBrowser(browser);
        }
        browser.setDisplayed(!browser.isDisplayed());
        this.removeEditor();
    }

    @Override
    public void createDataObject(DataObject object, boolean withParent) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        if (object == null) {
            return;
        }
        JDialog d = null;
        if (object instanceof ProjectData || object instanceof DatasetData || object instanceof ScreenData || object instanceof TagAnnotationData) {
            d = new EditorDialog(this.view, object, withParent);
        } else if (object instanceof GroupData || object instanceof ExperimenterData) {
            Object uo = null;
            Set<DataObject> nodes = null;
            if (object instanceof ExperimenterData) {
                TreeImageDisplay node = this.getSelectedBrowser().getLastSelectedDisplay();
                if (node != null) {
                    uo = node.getUserObject();
                }
                ContainerFinder finder = new ContainerFinder(GroupData.class);
                this.getSelectedBrowser().accept(finder, 1);
                nodes = finder.getContainers();
                if (nodes.size() == 0) {
                    UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                    un.notifyInfo("Experimenter Creation", "No group available. Please create a group first.");
                    return;
                }
            }
            d = new AdminDialog(this.view, object.getClass(), uo, nodes);
        }
        if (d != null) {
            d.addPropertyChangeListener(this.controller);
            UIUtilities.centerAndShow(d);
        }
    }

    @Override
    public void cancel() {
        if (this.model.getState() != 2) {
            this.model.cancel();
            this.fireStateChange();
        }
    }

    @Override
    public void removeEditor() {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE state.");
            }
        }
        this.view.removeAllFromWorkingPane();
        this.model.getMetadataViewer().setRootObject(null, -1L);
        this.firePropertyChange("removeEditor", false, true);
    }

    @Override
    public ExperimenterData getUserDetails() {
        return this.model.getUserDetails();
    }

    @Override
    public void showFinder(boolean b) {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method should cannot be invoked in the DISCARDED state.");
            }
        }
        if (this.model.getSelectedBrowser() == null) {
            return;
        }
        Finder finder = this.model.getFinder();
        if (b == finder.isDisplay()) {
            return;
        }
        Boolean oldValue = finder.isDisplay() ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.view.showFinder(b);
        this.firePropertyChange("finderVisible", oldValue, newValue);
    }

    @Override
    public void closeWindow() {
        this.cancel();
        if (TreeViewerFactory.isLastViewer()) {
            EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
            bus.post(new ExitApplication());
        } else {
            this.discard();
        }
    }

    @Override
    public void onSelectedDisplay() {
        boolean single;
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE state.");
            }
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay display = browser.getLastSelectedDisplay();
        MetadataViewer metadata = this.model.getMetadataViewer();
        TreeImageDisplay[] selection = browser.getSelectedDisplays();
        boolean bl = single = selection.length == 1;
        if (display instanceof TreeImageTimeSet) {
            single = false;
            TreeImageTimeSet time = (TreeImageTimeSet)display;
            if (!time.containsImages()) {
                metadata.setRootObject(null, -1L);
                return;
            }
        }
        metadata.setSelectionMode(single);
        if (display != null) {
            Object object = display.getUserObject();
            if (!single) {
                ArrayList<Object> l = new ArrayList<Object>();
                for (int i = 0; i < selection.length; ++i) {
                    Object child = selection[i].getUserObject();
                    if (child.equals(object)) continue;
                    l.add(child);
                }
                if (l.size() > 0) {
                    metadata.setRelatedNodes(l);
                }
            } else {
                ExperimenterData exp = browser.getNodeOwner(display);
                if (exp == null) {
                    exp = this.model.getUserDetails();
                }
                metadata.setRootObject(object, exp.getId());
                TreeImageDisplay p = display.getParentDisplay();
                if (p != null) {
                    TreeImageDisplay pp = p.getParentDisplay();
                    Object gpp = null;
                    if (pp != null) {
                        gpp = pp.getUserObject();
                    }
                    metadata.setParentRootObject(p.getUserObject(), gpp);
                }
            }
            if (!this.model.isFullScreen()) {
                this.showDataBrowser(object, display, false);
                this.browse(display, true);
            } else {
                this.showDataBrowser(object, display, true);
            }
        } else {
            DataBrowser db = this.model.getDataViewer();
            if (db != null) {
                db.setSelectedNodes(new ArrayList<DataObject>(), null);
            }
            metadata.setRootObject(null, -1L);
        }
    }

    @Override
    public void setSelectedNode(Object object) {
        Browser browser;
        WellSampleData ws;
        if (object == null) {
            return;
        }
        if (!(object instanceof List)) {
            return;
        }
        List l = (List)object;
        int n = l.size();
        if (n > 3) {
            return;
        }
        Object selected = l.get(1);
        Object parent = null;
        if (n == 3) {
            parent = l.get(2);
        }
        if (selected instanceof ImageData) {
            ImageData img = (ImageData)selected;
            try {
                img.getDefaultPixels();
            }
            catch (Exception e) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Image Not valid", "The selected image is not valid.");
                return;
            }
        } else if (selected instanceof WellSampleData && (ws = (WellSampleData)selected).getId() < 0L) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Well Not valid", "The selected well is not valid.");
            return;
        }
        MetadataViewer mv = this.model.getMetadataViewer();
        if (this.hasDataToSave()) {
            MessageBox dialog = new MessageBox(this.view, "Save data", "Do you want to save the modified data \n before selecting a new item?");
            if (dialog.centerMsgBox() == 1) {
                mv.saveData();
            } else {
                mv.clearDataToSave();
            }
        }
        List siblings = (List)l.get(0);
        int size = siblings.size();
        if (this.view.getDisplayMode() != 101) {
            browser = this.model.getSelectedBrowser();
            browser.onSelectedNode(parent, selected, size > 0);
        }
        mv.setSelectionMode((size = siblings.size()) == 0);
        browser = this.model.getSelectedBrowser();
        ExperimenterData exp = null;
        TreeImageDisplay last = null;
        if (browser != null) {
            last = browser.getLastSelectedDisplay();
        }
        if (last != null) {
            exp = browser.getNodeOwner(last);
        }
        if (exp == null) {
            exp = this.model.getUserDetails();
        }
        mv.setRootObject(selected, exp.getId());
        mv.setParentRootObject(parent, null);
        if (size > 0) {
            mv.setRelatedNodes(siblings);
        }
        if (this.model.getDataViewer() != null) {
            this.model.getDataViewer().setApplications(TreeViewerFactory.getApplications(this.model.getObjectMimeType(selected)));
        }
        if (!this.model.isFullScreen()) {
            this.browse(browser.getLastSelectedDisplay(), false);
        }
        this.firePropertyChange("selection", false, true);
    }

    @Override
    public void setSelectedField(Object object) {
        WellSampleData ws;
        if (object == null) {
            return;
        }
        if (!(object instanceof List)) {
            return;
        }
        List l = (List)object;
        int n = l.size();
        if (n != 2) {
            return;
        }
        Object selected = l.get(0);
        Object parent = l.get(1);
        if (selected instanceof WellSampleData && (ws = (WellSampleData)selected).getId() < 0L) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Well Not valid", "The selected well is not valid.");
            return;
        }
        MetadataViewer mv = this.model.getMetadataViewer();
        if (this.hasDataToSave()) {
            MessageBox dialog = new MessageBox(this.view, "Save data", "Do you want to save the modified \ndata before selecting a new item?");
            if (dialog.centerMsgBox() == 1) {
                mv.saveData();
            } else {
                mv.clearDataToSave();
            }
        }
        Browser browser = this.model.getSelectedBrowser();
        ExperimenterData exp = null;
        TreeImageDisplay last = browser.getLastSelectedDisplay();
        if (last != null) {
            exp = browser.getNodeOwner(last);
        }
        if (exp == null) {
            exp = this.model.getUserDetails();
        }
        mv.setSelectionMode(true);
        mv.setRootObject(selected, exp.getId());
        mv.setParentRootObject(parent, null);
    }

    @Override
    public void onDataObjectSave(DataObject data, int operation) {
        this.onDataObjectSave(data, null, operation);
    }

    @Override
    public void onDataObjectSave(DataObject data, DataObject parent, int operation) {
        int state = this.model.getState();
        if (operation == 302 && state != 3) {
            throw new IllegalStateException("This method can only be invoked in the SAVE state");
        }
        switch (state) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED state");
            }
        }
        if (data == null) {
            throw new IllegalArgumentException("No data object. ");
        }
        switch (operation) {
            case 300: 
            case 301: 
            case 302: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Save operation not supported.");
            }
        }
        if (operation == 302) {
            this.model.setState(7);
            this.fireStateChange();
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = null;
        if (operation == 300) {
            if (parent == null) {
                if (data instanceof ProjectData || data instanceof DatasetData) {
                    browser = this.model.getBrowser(100);
                } else if (data instanceof ScreenData) {
                    browser = this.model.getBrowser(103);
                } else if (data instanceof TagAnnotationData) {
                    browser = this.model.getBrowser(102);
                }
            }
            if (browser != null) {
                this.model.setSelectedBrowser(browser);
                this.view.addBrowser(browser);
                this.removeEditor();
            }
        }
        if ((browser = this.model.getSelectedBrowser()) != null && operation != 301) {
            browser.refreshTree();
        }
        if (operation == 302 || operation == 300) {
            DataBrowserFactory.discardAll();
            this.view.removeAllFromWorkingPane();
        }
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void onOrphanDataObjectCreated(DataObject data) {
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            browser.onOrphanDataObjectCreated(data);
        }
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void onDataObjectSave(List data, int operation) {
        int state = this.model.getState();
        if (operation == 302 && state != 3) {
            throw new IllegalStateException("This method can only be invoked in the SAVE state");
        }
        switch (state) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED state");
            }
        }
        if (data == null) {
            throw new IllegalArgumentException("No data object. ");
        }
        switch (operation) {
            case 300: 
            case 301: 
            case 302: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Save operation not supported.");
            }
        }
        if (operation == 302) {
            this.model.setState(7);
            this.fireStateChange();
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void clearFoundResults() {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                return;
            }
        }
        Browser browser = this.model.getSelectedBrowser();
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        if (browser != null) {
            browser.accept(new ClearVisitor());
            browser.setFoundInBrowser(null);
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void moveToBack() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.toBack();
    }

    @Override
    public void moveToFront() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.toFront();
    }

    @Override
    public void setHierarchyRoot(long userGroupID, ExperimenterData experimenter) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (experimenter == null) {
            return;
        }
        Map browsers = this.model.getBrowsers();
        Iterator i = browsers.keySet().iterator();
        Browser selected = this.model.getSelectedBrowser();
        while (i.hasNext()) {
            Browser browser;
            browser.addExperimenter(experimenter, (browser = (Browser)browsers.get(i.next())) == selected);
        }
    }

    @Override
    public boolean isObjectWritable(Object ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long id = this.model.getUserDetails().getId();
        boolean b = false;
        if (ho instanceof TreeImageTimeSet) {
            Browser browser = this.model.getSelectedBrowser();
            ExperimenterData exp = browser.getNodeOwner((TreeImageDisplay)ho);
            if (exp.getId() == id) {
                b = true;
            }
        } else {
            b = EditorUtil.isUserOwner(ho, id);
        }
        if (b) {
            return b;
        }
        int level = TreeViewerAgent.getRegistry().getAdminService().getPermissionLevel();
        switch (level) {
            case 102: 
            case 104: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isUserOwner(Object ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long id = this.model.getUserDetails().getId();
        if (ho instanceof TreeImageTimeSet) {
            Browser browser = this.model.getSelectedBrowser();
            ExperimenterData exp = browser.getNodeOwner((TreeImageDisplay)ho);
            return exp.getId() == id;
        }
        return EditorUtil.isUserOwner(ho, id);
    }

    @Override
    public void addExistingObjects(DataObject ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (ho == null) {
            throw new IllegalArgumentException("No object.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.model.fireDataExistingObjectsLoader(ho);
        this.fireStateChange();
    }

    @Override
    public void setExistingObjects(Set nodes) {
        if (this.model.getState() != 5) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        if (nodes == null) {
            throw new IllegalArgumentException("Nodes cannot be null.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        Set n = TreeViewerTranslator.transformIntoCheckNodes(nodes, this.getUserDetails().getId(), this.model.getUserGroupID());
        this.model.setState(6);
        AddExistingObjectsDialog dialog = new AddExistingObjectsDialog(this.view, n);
        dialog.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(dialog);
    }

    @Override
    public void addExistingObjects(Set set) {
        if (this.model.getState() != 6) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        if (set == null || set.size() == 0) {
            this.model.setState(7);
        } else {
            this.model.fireAddExistingObjects(set);
        }
        this.fireStateChange();
    }

    @Override
    public void showMenu(int menuID, Component c, Point p) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        switch (menuID) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Menu not supported.");
            }
        }
        this.view.showMenu(menuID, c, p);
    }

    @Override
    public void setStatus(boolean enable, String text, boolean hide) {
        this.view.setStatus(text, hide);
        this.view.setStatusIcon(enable);
    }

    @Override
    public void onComponentStateChange(boolean b) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            browser.onComponentStateChange(b);
        }
        this.view.onStateChanged(b);
        this.firePropertyChange("onComponentStateChanged", !b, b);
    }

    @Override
    public void setNodesToCopy(TreeImageDisplay[] nodes, int index) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (nodes == null || nodes.length == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Copy action", "You first need to select the nodes to copy.");
            return;
        }
        switch (index) {
            case 400: 
            case 401: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
        this.model.setNodesToCopy(nodes, index);
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new CopyItems(this.model.getDataToCopyType()));
        if (index == 401 && this.model.cut()) {
            this.fireStateChange();
        }
    }

    @Override
    public void paste(TreeImageDisplay[] parents) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        if (parents == null || parents.length == 0) {
            un.notifyInfo("Paste action", "You first need to select the nodes to copy into.");
            return;
        }
        TreeImageDisplay[] nodes = this.model.getNodesToCopy();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        boolean b = this.model.paste(parents);
        if (!b) {
            un.notifyInfo("Paste action", "The nodes to copy cannot be added to the selected nodes.");
        } else {
            this.fireStateChange();
        }
    }

    @Override
    public JFrame getUI() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view;
    }

    @Override
    public boolean hasDataToSave() {
        MetadataViewer metadata = this.model.getMetadataViewer();
        if (metadata == null) {
            return false;
        }
        return metadata.hasDataToSave();
    }

    @Override
    public void showPreSavingDialog() {
        MetadataViewer metadata = this.model.getMetadataViewer();
        if (metadata == null) {
            return;
        }
        if (!metadata.hasDataToSave()) {
            return;
        }
        MessageBox dialog = new MessageBox(this.view, "Save data", "Do you want to save the modified \ndata before selecting a new item?");
        if (dialog.centerMsgBox() == 1) {
            this.model.getMetadataViewer().saveData();
        } else {
            this.model.getMetadataViewer().clearDataToSave();
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                browser.setSelectedNode();
            }
        }
    }

    @Override
    public long getUserGroupID() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getUserGroupID();
    }

    @Override
    public void retrieveUserGroups(Point location) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.displayUserGroups(TreeViewerAgent.getAvailableUserGroups(), location);
    }

    @Override
    public String getExperimenterNames() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getExperimenterNames();
    }

    @Override
    public ExperimenterData getSelectedExperimenter() {
        TreeImageDisplay node;
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        Browser b = this.model.getSelectedBrowser();
        ExperimenterData exp = this.model.getExperimenter();
        if (b != null && (node = b.getLastSelectedDisplay()) != null) {
            exp = b.getNodeOwner(node);
        }
        return exp;
    }

    @Override
    public boolean isRecycled() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.isRecycled();
    }

    @Override
    public boolean isRollOver() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.isRollOver();
    }

    @Override
    public void setRollOver(boolean rollOver) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.setRollOver(rollOver);
    }

    @Override
    public void removeExperimenterData() {
        Browser browser = this.model.getSelectedBrowser();
        TreeImageDisplay expNode = browser.getLastSelectedDisplay();
        Object uo = expNode.getUserObject();
        if (uo == null || !(uo instanceof ExperimenterData)) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)uo;
        Map browsers = this.model.getBrowsers();
        Iterator i = browsers.keySet().iterator();
        while (i.hasNext()) {
            browser = (Browser)browsers.get(i.next());
            browser.removeExperimenter(exp);
        }
    }

    @Override
    public boolean hasRndSettings() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.hasRndSettingsToPaste();
    }

    @Override
    public void pasteRndSettings(List<Long> ids, Class klass) {
        if (!this.hasRndSettings()) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "No rendering settings topaste. \n Please first copy settings.");
            return;
        }
        if (ids == null || ids.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "Please select the nodes \nyou wish to apply the settings to.");
            return;
        }
        this.model.firePasteRenderingSettings(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void pasteRndSettings(TimeRefObject ref) {
        if (!this.hasRndSettings()) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "No rendering settings topaste. Please first copy settings.");
            return;
        }
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "Please select the nodesyou wish to apply the settings to.");
            return;
        }
        this.model.firePasteRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void rndSettingsPasted(Map map) {
        if (map == null || map.size() != 2) {
            return;
        }
        Collection failure = (Collection)map.get(Boolean.FALSE);
        Collection success = (Collection)map.get(Boolean.TRUE);
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new RndSettingsCopied(success, -1L));
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        String name = this.model.getRefImageName();
        int n = success.size();
        String text = "The rendering settings ";
        if (name != null && name.length() > 0) {
            text = text + "of " + name;
        }
        if (failure.size() == 0) {
            text = text + "\nhave been applied to the selected image";
            text = n > 1 ? text + "s." : text + ".";
            un.notifyInfo("Rendering Settings Applied", text);
        } else {
            DataBrowser db = this.model.getDataViewer();
            String message = "";
            String s = "";
            if (db != null) {
                Set<DataObject> images = db.getBrowser().getImages();
                HashMap<Long, ImageData> m = new HashMap<Long, ImageData>();
                if (images != null) {
                    for (DataObject obj : images) {
                        if (!(obj instanceof ImageData)) continue;
                        ImageData img = (ImageData)obj;
                        m.put(img.getId(), img);
                    }
                    Iterator i = failure.iterator();
                    while (i.hasNext()) {
                        long id = (Long)i.next();
                        if (!m.containsKey(id)) continue;
                        s = s + EditorUtil.getPartialName(((ImageData)m.get(id)).getName());
                        s = s + "\n";
                    }
                    s = s.trim();
                    message = text + "\ncould not be applied to the following " + "images:\n" + s;
                }
            }
            if (message.length() == 0) {
                s = " image";
                if (n > 1) {
                    s = s + "s";
                }
                s = s + ".";
                message = text + "\ncould not be applied to " + n + s;
            }
            un.notifyInfo("Rendering Settings Applied", message);
        }
        MetadataViewer mv = this.model.getMetadataViewer();
        if (mv != null) {
            mv.onSettingsApplied();
        }
        this.model.setState(7);
        this.fireStateChange();
    }

    @Override
    public void resetRndSettings(List<Long> ids, Class klass) {
        if (ids == null || ids.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Reset settings", "Please select at one element.");
            return;
        }
        this.model.fireResetRenderingSettings(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void resetRndSettings(TimeRefObject ref) {
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Reset settings", "Please select at one element.");
            return;
        }
        this.model.fireResetRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void createObject(DataObject object, boolean withParent) {
        if (this.model.getState() == 2) {
            return;
        }
        if (object == null) {
            return;
        }
        Browser browser = null;
        if (object instanceof DatasetData || object instanceof ProjectData) {
            browser = this.model.getBrowser(100);
        } else if (object instanceof ScreenData) {
            browser = this.model.getBrowser(103);
        }
        if (browser != null) {
            browser.expandUser();
        }
        this.model.fireDataObjectCreation(object, withParent);
        this.fireStateChange();
    }

    @Override
    public void setLeaves(TreeImageSet parent, Collection leaves) {
        if (parent instanceof TreeFileSet) {
            this.view.removeAllFromWorkingPane();
            return;
        }
        Object parentObject = parent.getUserObject();
        TreeImageDisplay display = parent.getParentDisplay();
        Object grandParentObject = null;
        if (display != null) {
            grandParentObject = display.getUserObject();
        }
        DataBrowser db = null;
        if (parentObject instanceof TagAnnotationData) {
            db = DataBrowserFactory.getTagsBrowser((TagAnnotationData)parentObject, leaves, false);
        } else if (parentObject instanceof GroupData) {
            db = DataBrowserFactory.getGroupsBrowser((GroupData)parentObject, leaves);
        } else if (parentObject instanceof FileData) {
            FileData f = (FileData)parentObject;
            if (!f.isHidden() && (f.isDirectory() || f instanceof MultiImageData)) {
                db = DataBrowserFactory.getFSFolderBrowser((FileData)parentObject, leaves);
            }
        } else {
            db = DataBrowserFactory.getDataBrowser(grandParentObject, parentObject, leaves, parent);
            if (parent instanceof TreeImageTimeSet) {
                ExperimenterData exp = this.getSelectedBrowser().getNodeOwner(parent);
                db.setExperimenter(exp);
            }
        }
        if (db == null) {
            return;
        }
        db.addPropertyChangeListener(this.controller);
        db.activate();
        this.view.displayBrowser(db);
        this.model.setDataViewer(db);
    }

    @Override
    public Collection getDisplayedImages() {
        DataBrowser db = this.model.getDataViewer();
        if (db == null) {
            return null;
        }
        return db.getBrowser().getVisibleImages();
    }

    @Override
    public void browseHierarchyRoots(Object parent, Collection roots) {
        TreeImageDisplay display;
        List l;
        if (roots == null) {
            return;
        }
        Iterator i = roots.iterator();
        ObservableComponent db = null;
        if (roots.size() != 1) {
            return;
        }
        long userID = this.model.getExperimenter().getId();
        long groupID = this.model.getUserGroupID();
        HashMap<Long, TreeImageDisplay> m = new HashMap<Long, TreeImageDisplay>();
        if (parent instanceof TreeImageDisplay && (l = (display = (TreeImageDisplay)parent).getChildrenDisplay()) != null) {
            for (TreeImageDisplay child : l) {
                long id = child.getUserObjectId();
                if (id < 0L) continue;
                m.put(id, child);
            }
        }
        while (i.hasNext()) {
            Iterator k;
            Set dataObjects;
            TreeImageDisplay value;
            Set set;
            DataObject node = (DataObject)i.next();
            if (node instanceof ProjectData) {
                ProjectData project = (ProjectData)node;
                set = project.getDatasets();
                for (DatasetData d : set) {
                    value = (TreeImageDisplay)m.get(d.getId());
                    if (value == null) continue;
                    dataObjects = d.getImages();
                    if (dataObjects != null) {
                        value.removeAllChildrenDisplay();
                        k = dataObjects.iterator();
                        while (k.hasNext()) {
                            value.addChildDisplay(TreeViewerTranslator.transformDataObject((DataObject)((ImageData)k.next()), userID, groupID));
                        }
                    }
                    value.setChildrenLoaded(true);
                }
                this.model.setState(7);
                this.fireStateChange();
                db = DataBrowserFactory.getDataBrowser(project, set);
                continue;
            }
            if (!(node instanceof TagAnnotationData)) continue;
            TagAnnotationData tag = (TagAnnotationData)node;
            set = tag.getDataObjects();
            Iterator j = set.iterator();
            while (j.hasNext()) {
                DataObject object = (DataObject)j.next();
                value = (TreeImageDisplay)m.get(object.getId());
                if (value == null) continue;
                if (object instanceof DatasetData) {
                    dataObjects = ((DatasetData)object).getImages();
                    if (dataObjects != null) {
                        value.removeAllChildrenDisplay();
                        k = dataObjects.iterator();
                        while (k.hasNext()) {
                            value.addChildDisplay(TreeViewerTranslator.transformDataObject((DataObject)((ImageData)k.next()), userID, groupID));
                        }
                    }
                    value.setChildrenLoaded(true);
                    continue;
                }
                if (!(object instanceof ProjectData)) continue;
                Set datasets = ((ProjectData)object).getDatasets();
                Iterator l2 = datasets.iterator();
                while (l2.hasNext()) {
                    DatasetData d;
                    d = (DatasetData)j.next();
                    dataObjects = d.getImages();
                    if (dataObjects != null) {
                        value.removeAllChildrenDisplay();
                        k = dataObjects.iterator();
                        while (k.hasNext()) {
                            value.addChildDisplay(TreeViewerTranslator.transformDataObject((DataObject)((ImageData)k.next()), userID, groupID));
                        }
                    }
                    value.setChildrenLoaded(true);
                }
            }
            this.model.setState(7);
            this.fireStateChange();
            db = DataBrowserFactory.getTagsBrowser(tag, set, true);
        }
        if (db != null) {
            db.addPropertyChangeListener(this.controller);
            db.activate();
            this.view.removeAllFromWorkingPane();
            this.view.displayBrowser((DataBrowser)db);
        }
        this.model.setDataViewer((DataBrowser)db);
    }

    @Override
    public void setUnselectedNode(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof List)) {
            return;
        }
        List l = (List)object;
        int n = l.size();
        if (n > 3) {
            return;
        }
        Object multiSelection = l.get(0);
        Object selected = l.get(1);
        Object parent = null;
        if (n == 3) {
            parent = l.get(2);
        }
        if (selected instanceof ImageData) {
            ImageData img = (ImageData)selected;
            try {
                img.getDefaultPixels();
            }
            catch (Exception e) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Image Not valid", "The selected image is not valid");
                return;
            }
        }
        Browser browser = this.model.getSelectedBrowser();
        MetadataViewer mv = this.model.getMetadataViewer();
        browser.onDeselectedNode(parent, selected, (Boolean)multiSelection);
        this.onSelectedDisplay();
    }

    @Override
    public void copyRndSettings(ImageData image) {
        if (image == null) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser == null) {
                return;
            }
            TreeImageDisplay node = browser.getLastSelectedDisplay();
            if (node == null) {
                return;
            }
            Object o = node.getUserObject();
            if (!(o instanceof ImageData)) {
                return;
            }
            image = (ImageData)o;
        }
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new CopyRndSettings(image));
    }

    @Override
    public void setMinMax(List<Long> ids, Class klass) {
        if (ids == null || ids.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set settings", "Please select at least one element.");
            return;
        }
        this.model.fireSetMinMax(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void setOriginalRndSettings(TimeRefObject ref) {
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set settings", "Please select at least one element.");
            return;
        }
        this.model.fireSetOwnerRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void setOwnerRndSettings(List<Long> ids, Class klass) {
        if (ids == null || ids.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set settings", "Please select at least one element.");
            return;
        }
        this.model.fireSetOwnerRenderingSettings(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void setOwnerRndSettings(TimeRefObject ref) {
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set settings", "Please select at least one element.");
            return;
        }
        this.model.fireSetOriginalRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void showSearch() {
        int oldMode = this.view.getDisplayMode();
        this.view.showAdvancedFinder();
        DataBrowser db = DataBrowserFactory.getSearchBrowser();
        int newMode = this.view.getDisplayMode();
        this.view.removeAllFromWorkingPane();
        this.model.getAdvancedFinder().requestFocusOnField();
        switch (newMode) {
            case 100: {
                this.onSelectedDisplay();
                break;
            }
            case 101: {
                ExperimenterData exp = this.model.getUserDetails();
                this.model.getMetadataViewer().setRootObject(null, exp.getId());
                if (db == null) break;
                this.view.displayBrowser(db);
                this.model.setDataViewer(db);
            }
        }
        this.firePropertyChange("searchMode", oldMode, newMode);
    }

    @Override
    public void setSearchResult(Object result) {
        Collection results = (Collection)result;
        MetadataViewer metadata = this.model.getMetadataViewer();
        if (metadata != null) {
            metadata.setRootObject(null, -1L);
        }
        if (results == null || results.size() == 0) {
            this.view.removeAllFromWorkingPane();
            return;
        }
        DataBrowser db = DataBrowserFactory.getSearchBrowser(results);
        if (db != null && this.view.getDisplayMode() == 101) {
            db.setExperimenter(TreeViewerAgent.getUserDetails());
            db.addPropertyChangeListener(this.controller);
            db.activate();
            this.view.removeAllFromWorkingPane();
            this.view.displayBrowser(db);
            this.model.setDataViewer(db);
        }
    }

    @Override
    public void addMetadata() {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay[] nodes = browser.getSelectedDisplays();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        ArrayList<Object> data = new ArrayList<Object>();
        Class type = null;
        String text = "Add metadata to ";
        if (nodes.length == 1) {
            TreeImageDisplay n = nodes[0];
            Object uo = n.getUserObject();
            if (uo instanceof TagAnnotationData) {
                data.add(uo);
                type = TagAnnotationData.class;
                text = text + "images linked to the selected tag.";
            } else if (uo instanceof DatasetData) {
                data.add(uo);
                type = DatasetData.class;
                text = text + "images linked to the selected dataset.";
            } else if (n instanceof TreeImageTimeSet) {
                TreeImageTimeSet time = (TreeImageTimeSet)n;
                ExperimenterData exp = this.model.getUserDetails();
                TimeRefObject ref = new TimeRefObject(exp.getId(), 0);
                ref.setTimeInterval(time.getStartTime(), time.getEndTime());
                data.add(ref);
                type = TimeRefObject.class;
                text = text + "images imported during the selected period.";
            }
        } else {
            for (int i = 0; i < nodes.length; ++i) {
                TreeImageDisplay n = nodes[i];
                Object uo = n.getUserObject();
                if (!(uo instanceof ImageData)) continue;
                data.add(uo);
            }
            text = text + "the selected images.";
        }
        if (data.size() > 0) {
            IconManager icons = IconManager.getInstance();
            MetadataViewer viewer = MetadataViewerFactory.getViewer(data, type);
            GenericDialog dialog = new GenericDialog(this.view, "Add Metadata...");
            dialog.initialize("Add Metadata...", text, icons.getIcon(73), viewer.getEditorUI());
            dialog.setParent(viewer);
            viewer.setSelectionMode(true);
            dialog.addPropertyChangeListener(this.controller);
            UIUtilities.centerAndShow(dialog);
        }
    }

    @Override
    public void refreshTree() {
        int state = this.model.getState();
        if (state == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state");
        }
        Browser b = this.model.getSelectedBrowser();
        DataBrowserFactory.discardAll();
        this.view.removeAllFromWorkingPane();
        if (b != null) {
            b.refreshTree();
        }
        ExperimenterData exp = this.model.getUserDetails();
        this.model.getMetadataViewer().setRootObject(null, exp.getId());
    }

    @Override
    public void browseTimeInterval(TreeImageTimeSet parent, Set leaves) {
        if (leaves == null) {
            return;
        }
        Object parentObject = parent.getUserObject();
        TreeImageDisplay display = parent.getParentDisplay();
        Object grandParentObject = null;
        if (display != null) {
            grandParentObject = display.getUserObject();
        }
        DataBrowser db = DataBrowserFactory.getDataBrowser(grandParentObject, parentObject, leaves, parent);
        if (parent != null) {
            ExperimenterData exp = this.getSelectedBrowser().getNodeOwner(parent);
            db.setExperimenter(exp);
        }
        db.addPropertyChangeListener(this.controller);
        db.activate();
        this.view.removeAllFromWorkingPane();
        this.view.displayBrowser(db);
        this.model.setDataViewer(db);
        this.model.setState(7);
        this.fireStateChange();
    }

    @Override
    public void setPlates(Map<TreeImageSet, Set> plates, boolean withThumbnails) {
        if (plates == null || plates.size() == 0) {
            return;
        }
        int n = plates.size();
        Iterator<Map.Entry<TreeImageSet, Set>> i = plates.entrySet().iterator();
        Object gpo = null;
        ObservableComponent db = null;
        if (n == 1) {
            HashMap<Class, Object> m = new HashMap<Class, Object>();
            while (i.hasNext()) {
                Map.Entry<TreeImageSet, Set> entry = i.next();
                TreeImageSet parent = entry.getKey();
                Object parentObject = parent.getUserObject();
                TreeImageDisplay display = parent.getParentDisplay();
                if (display != null) {
                    gpo = display.getUserObject();
                    if (gpo != null) {
                        m.put(gpo.getClass(), gpo);
                    }
                    if (gpo instanceof PlateData && (display = display.getParentDisplay()) != null && (gpo = display.getUserObject()) != null) {
                        m.put(gpo.getClass(), gpo);
                    }
                }
                db = DataBrowserFactory.getWellsDataBrowser(m, parentObject, entry.getValue(), withThumbnails);
            }
        }
        if (db != null) {
            db.addPropertyChangeListener(this.controller);
            db.activate();
            this.view.removeAllFromWorkingPane();
            this.view.displayBrowser((DataBrowser)db);
            this.model.setDataViewer((DataBrowser)db);
            this.getSelectedBrowser().addComponent(db.getGridUI());
        }
        this.model.setState(7);
        this.fireStateChange();
    }

    @Override
    public void browse(TreeImageDisplay node, boolean withThumbnails) {
        FileData fa;
        if (node == null) {
            return;
        }
        Object uo = node.getUserObject();
        if (uo instanceof ProjectData) {
            this.model.browseProject(node);
        } else if (uo instanceof DatasetData) {
            this.model.getSelectedBrowser().loadExperimenterData(BrowserFactory.getDataOwner(node), node);
        } else if (uo instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)uo;
            if (!"openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                this.model.browseTag(node);
            }
        } else if (uo instanceof ImageData) {
            EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
            ViewImage evt = new ViewImage((DataObject)((ImageData)uo), this.view.getBounds());
            evt.setSeparateWindow(this.model.isFullScreen());
            TreeImageDisplay p = node.getParentDisplay();
            TreeImageDisplay gp = null;
            DataObject po = null;
            DataObject gpo = null;
            if (p != null) {
                uo = p.getUserObject();
                gp = p.getParentDisplay();
                if (uo instanceof DataObject) {
                    po = (DataObject)uo;
                }
                if (gp != null && (uo = gp.getParentDisplay()) instanceof DataObject) {
                    gpo = (DataObject)uo;
                }
            }
            evt.setContext(po, gpo);
            bus.post(evt);
        } else if (node instanceof TreeImageTimeSet) {
            this.model.browseTimeInterval((TreeImageTimeSet)node);
        } else if (uo instanceof PlateData) {
            List l = node.getChildrenDisplay();
            if (l != null && l.size() > 0) {
                return;
            }
            ArrayList<TreeImageDisplay> plates = new ArrayList<TreeImageDisplay>();
            plates.add(node);
            this.model.browsePlates(plates, withThumbnails);
        } else if (uo instanceof PlateAcquisitionData) {
            ArrayList<TreeImageDisplay> plates = new ArrayList<TreeImageDisplay>();
            plates.add(node);
            this.model.browsePlates(plates, withThumbnails);
        } else if (uo instanceof File) {
            List l;
            File f = (File)uo;
            if (f.isDirectory() && !f.isHidden() && (l = node.getChildrenDisplay()) != null && l.size() > 0) {
                HashSet<Object> leaves = new HashSet<Object>();
                for (TreeImageDisplay child : l) {
                    Object object = child.getUserObject();
                    if (!(object instanceof ImageData)) continue;
                    leaves.add(object);
                }
                if (leaves.size() > 0) {
                    this.setLeaves((TreeImageSet)node, leaves);
                }
            }
        } else if (uo instanceof FileData && !(fa = (FileData)uo).isHidden() && (fa.isDirectory() || fa instanceof MultiImageData)) {
            this.model.getSelectedBrowser().loadExperimenterData(BrowserFactory.getDataOwner(node), node);
        }
        this.fireStateChange();
    }

    private void checkForImages(TreeImageDisplay object, List<DataObject> objects, boolean content) {
        block8: {
            DataObject ho;
            List list;
            block10: {
                block9: {
                    block7: {
                        list = object.getChildrenDisplay();
                        ho = (DataObject)object.getUserObject();
                        if (!(ho instanceof ImageData)) break block7;
                        objects.add(ho);
                        break block8;
                    }
                    if (!(ho instanceof DatasetData) || !content) break block9;
                    if (!object.isChildrenLoaded()) break block8;
                    objects.add(ho);
                    break block8;
                }
                if (!(ho instanceof ProjectData) || !content) break block10;
                if (!object.isChildrenLoaded()) break block8;
                for (TreeImageDisplay child : list) {
                    if (!(child.getUserObject() instanceof DatasetData) || !child.isChildrenLoaded()) continue;
                    objects.add((DataObject)child.getUserObject());
                }
                break block8;
            }
            if (ho instanceof PlateData) {
                objects.add(ho);
            } else if (ho instanceof PlateAcquisitionData) {
                TreeImageDisplay parent = object.getParentDisplay();
                objects.add((DataObject)parent.getUserObject());
            } else if (ho instanceof ScreenData && content && object.isChildrenLoaded()) {
                for (TreeImageDisplay child : list) {
                    if (!(child.getUserObject() instanceof PlateData) || !child.isChildrenLoaded()) continue;
                    objects.add((DataObject)child.getUserObject());
                }
            }
        }
    }

    @Override
    public void deleteObjects(List nodes) {
        DeleteBox dialog;
        TreeImageDisplay node;
        if (nodes == null) {
            return;
        }
        Iterator i = nodes.iterator();
        Class<?> type = null;
        boolean ann = false;
        boolean content = false;
        String ns = null;
        if (i.hasNext()) {
            node = (TreeImageDisplay)i.next();
            if (node.isAnnotated()) {
                ann = true;
            }
            if (node.hasChildren()) {
                content = true;
            }
            Object uo = node.getUserObject();
            type = uo.getClass();
            if (uo instanceof TagAnnotationData) {
                ns = ((TagAnnotationData)uo).getNameSpace();
            }
        }
        if ((dialog = new DeleteBox(type, ann = true, content, nodes.size(), ns, this.view)).centerMsgBox() == 1) {
            content = dialog.deleteContents();
            List<Class> types = dialog.getAnnotationTypes();
            i = nodes.iterator();
            ArrayList<DeletableObject> l = new ArrayList<DeletableObject>();
            ArrayList<DataObject> objects = new ArrayList<DataObject>();
            ArrayList<DataObject> values = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            Class<?> klass = null;
            while (i.hasNext()) {
                node = (TreeImageDisplay)i.next();
                Object obj = node.getUserObject();
                if (obj instanceof GroupData || obj instanceof ExperimenterData) {
                    if (values == null) {
                        values = new ArrayList<DataObject>();
                    }
                    values.add((DataObject)obj);
                } else if (obj instanceof DataObject) {
                    DeletableObject d = new DeletableObject((DataObject)obj, content);
                    if (!(obj instanceof TagAnnotationData) && !(obj instanceof FileAnnotationData)) {
                        d.setAttachmentTypes(types);
                    }
                    this.checkForImages(node, objects, content);
                    l.add(d);
                }
                klass = obj.getClass();
                ids.add(((DataObject)obj).getId());
            }
            if (l.size() > 0) {
                this.model.setNodesToCopy(null, -1);
                EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
                bus.post(new DeleteObjectEvent(objects));
                NodesFinder finder = new NodesFinder(klass, ids);
                Browser browser = this.model.getSelectedBrowser();
                browser.accept(finder);
                browser.removeTreeNodes(finder.getNodes());
                this.view.removeAllFromWorkingPane();
                DataBrowserFactory.discardAll();
                this.model.getMetadataViewer().setRootObject(null, -1L);
                IconManager icons = IconManager.getInstance();
                DeleteActivityParam p = new DeleteActivityParam(icons.getIcon(142), l);
                p.setFailureIcon(icons.getIcon(141));
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyActivity(p);
            }
            if (values != null) {
                NodesFinder finder = new NodesFinder(klass, ids);
                Browser browser = this.model.getSelectedBrowser();
                browser.accept(finder);
                this.model.getSelectedBrowser().removeTreeNodes(finder.getNodes());
                this.view.removeAllFromWorkingPane();
                DataBrowserFactory.discardAll();
                this.model.getMetadataViewer().setRootObject(null, -1L);
                this.model.fireObjectsDeletion(values);
                this.fireStateChange();
            }
        }
    }

    @Override
    public Class hasDataToCopy() {
        if (this.model.getState() == 2) {
            return null;
        }
        return this.model.getDataToCopyType();
    }

    @Override
    public void onNodesMoved() {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the SAVE state");
        }
        this.model.setState(7);
        this.fireStateChange();
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.view.removeAllFromWorkingPane();
        DataBrowserFactory.discardAll();
        Browser browser = this.model.getSelectedBrowser();
        browser.refreshTree();
        this.model.getMetadataViewer().setRootObject(null, -1L);
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void onNodesDeleted(Collection<DataObject> deleted) {
        if (this.model.getState() == 2) {
            return;
        }
        if (deleted == null || deleted.size() == 0) {
            this.onNodesMoved();
            return;
        }
        NotDeletedObjectDialog nd = new NotDeletedObjectDialog(this.view, deleted);
        if (nd.centerAndShow() == 0) {
            this.onNodesMoved();
        }
    }

    @Override
    public void openEditorFile(int index) {
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        Browser browser = this.model.getSelectedBrowser();
        switch (index) {
            case 1: {
                if (browser == null) {
                    return;
                }
                TreeImageDisplay d = browser.getLastSelectedDisplay();
                if (d == null) {
                    return;
                }
                Object object = d.getUserObject();
                if (object == null) {
                    return;
                }
                if (!(object instanceof FileAnnotationData)) break;
                FileAnnotationData fa = (FileAnnotationData)d.getUserObject();
                EditFileEvent evt = new EditFileEvent(fa);
                bus.post(evt);
                break;
            }
            case 0: {
                bus.post(new ShowEditorEvent());
                break;
            }
            case 2: {
                if (browser == null) {
                    return;
                }
                TreeImageDisplay d = browser.getLastSelectedDisplay();
                if (d == null) {
                    return;
                }
                Object object = d.getUserObject();
                TreeImageDisplay parent = d.getParentDisplay();
                Object po = null;
                if (parent != null) {
                    po = parent.getUserObject();
                }
                if (object == null) {
                    return;
                }
                String name = null;
                if (object instanceof ProjectData) {
                    name = ((ProjectData)object).getName();
                } else if (object instanceof DatasetData) {
                    if (po != null && po instanceof ProjectData) {
                        name = ((ProjectData)po).getName();
                        name = name + "_";
                        name = name + ((DatasetData)object).getName();
                    } else {
                        name = ((DatasetData)object).getName();
                    }
                } else if (object instanceof ImageData) {
                    name = ((ImageData)object).getName();
                } else if (object instanceof ScreenData) {
                    name = ((ScreenData)object).getName();
                } else if (object instanceof PlateData) {
                    if (po != null && po instanceof ScreenData) {
                        name = ((ScreenData)po).getName();
                        name = name + "_";
                        name = name + ((PlateData)object).getName();
                    } else {
                        name = ((PlateData)object).getName();
                    }
                }
                if (name == null) break;
                name = name + "_exp";
                ShowEditorEvent event = new ShowEditorEvent((DataObject)object, name, 0);
                bus.post(event);
            }
        }
    }

    @Override
    public void showTagWizard() {
        if (this.model.getState() == 2) {
            return;
        }
        this.model.getMetadataViewer().showTagWizard();
    }

    @Override
    public void setInspectorVisibility() {
        if (this.model.getState() == 2) {
            return;
        }
        this.view.setInspectorVisibility();
    }

    @Override
    public void importFiles(ImportableObject toImport) {
        if (this.model.getState() == 2) {
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        int type = browser.getBrowserType();
        ArrayList<TreeImageDisplay> parents = new ArrayList<TreeImageDisplay>();
        TreeImageDisplay node = null;
        if (type != 100 && type != 103) {
            return;
        }
        node = browser.getLastSelectedDisplay();
        Map<File, String> files = toImport.getFiles();
        if (files == null || files.size() == 0) {
            return;
        }
        if (this.importManager == null) {
            this.importManager = new ImportManager();
            this.importManager.addPropertyChangeListener(this.controller);
        }
        List<ImportObject> list = this.importManager.initialize(files, toImport.getDepth());
        if (!this.view.isImporterVisible()) {
            this.view.setImporterVisibility(this.importManager.getUIDelegate(), true);
        }
        this.view.setImportStatus("Importing...", true);
        if (node == null) {
            this.model.importFiles(parents, list, toImport.isArchived());
        } else {
            this.model.importFiles(node, list, toImport.isArchived());
        }
        this.firePropertyChange("importImages", false, true);
    }

    @Override
    public void setImportedFiles(File key, Object value, List<TreeImageDisplay> nodes, DataObject container, int loaderID) {
        if (this.model.getState() == 2) {
            return;
        }
        if (this.importManager == null) {
            return;
        }
        Browser browser = this.model.getBrowser(105);
        if (value == null || value instanceof String || value instanceof Exception) {
            this.importManager.setStatus(key, value);
        } else if (value instanceof Map) {
            this.importManager.setStatus(key, value);
        } else if (value instanceof ImageData) {
            ImageData img = (ImageData)value;
            browser.setImportedFile(img);
            this.importManager.setStatus(key, img);
        } else if (value instanceof ThumbnailData) {
            ThumbnailData thumb = (ThumbnailData)value;
            ImageData img = thumb.getImage();
            browser.setImportedFile(img);
            this.importManager.setStatus(key, thumb);
        }
        boolean b = this.importManager.hasFilesToImport();
        this.model.removeLoader(loaderID);
        this.view.setImportStatus("", b);
        Browser selectedBrowser = this.model.getSelectedBrowser();
        if (container instanceof DatasetData) {
            browser = selectedBrowser != null && selectedBrowser.getBrowserType() == 100 ? selectedBrowser : null;
        }
        if (browser != null && nodes != null && !b) {
            browser.onImportFinished(nodes);
            this.firePropertyChange("imported", false, true);
        }
    }

    @Override
    public boolean isImporting() {
        if (this.importManager == null) {
            return false;
        }
        return this.importManager.hasFilesToImport();
    }

    @Override
    public boolean setImporterVisibility() {
        if (this.model.getState() == 2) {
            return false;
        }
        if (this.importManager == null) {
            return false;
        }
        return this.view.setImporterVisibility(this.importManager.getUIDelegate(), false);
    }

    @Override
    public List<FileFilter> getSupportedFormats() {
        if (this.model.getState() == 2) {
            return null;
        }
        return this.model.getSupportedFormats();
    }

    @Override
    public void showImporter() {
        Browser browser = this.model.getSelectedBrowser();
        Object o = browser == null ? null : browser.getLastSelectedDisplay().getUserObject();
        if (this.importDialog == null) {
            this.importDialog = new ImportDialog(this.view, this.model.getSupportedFormats(), o);
            this.importDialog.addPropertyChangeListener("import", this.controller);
        } else {
            this.importDialog.resetObject(o);
        }
        this.importDialog.centerDialog();
    }

    @Override
    public void onActivityProcessed(ActivityComponent activity, boolean finished) {
        if (this.model.getState() == 2) {
            return;
        }
        if (finished) {
            this.view.onActivityTerminated(activity);
        }
        this.firePropertyChange("imported", !finished, finished);
    }

    @Override
    public void download(File folder) {
        if (this.model.getState() == 2) {
            return;
        }
        this.download(folder, null);
    }

    private void download(File folder, ApplicationData data) {
        boolean override;
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        List l = browser.getSelectedDataObjects();
        if (l == null) {
            return;
        }
        Iterator i = l.iterator();
        ArrayList<ImageData> images = new ArrayList<ImageData>();
        boolean bl = override = l.size() > 1;
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof ImageData) {
                images.add((ImageData)object);
                continue;
            }
            if (!(object instanceof FileAnnotationData)) continue;
            this.downloadFile(folder, override, (FileAnnotationData)object, data);
        }
        if (images.size() > 0) {
            this.model.downloadImages(images, folder, data);
        }
    }

    @Override
    public void cancelImports() {
        if (this.model.getState() == 2) {
            return;
        }
        if (this.importManager == null) {
            return;
        }
        boolean b = this.importManager.hasFilesToImport();
        this.view.setImportStatus("", b);
        this.model.cancelImport();
    }

    @Override
    public void setDownloadedFiles(File folder, ApplicationData data, Collection files) {
        if (files == null || files.size() == 0) {
            return;
        }
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        IconManager icons = IconManager.getInstance();
        for (OriginalFile file : files) {
            DownloadActivityParam activity = new DownloadActivityParam(file, folder, icons.getIcon(110));
            activity.setApplicationData(data);
            un.notifyActivity(activity);
        }
    }

    @Override
    public void openWith(ApplicationData data) {
        if (data != null) {
            Environment env = (Environment)TreeViewerAgent.getRegistry().lookup("/env");
            this.download(new File(env.getOmeroFilesHome()), data);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay d = browser.getLastSelectedDisplay();
        if (d == null) {
            return;
        }
        Object uo = d.getUserObject();
        String name = null;
        if (uo instanceof ImageData) {
            ImageData img = (ImageData)uo;
            name = EditorUtil.getObjectName(img.getName());
        } else if (uo instanceof FileAnnotationData) {
            FileAnnotationData fa = (FileAnnotationData)uo;
            name = EditorUtil.getObjectName(fa.getFileName());
        }
        if (name == null) {
            return;
        }
        OpenWithDialog dialog = new OpenWithDialog(this.view, ApplicationData.getDefaultLocation(), name);
        dialog.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(dialog);
    }

    @Override
    public void setUserGroup(GroupData group) {
        if (this.model.getState() != 7) {
            return;
        }
        if (group == null) {
            return;
        }
        ExperimenterData exp = TreeViewerAgent.getUserDetails();
        long oldId = this.model.getUserGroupID();
        if (group.getId() == oldId) {
            return;
        }
        Registry reg = TreeViewerAgent.getRegistry();
        reg.getEventBus().post(new SwitchUserGroup(exp, group.getId()));
    }

    @Override
    public void displayViewer(JComponent viewer, JComponent controls, boolean toAdd, boolean toDetach) {
        if (toAdd && (viewer == null || controls == null)) {
            return;
        }
        toDetach = false;
        this.view.displayViewer(viewer, controls, toAdd, toDetach);
    }

    @Override
    public void setFullScreen() {
    }

    @Override
    public void setMetadataVisibility() {
        if (this.model.getState() == 2) {
            return;
        }
        this.view.setMetadataVisibility();
    }

    @Override
    public Map<Long, String> getScriptsAsString() {
        Registry reg = TreeViewerAgent.getRegistry();
        try {
            return reg.getImageService().getScriptsAsString();
        }
        catch (Exception e) {
            String s = "Data Retrieval Failure: ";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print(e);
            reg.getLogger().error((Object)this, msg);
            return new HashMap<Long, String>();
        }
    }

    @Override
    public boolean isLeaderOfSelectedGroup() {
        if (this.model.getState() == 2) {
            return false;
        }
        return this.model.isLeaderOfSelectedGroup();
    }

    @Override
    public void administrate(AdminObject object) {
        if (this.model.getState() == 2) {
            return;
        }
        if (object == null) {
            throw new IllegalArgumentException("Object not valid.");
        }
        this.model.fireAdmin(object);
        this.fireStateChange();
    }

    @Override
    public void register(DataObjectRegistration file) {
        if (this.model.getState() == 2) {
            return;
        }
        if (file == null) {
            throw new IllegalArgumentException("No file to register.");
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null || browser.getBrowserType() != 105) {
            return;
        }
        if (browser.register(file.getData())) {
            this.model.getMetadataViewer().saveData(file.getToAdd(), file.getToRemove(), file.getToDelete(), file.getMetadata(), file.getData(), true);
        }
    }

    @Override
    public int getSelectedGroupPermissions() {
        GroupData group = this.getSelectedGroup();
        int level = 100;
        if (group != null) {
            PermissionData data = group.getPermissions();
            if (data.isGroupRead()) {
                level = data.isGroupWrite() ? 102 : 101;
            } else if (data.isWorldRead()) {
                level = data.isWorldWrite() ? 104 : 103;
            }
        }
        return level;
    }

    @Override
    public GroupData getSelectedGroup() {
        Set m = TreeViewerAgent.getAvailableUserGroups();
        Iterator i = m.iterator();
        long id = this.model.getUserGroupID();
        GroupData group = null;
        while (i.hasNext()) {
            group = (GroupData)i.next();
            if (group.getId() != id) continue;
            return group;
        }
        return null;
    }

    @Override
    public void resetPassword(String password) {
        if (password == null) {
            throw new omero.IllegalArgumentException("No password specified.");
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        List l = browser.getSelectedDataObjects();
        if (l == null) {
            return;
        }
        HashMap<ExperimenterData, UserCredentials> map = new HashMap<ExperimenterData, UserCredentials>();
        for (Object o : l) {
            if (!(o instanceof ExperimenterData)) continue;
            ExperimenterData exp = (ExperimenterData)o;
            UserCredentials uc = new UserCredentials(exp.getUserName(), password);
            map.put(exp, uc);
        }
        if (map.size() == 0) {
            return;
        }
        AdminObject admin = new AdminObject(null, map, 4);
        this.model.fireAdmin(admin);
        this.fireStateChange();
    }

    @Override
    public void onGroupSwitched(boolean success) {
        ExperimenterData exp = TreeViewerAgent.getUserDetails();
        GroupData group = exp.getDefaultGroup();
        long oldGroup = this.model.getUserGroupID();
        if (success) {
            this.model.setGroupId(group.getId());
            this.view.removeAllFromWorkingPane();
            this.model.setDataViewer(null);
            Map browsers = this.model.getBrowsers();
            for (Map.Entry entry : browsers.entrySet()) {
                Browser browser = (Browser)entry.getValue();
                browser.reActivate();
            }
            this.firePropertyChange("groupChanged", oldGroup, this.model.getUserGroupID());
        }
    }

    @Override
    public void findDataObject(Class type, long id, boolean selectTab) {
        block9: {
            Set<TreeImageDisplay> nodes;
            Browser browser;
            block10: {
                browser = null;
                if (selectTab) {
                    if (ProjectData.class.equals((Object)type) || DatasetData.class.equals((Object)type)) {
                        this.view.selectPane(100);
                    } else if (ScreenData.class.equals((Object)type)) {
                        this.view.selectPane(103);
                    }
                }
                if ((browser = this.model.getSelectedBrowser()) == null) break block9;
                NodesFinder finder = new NodesFinder(type, id);
                browser.accept(finder);
                nodes = finder.getNodes();
                if (nodes.size() != 0) break block10;
                if (!ProjectData.class.equals((Object)type) && !DatasetData.class.equals((Object)type) && !ScreenData.class.equals((Object)type)) break block9;
                DataBrowserFactory.discardAll();
                this.view.removeAllFromWorkingPane();
                browser.refreshBrowser(type, id);
                ExperimenterData exp = this.model.getUserDetails();
                this.model.getMetadataViewer().setRootObject(null, exp.getId());
                break block9;
            }
            Iterator<TreeImageDisplay> i = nodes.iterator();
            if (DatasetData.class.equals((Object)type)) {
                while (i.hasNext()) {
                    TreeImageDisplay node = i.next();
                    if (node.isChildrenLoaded()) {
                        browser.setSelectedDisplay(node);
                        continue;
                    }
                    browser.refreshBrowser(type, id);
                }
            } else {
                while (i.hasNext()) {
                    browser.setSelectedDisplay(i.next());
                }
            }
        }
    }
}

