/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.finder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.agents.util.finder.AdvancedFinderLoader;
import org.openmicroscopy.shoola.agents.util.finder.Finder;
import org.openmicroscopy.shoola.agents.util.finder.FinderFactory;
import org.openmicroscopy.shoola.agents.util.finder.FinderLoader;
import org.openmicroscopy.shoola.agents.util.finder.TagsLoader;
import org.openmicroscopy.shoola.agents.util.ui.UserManagerDialog;
import org.openmicroscopy.shoola.env.data.util.SearchDataContext;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.SearchComponent;
import org.openmicroscopy.shoola.util.ui.search.SearchContext;
import org.openmicroscopy.shoola.util.ui.search.SearchHelp;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedFinder
extends SearchComponent
implements Finder,
PropertyChangeListener {
    private static final String TITLE = "Search";
    private List<FinderLoader> finderHandlers;
    private int state;
    private Map<Long, ExperimenterData> users;
    private Collection tags;

    private Integer convertScope(int value) {
        switch (value) {
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 8: {
                return 4;
            }
            case 7: {
                return 3;
            }
            case 6: {
                return 2;
            }
            case 9: {
                return 5;
            }
            case 10: {
                return 7;
            }
        }
        return null;
    }

    private Class convertType(int value) {
        switch (value) {
            case 1: {
                return DatasetData.class;
            }
            case 2: {
                return ProjectData.class;
            }
            case 0: {
                return ImageData.class;
            }
        }
        return null;
    }

    private String getScope(int value) {
        switch (value) {
            case 2: {
                return "Name";
            }
            case 5: {
                return "Description";
            }
            case 0: {
                return "Comments";
            }
            case 1: {
                return "Tags";
            }
            case 4: {
                return "URL";
            }
            case 3: {
                return "Attachments";
            }
            case 6: {
                return "Time";
            }
            case 7: {
                return "Custom";
            }
        }
        return null;
    }

    private List<ExperimenterData> fillUsersList(List<Long> names) {
        ArrayList<ExperimenterData> l = new ArrayList<ExperimenterData>();
        if (names == null) {
            return l;
        }
        for (Long id : names) {
            ExperimenterData user = this.users.get(id);
            if (user == null || l.contains(user)) continue;
            l.add(user);
        }
        return l;
    }

    private void fillUsersList(List<Integer> usersContext, List<ExperimenterData> toKeep, List<ExperimenterData> toExclude) {
        if (usersContext == null) {
            toKeep.clear();
            toExclude.clear();
            return;
        }
        switch (usersContext.size()) {
            case 2: {
                if (toKeep.size() >= 0) {
                    toKeep.add(this.getUserDetails());
                    break;
                }
                toKeep.clear();
                toExclude.clear();
                break;
            }
            case 1: {
                if (usersContext.contains(0)) {
                    toKeep.clear();
                    toExclude.clear();
                    toKeep.add(this.getUserDetails());
                    break;
                }
                if (toKeep.size() != 0) break;
                toExclude.add(this.getUserDetails());
            }
        }
    }

    private void handleSearchContext(SearchContext ctx) {
        String[] some = ctx.getSome();
        String[] must = ctx.getMust();
        String[] none = ctx.getNone();
        UserNotifier un = FinderFactory.getRegistry().getUserNotifier();
        Timestamp start = ctx.getStartTime();
        Timestamp end = ctx.getEndTime();
        if (start != null && end != null && start.after(end)) {
            un.notifyInfo(TITLE, "The selected time interval is not valid.");
            return;
        }
        if (some == null && must == null && none == null && start == null && end == null) {
            un.notifyInfo(TITLE, "Please enter a term to search for or a valid time interval.");
            return;
        }
        List<Integer> context = ctx.getContext();
        if (context == null || context.size() == 0) {
            context = new ArrayList<Integer>();
            context.add(10);
        }
        ArrayList<Integer> scope = new ArrayList<Integer>(context.size());
        Iterator<Integer> i = context.iterator();
        while (i.hasNext()) {
            Integer v = this.convertScope(i.next());
            if (v == null) continue;
            scope.add(v);
        }
        ArrayList<Class> types = new ArrayList<Class>();
        i = ctx.getType().iterator();
        while (i.hasNext()) {
            Class k = this.convertType(i.next());
            if (k == null) continue;
            types.add(k);
        }
        List<ExperimenterData> owners = this.fillUsersList(ctx.getSelectedOwners());
        List<ExperimenterData> annotators = this.fillUsersList(null);
        List<ExperimenterData> excludedOwners = this.fillUsersList(null);
        List<ExperimenterData> excludedAnnotators = this.fillUsersList(null);
        this.fillUsersList(ctx.getOwnerSearchContext(), owners, excludedOwners);
        this.fillUsersList(ctx.getAnnotatorSearchContext(), annotators, excludedAnnotators);
        SearchDataContext searchContext = new SearchDataContext(scope, types, some, must, none);
        searchContext.setTimeInterval(start, end);
        searchContext.setOwners(owners);
        searchContext.setAnnotators(annotators);
        searchContext.setExcludedOwners(excludedOwners);
        searchContext.setExcludedAnnotators(excludedAnnotators);
        searchContext.setCaseSensitive(ctx.isCaseSensitive());
        searchContext.setNumberOfResults(ctx.getNumberOfResults());
        AdvancedFinderLoader loader = new AdvancedFinderLoader(this, searchContext);
        loader.load();
        this.finderHandlers.add(loader);
        this.state = 101;
        this.setSearchEnabled(true);
    }

    private ExperimenterData getUserDetails() {
        return (ExperimenterData)FinderFactory.getRegistry().lookup("/current_user/details");
    }

    private Set getAvailableGroups() {
        return (Set)FinderFactory.getRegistry().lookup("/userGroup/details");
    }

    private void showUserSelection() {
        IconManager icons = IconManager.getInstance();
        UserManagerDialog dialog = new UserManagerDialog(FinderFactory.getRefFrame(), this.getUserDetails(), this.getAvailableGroups(), icons.getIcon(42), icons.getIcon(70));
        dialog.addPropertyChangeListener(this);
        dialog.setDefaultSize();
        UIUtilities.centerAndShow(dialog);
    }

    private List<JButton> createControls() {
        ArrayList<JButton> list = new ArrayList<JButton>();
        IconManager icons = IconManager.getInstance();
        JButton button = new JButton(icons.getIcon(64));
        UIUtilities.unifiedButtonLookAndFeel(button);
        button.setToolTipText("Load existing Tags to search by.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedFinder.this.loadTags();
            }
        });
        list.add(button);
        return list;
    }

    private void loadTags() {
        if (this.tags == null) {
            TagsLoader loader = new TagsLoader(this);
            loader.load();
        } else {
            this.setExistingTags(this.tags);
        }
    }

    private void handleTagsSelection(Collection selected) {
        ArrayList<String> toAdd = new ArrayList<String>();
        if (selected == null || selected.size() == 0) {
            this.setSomeValues(toAdd);
            return;
        }
        for (TagAnnotationData tag : selected) {
            String value = tag.getTagValue();
            if (value.contains(" ")) {
                toAdd.add("\"" + value + "\"");
                continue;
            }
            toAdd.add(value);
        }
        this.setSomeValues(toAdd);
    }

    AdvancedFinder() {
        this.initialize(this.createControls());
        this.finderHandlers = new ArrayList<FinderLoader>();
        this.addPropertyChangeListener("search", this);
        this.addPropertyChangeListener("cancelSearch", this);
        this.addPropertyChangeListener("owner", this);
        this.users = new HashMap<Long, ExperimenterData>();
    }

    @Override
    protected void help() {
        SearchHelp help = new SearchHelp(FinderFactory.getRefFrame());
        UIUtilities.centerAndShow(help);
    }

    @Override
    public void cancel() {
        Iterator<FinderLoader> i = this.finderHandlers.iterator();
        while (i.hasNext()) {
            i.next().cancel();
        }
        this.state = 100;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void dispose() {
        this.setSearchEnabled(false);
        this.setVisible(false);
        this.cancel();
    }

    @Override
    public void setStatus(String text, boolean status) {
        if (text == null) {
            text = "";
        }
        this.setSearchEnabled(text, status);
    }

    @Override
    public void setResult(Object result) {
        this.setSearchEnabled(false);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        Map map = (Map)result;
        HashSet<DataObject> nodes = new HashSet<DataObject>();
        if (map != null) {
            Set set = map.entrySet();
            Iterator i = set.iterator();
            HashSet<Long> ids = new HashSet<Long>();
            while (i.hasNext()) {
                JLabel l;
                Map.Entry entry = i.next();
                Integer key = (Integer)entry.getKey();
                String term = this.getScope(key);
                if (term == null) continue;
                Object value = entry.getValue();
                if (value instanceof Integer) {
                    int v = (Integer)value;
                    l = v < 0 ? UIUtilities.setTextFont(term + ": Not supported." + " Refine criteria") : UIUtilities.setTextFont(term + ": " + "Too many results.");
                } else {
                    Collection r = (Collection)value;
                    for (DataObject data : r) {
                        if (ids.contains(data.getId())) continue;
                        nodes.add(data);
                        ids.add(data.getId());
                    }
                    l = UIUtilities.setTextFont(term + ": " + r.size());
                }
                p.add(l);
            }
            this.displayResult(UIUtilities.buildComponentPanel(p));
        }
        this.firePropertyChange("resultsFound", null, nodes);
    }

    @Override
    public void setExistingTags(Collection tags) {
        this.tags = tags;
        if (tags == null || tags.size() == 0) {
            UserNotifier un = FinderFactory.getRegistry().getUserNotifier();
            un.notifyInfo("Existing Tags", "No existing tags to search by.");
            return;
        }
        IconManager icons = IconManager.getInstance();
        String title = "Filter By Tags";
        String text = "Select the Tags to filter by.";
        ArrayList<Object> selected = new ArrayList<Object>();
        Iterator i = tags.iterator();
        List<String> l = this.getSome();
        ArrayList<Object> available = new ArrayList<Object>();
        while (i.hasNext()) {
            TagAnnotationData tag = (TagAnnotationData)i.next();
            if (l.contains(tag.getTagValue())) {
                selected.add(tag);
                continue;
            }
            available.add(tag);
        }
        long id = DataBrowserAgent.getUserDetails().getId();
        SelectionWizard wizard = new SelectionWizard(DataBrowserAgent.getRegistry().getTaskBar().getFrame(), available, selected, TagAnnotationData.class, false, id);
        wizard.setTitle(title, text, icons.getIcon(66));
        wizard.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(wizard);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block6: {
            String name;
            block9: {
                block8: {
                    block7: {
                        block5: {
                            name = evt.getPropertyName();
                            if (!"search".equals(name)) break block5;
                            SearchContext ctx = (SearchContext)evt.getNewValue();
                            if (ctx == null) {
                                return;
                            }
                            this.handleSearchContext(ctx);
                            break block6;
                        }
                        if (!"cancelSearch".equals(name)) break block7;
                        this.cancel();
                        break block6;
                    }
                    if (!"owner".equals(name)) break block8;
                    this.showUserSelection();
                    break block6;
                }
                if (!"userSwitch".equals(name)) break block9;
                Map m = (Map)evt.getNewValue();
                if (m == null) {
                    return;
                }
                Iterator i = m.keySet().iterator();
                while (i.hasNext()) {
                    ExperimenterData exp = (ExperimenterData)m.get(i.next());
                    this.users.put(exp.getId(), exp);
                    this.setUserString(exp.getId(), EditorUtil.formatExperimenter(exp));
                }
                break block6;
            }
            if (!"selectedItems".equals(name)) break block6;
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                this.handleTagsSelection((Collection)entry.getValue());
            }
        }
    }
}

