/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env;

import org.openmicroscopy.shoola.env.AWTExceptionHanlder;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.UIFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

class AbnormalExitHandler {
    private static AbnormalExitHandler singleton;
    private boolean inProgress = false;

    static void configure() {
        singleton = new AbnormalExitHandler();
        AWTExceptionHanlder.register();
    }

    static void terminate(Throwable t) {
        singleton.doTermination(t);
    }

    private AbnormalExitHandler() {
    }

    private synchronized void doTermination(Throwable t) {
        if (this.inProgress) {
            System.exit(1);
        }
        this.inProgress = true;
        LogMessage msg = new LogMessage();
        msg.println("Abnormal termination due to an uncaught exception.");
        msg.print(t);
        Container c = Container.getInstance();
        Logger logger = null;
        if (c != null) {
            logger = c.getRegistry().getLogger();
        }
        if (logger != null) {
            logger.fatal((Object)this, msg);
        } else {
            System.err.println(msg);
        }
        UserNotifier un = UIFactory.makeUserNotifier(c);
        un.notifyError("Abnormal Termination", "An unforeseen error occurred, the application will exit.", msg.toString());
        System.exit(1);
    }
}

