/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import java.util.HashMap;
import java.util.Map;
import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.openmicroscopy.shoola.env.config.IconFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class IconFactoryEntry
extends Entry {
    private static final String LOCATION_TAG = "location";
    private String location;
    private IconFactory factory;

    private Map extractValues(Node entry) throws DOMException, ConfigException {
        if (entry.hasChildNodes()) {
            HashMap<String, String> tags = new HashMap<String, String>();
            NodeList children = entry.getChildNodes();
            int n = children.getLength();
            while (0 < n) {
                Node child;
                if ((child = children.item(--n)).getNodeType() != 1 || !LOCATION_TAG.equals(child.getNodeName())) continue;
                tags.put(LOCATION_TAG, child.getFirstChild().getNodeValue());
                return tags;
            }
        }
        throw new ConfigException("The content of the icons structured entry is not valid.");
    }

    IconFactoryEntry() {
    }

    Object getValue() {
        if (this.factory == null) {
            this.factory = new IconFactory(this.location);
        }
        return this.factory;
    }

    protected void setContent(Node node) throws ConfigException {
        try {
            Map tags = this.extractValues(node);
            this.location = (String)tags.get(LOCATION_TAG);
        }
        catch (DOMException dex) {
            this.rethrow("Can't parse icons entry.", dex);
        }
    }
}

