/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import java.io.File;
import java.util.List;
import java.util.Map;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.env.data.model.ImportContext;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.calls.AcquisitionDataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.AcquisitionDataSaver;
import org.openmicroscopy.shoola.env.data.views.calls.Analyser;
import org.openmicroscopy.shoola.env.data.views.calls.EnumerationLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ExportLoader;
import org.openmicroscopy.shoola.env.data.views.calls.FRAPAnalyser;
import org.openmicroscopy.shoola.env.data.views.calls.FigureCreator;
import org.openmicroscopy.shoola.env.data.views.calls.ImageRenderer;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesImporter;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.MovieCreator;
import org.openmicroscopy.shoola.env.data.views.calls.OverlaysRenderer;
import org.openmicroscopy.shoola.env.data.views.calls.PixelsDataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.PlaneInfoLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ProjectionSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ROILoader;
import org.openmicroscopy.shoola.env.data.views.calls.ROISaver;
import org.openmicroscopy.shoola.env.data.views.calls.RenderingControlLoader;
import org.openmicroscopy.shoola.env.data.views.calls.RenderingSettingsLoader;
import org.openmicroscopy.shoola.env.data.views.calls.RenderingSettingsSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ScriptRunner;
import org.openmicroscopy.shoola.env.data.views.calls.ScriptUploader;
import org.openmicroscopy.shoola.env.data.views.calls.ServerSideROILoader;
import org.openmicroscopy.shoola.env.data.views.calls.WorkflowHandler;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import pojos.DataObject;
import pojos.PixelsData;
import pojos.ROIData;
import pojos.WorkflowData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageDataViewImpl
implements ImageDataView {
    ImageDataViewImpl() {
    }

    @Override
    public CallHandle loadRenderingControl(long pixelsID, int index, AgentEventListener observer) {
        int i = -1;
        switch (index) {
            default: {
                i = 0;
                break;
            }
            case 1: {
                i = 1;
                break;
            }
            case 2: {
                i = 2;
            }
        }
        RenderingControlLoader cmd = new RenderingControlLoader(pixelsID, i);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle render(long pixelsID, PlaneDef pd, boolean asTexture, boolean largeImage, AgentEventListener observer) {
        ImageRenderer cmd = new ImageRenderer(pixelsID, pd, asTexture, largeImage);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadPixels(long pixelsID, AgentEventListener observer) {
        PixelsDataLoader cmd = new PixelsDataLoader(pixelsID, 1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle analyseShapes(PixelsData pixels, List channels, List shapes, AgentEventListener observer) {
        Analyser cmd = new Analyser(pixels, channels, shapes);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle getRenderingSettings(long pixelsID, AgentEventListener observer) {
        return this.getRenderingSettings(pixelsID, -1L, observer);
    }

    @Override
    public CallHandle getRenderingSettings(long pixelsID, long userID, AgentEventListener observer) {
        RenderingSettingsLoader cmd = new RenderingSettingsLoader(pixelsID, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle renderProjected(long pixelsID, int startZ, int endZ, int stepping, int algorithm, List<Integer> channels, boolean openGLSupport, AgentEventListener observer) {
        ProjectionSaver cmd = new ProjectionSaver(pixelsID, startZ, endZ, stepping, algorithm, channels, openGLSupport);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle projectImage(ProjectionParam ref, AgentEventListener observer) {
        ProjectionSaver cmd = new ProjectionSaver(ref);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createRndSetting(long pixelsID, RndProxyDef rndToCopy, List<Integer> indexes, AgentEventListener observer) {
        RenderingSettingsSaver cmd = new RenderingSettingsSaver(pixelsID, rndToCopy, indexes);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadAcquisitionData(Object refObject, AgentEventListener observer) {
        AcquisitionDataLoader cmd = new AcquisitionDataLoader(refObject);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadInstrumentData(long instrumentID, AgentEventListener observer) {
        AcquisitionDataLoader cmd = new AcquisitionDataLoader(0, instrumentID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveAcquisitionData(Object refObject, AgentEventListener observer) {
        AcquisitionDataSaver cmd = new AcquisitionDataSaver(refObject);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadPlaneInfo(long pixelsID, int z, int t, int channel, AgentEventListener observer) {
        PlaneInfoLoader cmd = new PlaneInfoLoader(pixelsID, z, t, channel);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadChannelMetadataEnumerations(AgentEventListener observer) {
        EnumerationLoader cmd = new EnumerationLoader(1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadImageMetadataEnumerations(AgentEventListener observer) {
        EnumerationLoader cmd = new EnumerationLoader(0);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle importFiles(ImportContext context, long userID, long groupID, AgentEventListener observer) {
        ImagesImporter cmd = new ImagesImporter(context, userID, groupID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle monitorDirectory(File directory, DataObject container, long userID, long groupID, AgentEventListener observer) {
        return null;
    }

    @Override
    public CallHandle loadImage(long imageID, long userID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(imageID, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createMovie(long imageID, long pixelsID, List<Integer> channels, MovieExportParam param, AgentEventListener observer) {
        MovieCreator cmd = new MovieCreator(imageID, pixelsID, channels, param);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createFigure(List<Long> ids, Class type, Object param, AgentEventListener observer) {
        FigureCreator cmd = new FigureCreator(ids, type, param);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadROI(long imageID, List<Long> fileID, long userID, AgentEventListener observer) {
        ROILoader cmd = new ROILoader(imageID, fileID, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveROI(long imageID, long userID, List<ROIData> roiList, AgentEventListener observer) {
        ROISaver cmd = new ROISaver(imageID, userID, roiList);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle exportImageAsOMETiff(long imageID, File file, AgentEventListener observer) {
        ExportLoader cmd = new ExportLoader(imageID, file, 0);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadROIFromServer(long imageID, long userID, AgentEventListener observer) {
        ServerSideROILoader cmd = new ServerSideROILoader(imageID, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle renderOverLays(long pixelsID, PlaneDef pd, long tableID, Map<Long, Integer> overlays, boolean asTexture, AgentEventListener observer) {
        OverlaysRenderer cmd = new OverlaysRenderer(pixelsID, pd, tableID, overlays, asTexture);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle analyseFRAP(List<Long> ids, Class objectType, Object param, AgentEventListener observer) {
        FRAPAnalyser cmd = new FRAPAnalyser(ids, objectType, param);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle runScript(ScriptObject script, AgentEventListener observer) {
        ScriptRunner cmd = new ScriptRunner(script);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle uploadScript(ScriptObject script, AgentEventListener observer) {
        ScriptUploader cmd = new ScriptUploader(script);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle retrieveWorkflows(long userID, AgentEventListener observer) {
        WorkflowHandler cmd = new WorkflowHandler(userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle storeWorkflows(List<WorkflowData> workflows, long userID, AgentEventListener observer) {
        WorkflowHandler cmd = new WorkflowHandler(workflows, userID);
        return cmd.exec(observer);
    }
}

