/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.model.TableParameters;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;
import org.openmicroscopy.shoola.env.data.views.calls.ArchivedFilesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ArchivedFilesSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ArchivedImageLoader;
import org.openmicroscopy.shoola.env.data.views.calls.DataFilter;
import org.openmicroscopy.shoola.env.data.views.calls.DataObjectSaver;
import org.openmicroscopy.shoola.env.data.views.calls.FileUploader;
import org.openmicroscopy.shoola.env.data.views.calls.FilesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.RelatedContainersLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ScriptsLoader;
import org.openmicroscopy.shoola.env.data.views.calls.StructuredAnnotationLoader;
import org.openmicroscopy.shoola.env.data.views.calls.StructuredAnnotationSaver;
import org.openmicroscopy.shoola.env.data.views.calls.TabularDataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ThumbnailLoader;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.FileAnnotationData;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataHandlerViewImpl
implements MetadataHandlerView {
    MetadataHandlerViewImpl() {
    }

    @Override
    public CallHandle loadContainers(Class type, long id, long userID, AgentEventListener observer) {
        RelatedContainersLoader cmd = new RelatedContainersLoader(type, id, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadThumbnails(ImageData image, Set<Long> userIDs, int thumbWidth, int thumbHeight, AgentEventListener observer) {
        ThumbnailLoader cmd = new ThumbnailLoader(image, thumbWidth, thumbHeight, userIDs);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadStructuredData(Object dataObject, long userID, AgentEventListener observer) {
        StructuredAnnotationLoader cmd = new StructuredAnnotationLoader(1, dataObject, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadStructuredData(List<DataObject> data, long userID, boolean viewed, AgentEventListener observer) {
        StructuredAnnotationLoader cmd = new StructuredAnnotationLoader(1, data, userID, viewed);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadExistingAnnotations(Class annotation, long userID, long groupID, AgentEventListener observer) {
        StructuredAnnotationLoader cmd = new StructuredAnnotationLoader(annotation, userID, groupID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveData(Collection<DataObject> data, List<AnnotationData> toAdd, List<AnnotationData> toRemove, List<Object> metadata, long userID, AgentEventListener observer) {
        StructuredAnnotationSaver cmd = new StructuredAnnotationSaver(data, toAdd, toRemove, metadata, userID, false);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveBatchData(Collection<DataObject> data, List<AnnotationData> toAdd, List<AnnotationData> toRemove, long userID, AgentEventListener observer) {
        StructuredAnnotationSaver cmd = new StructuredAnnotationSaver(data, toAdd, toRemove, null, userID, true);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveBatchData(TimeRefObject refObject, List<AnnotationData> toAdd, List<AnnotationData> toRemove, long userID, AgentEventListener observer) {
        StructuredAnnotationSaver cmd = new StructuredAnnotationSaver(refObject, toAdd, toRemove, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadFile(File file, long fileID, long size, AgentEventListener observer) {
        FilesLoader cmd = new FilesLoader(file, fileID, size);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadFile(File file, long fileID, int index, AgentEventListener observer) {
        FilesLoader cmd = new FilesLoader(file, fileID, index);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadOriginalFiles(Collection<Long> pixelsID, AgentEventListener observer) {
        ArchivedFilesLoader cmd = new ArchivedFilesLoader(pixelsID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadArchivedImage(long pixelsID, String path, AgentEventListener observer) {
        ArchivedImageLoader cmd = new ArchivedImageLoader(pixelsID, path);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadRatings(Class nodeType, List<Long> nodeIDs, long userID, AgentEventListener observer) {
        StructuredAnnotationLoader cmd = new StructuredAnnotationLoader(10, nodeType, nodeIDs, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle filterByAnnotation(Class nodeType, List<Long> nodeIds, Class annotationType, List<String> terms, long userID, AgentEventListener observer) {
        DataFilter cmd = new DataFilter(annotationType, nodeType, nodeIds, terms, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle filterByAnnotated(Class nodeType, List<Long> nodeIds, Class annotationType, boolean annotated, long userID, AgentEventListener observer) {
        DataFilter cmd = new DataFilter(annotationType, nodeType, nodeIds, annotated, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle filterData(Class nodeType, List<Long> nodeIds, FilterContext context, long userID, AgentEventListener observer) {
        DataFilter cmd = new DataFilter(nodeType, nodeIds, context, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createDataObject(DataObject parent, DataObject data, Collection children, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(parent, data, children);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveFile(FileAnnotationData fileAnnotation, File file, int index, DataObject linkTo, AgentEventListener observer) {
        ArchivedFilesSaver cmd = new ArchivedFilesSaver(fileAnnotation, file, index, linkTo);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadAnnotation(long annotationID, AgentEventListener observer) {
        StructuredAnnotationLoader cmd = new StructuredAnnotationLoader(annotationID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle updateDataObjects(List<DataObject> objects, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(objects, null, 1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle submitFile(MessengerDetails details, AgentEventListener observer) {
        FileUploader cmd = new FileUploader(details);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadROIMeasurement(Object dataObject, long userID, AgentEventListener observer) {
        StructuredAnnotationLoader cmd = new StructuredAnnotationLoader(11, dataObject, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadFiles(Map<FileAnnotationData, File> files, AgentEventListener observer) {
        FilesLoader cmd = new FilesLoader(files);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadScripts(long userID, boolean all, AgentEventListener observer) {
        int index = 2;
        if (all) {
            index = 1;
        }
        ScriptsLoader cmd = new ScriptsLoader(userID, index);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadScript(long scriptID, AgentEventListener observer) {
        ScriptsLoader cmd = new ScriptsLoader(scriptID, 0);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadTabularData(TableParameters parameters, long userID, AgentEventListener observer) {
        TabularDataLoader cmd = new TabularDataLoader(parameters, userID);
        return cmd.exec(observer);
    }
}

