/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.data.model.ImportContext;
import org.openmicroscopy.shoola.env.data.model.ImportObject;
import org.openmicroscopy.shoola.env.data.util.StatusLabel;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class ImagesImporter
extends BatchCallTree {
    private Object results;
    private BatchCall loadCall;
    private long userID;
    private long groupID;
    private Map<File, Object> partialResult;
    private ImportContext context;

    private void importFile(File f, StatusLabel status, String name) {
        this.partialResult = new HashMap<File, Object>();
    }

    private void importFolder(File f, StatusLabel status, String name) {
        this.partialResult = new HashMap<File, Object>();
    }

    protected void buildTree() {
        List<ImportObject> files = this.context.getFiles();
        for (ImportObject io : files) {
            File ho = io.getFile();
            final String name = io.getName();
            final StatusLabel label = io.getStatus();
            final File f = io.getFile();
            if (ho.isDirectory()) {
                this.add(new BatchCall("Importing file"){

                    public void doCall() {
                        ImagesImporter.this.importFolder(f, label, name);
                    }
                });
                continue;
            }
            this.add(new BatchCall("Importing file"){

                public void doCall() {
                    ImagesImporter.this.importFile(f, label, name);
                }
            });
        }
    }

    protected Object getPartialResult() {
        return this.partialResult;
    }

    protected Object getResult() {
        if (this.loadCall != null) {
            return this.results;
        }
        return null;
    }

    public ImagesImporter(ImportContext context, long userID, long groupID) {
        if (context == null || context.getFiles() == null || context.getFiles().size() == 0) {
            throw new IllegalArgumentException("No Files to import.");
        }
        this.userID = userID;
        this.groupID = groupID;
        this.context = context;
    }
}

