/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutBox
extends MessageBox {
    private Map<Agent, AgentSaveInfo> map;
    private JCheckBox saveAll;
    private Map<Agent, List<CheckOutItem>> components;

    private void handleSelection() {
        if (this.components == null) {
            return;
        }
        Iterator<Map.Entry<Agent, List<CheckOutItem>>> i = this.components.entrySet().iterator();
        boolean selected = this.saveAll.isSelected();
        while (i.hasNext()) {
            Map.Entry<Agent, List<CheckOutItem>> entry = i.next();
            List<CheckOutItem> l = entry.getValue();
            if (l == null) continue;
            for (CheckOutItem item : l) {
                item.setEnabled(selected);
            }
        }
    }

    private void initComponents() {
        this.saveAll = new JCheckBox("Save Changes");
        if (this.map != null && this.map.size() > 0) {
            this.saveAll.setSelected(true);
        }
        this.saveAll.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CheckoutBox.this.handleSelection();
            }
        });
    }

    private JComponent buildAgentEntry(Agent agent, AgentSaveInfo info) {
        ArrayList<CheckOutItem> items = new ArrayList<CheckOutItem>();
        JXTaskPane pane = UIUtilities.createTaskPane(info.getName(), null);
        pane.setCollapsed(false);
        List<Object> instances = info.getInstances();
        Iterator<Object> i = instances.iterator();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        while (i.hasNext()) {
            CheckOutItem box = new CheckOutItem(info.getName(), i.next());
            items.add(box);
            p.add(box);
        }
        this.components.put(agent, items);
        pane.add((Component)UIUtilities.buildComponentPanel(p));
        return pane;
    }

    private void buildGUI() {
        if (this.map == null || this.map.size() == 0) {
            return;
        }
        this.components = new HashMap<Agent, List<CheckOutItem>>();
        Iterator<Map.Entry<Agent, AgentSaveInfo>> i = this.map.entrySet().iterator();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(UIUtilities.buildComponentPanel(this.saveAll));
        p.add(Box.createVerticalStrut(5));
        while (i.hasNext()) {
            Map.Entry<Agent, AgentSaveInfo> entry = i.next();
            p.add(this.buildAgentEntry(entry.getKey(), entry.getValue()));
        }
        this.addBodyComponent(p);
    }

    public CheckoutBox(JFrame owner, String title, String message, Icon icon, Map<Agent, AgentSaveInfo> map) {
        super(owner, title, message, icon);
        this.map = map;
        this.initComponents();
        this.buildGUI();
    }

    public CheckoutBox(JFrame owner, String title, String message, Map<Agent, AgentSaveInfo> map) {
        this(owner, title, message, null, map);
    }

    Map<Agent, AgentSaveInfo> getInstancesToSave() {
        if (!this.saveAll.isSelected()) {
            return null;
        }
        HashMap<Agent, AgentSaveInfo> toSave = new HashMap<Agent, AgentSaveInfo>();
        for (Map.Entry<Agent, List<CheckOutItem>> entry : this.components.entrySet()) {
            List<CheckOutItem> list = entry.getValue();
            Iterator<CheckOutItem> j = list.iterator();
            ArrayList<Object> instances = new ArrayList<Object>();
            String name = "";
            while (j.hasNext()) {
                CheckOutItem item = j.next();
                if (!item.isSelected()) continue;
                name = item.getRefName();
                instances.add(item.getInstance());
            }
            if (instances.size() <= 0) continue;
            toSave.put(entry.getKey(), new AgentSaveInfo(name, instances));
        }
        return toSave;
    }

    class CheckOutItem
    extends JCheckBox {
        private Object instance;
        private String refName;

        CheckOutItem(String refName, Object instance) {
            super(instance.toString());
            this.refName = refName;
            this.setSelected(true);
        }

        Object getInstance() {
            return this.instance;
        }

        String getRefName() {
            return this.refName;
        }
    }
}

