/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.util.List;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ProcessCallback;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectRemover
extends UserNotifierLoader {
    private CallHandle handle;
    private ProcessCallback callBack;
    private List<DeletableObject> objects;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to delete the object", message, ex);
    }

    public DataObjectRemover(UserNotifier viewer, Registry registry, List<DeletableObject> objects, ActivityComponent activity) {
        super(viewer, registry, activity);
        if (objects == null || objects.size() == 0) {
            throw new IllegalArgumentException("No Objects to delete.");
        }
        this.objects = objects;
    }

    @Override
    public void load() {
        this.handle = this.dmView.delete(this.objects, (AgentEventListener)this);
    }

    @Override
    public void cancel() {
        try {
            if (this.callBack != null) {
                this.callBack.cancel();
                this.activity.onActivityCancelled();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                if (!b.booleanValue()) {
                    this.onException("Unable to start the script.", null);
                }
            } else {
                this.callBack = (ProcessCallback)o;
                this.callBack.setAdapter(this);
                this.activity.onCallBackSet();
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (result == null) {
            this.onException("No result returned.", null);
        } else if (!(result instanceof Boolean)) {
            this.activity.endActivity(result);
        }
    }
}

