/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class FileLoader
extends UserNotifierLoader {
    public static final int ORIGINAL_FILE = 0;
    public static final int FILE_ANNOTATION = 1;
    private long fileID;
    private File file;
    private long size;
    private boolean toLoad;
    private int index;
    private CallHandle handle;

    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to download the file", message, ex);
    }

    FileLoader(UserNotifier viewer, Registry reg, File file, long fileID, long size, boolean toLoad, ActivityComponent activity) {
        super(viewer, reg, activity);
        this.file = file;
        this.fileID = fileID;
        this.size = size;
        this.toLoad = toLoad;
        this.index = -1;
    }

    FileLoader(UserNotifier viewer, Registry reg, File file, long fileID, int index, boolean toLoad, ActivityComponent activity) {
        super(viewer, reg, activity);
        this.file = file;
        this.fileID = fileID;
        this.toLoad = toLoad;
        this.index = index;
    }

    public void load() {
        if (this.toLoad) {
            switch (this.index) {
                case 0: 
                case 1: {
                    this.handle = this.mhView.loadFile(this.file, this.fileID, this.index, (AgentEventListener)this);
                    break;
                }
                default: {
                    this.handle = this.mhView.loadFile(this.file, this.fileID, this.size, (AgentEventListener)this);
                    break;
                }
            }
        } else {
            this.handleResult(this.file);
        }
    }

    public void cancel() {
        if (this.handle != null) {
            this.handle.cancel();
        }
        this.file.delete();
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }

    public void handleResult(Object result) {
        if (result == null) {
            this.onException("No result returned.", null);
        } else if (this.activity != null) {
            this.activity.endActivity(result);
        }
    }
}

