/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.OMEROInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.data.events.SaveEventResponse;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationRequest;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationResponse;
import org.openmicroscopy.shoola.env.data.events.SwitchUserGroup;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.AbstractIconManager;
import org.openmicroscopy.shoola.env.ui.CheckoutBox;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.SoftwareUpdateDialog;
import org.openmicroscopy.shoola.env.ui.SwitchUserLoader;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TaskBarView;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierImpl;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.file.IOUtil;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.BrowserLauncher;
import org.openmicroscopy.shoola.util.ui.MacOSMenuHandler;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ScreenLoginDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskBarManager
implements AgentEventListener,
PropertyChangeListener {
    static final String TITLE_ABOUT = "About";
    static final String ACTIVITIES_PROPERTY = "activities";
    private static final String A_TAG = "a";
    private static final String SWITCH_GROUP_TITLE = "Switch Group";
    private static final String SWITCH_GROUP_TEXT = "Switching group will remove data from the display. \nDo you want to continue?";
    private static final String CLOSE_APP_TITLE = "Exit Application";
    private static final String CLOSE_APP_TEXT = "Do you really want to close the application?";
    private TaskBarView view;
    private Container container;
    private SoftwareUpdateDialog suDialog;
    private ScreenLoginDialog login;
    private boolean success;
    private Map<Agent, Integer> exitResponses;

    private String parse(String refFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(refFile));
            NodeList list = document.getElementsByTagName(A_TAG);
            String url = null;
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                url = n.getFirstChild().getNodeValue();
            }
            return url;
        }
        catch (Exception e) {
            if (this.suDialog != null) {
                this.suDialog.close();
            }
            Logger logger = this.container.getRegistry().getLogger();
            LogMessage msg = new LogMessage();
            msg.print("Error while saving.");
            msg.print(e);
            logger.error((Object)this, msg);
            return null;
        }
    }

    private String loadAbout(String file) {
        String message;
        try {
            String line;
            InputStream fis = IOUtil.readConfigFile(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            StringBuffer buffer = new StringBuffer();
            int number = 0;
            while ((line = in.readLine()) != null) {
                if (number != 0) {
                    buffer.append(line);
                }
                ++number;
            }
            in.close();
            message = buffer.toString();
        }
        catch (Exception e) {
            message = "Error: Cannot find the About file.";
            Logger logger = this.container.getRegistry().getLogger();
            LogMessage msg = new LogMessage();
            msg.print(message);
            msg.print(e);
            logger.error((Object)this, msg);
        }
        return message;
    }

    private void synchConnectionButtons() {
        boolean connected = false;
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            connected = f.isConnected();
        }
        catch (DSOutOfServiceException dSOutOfServiceException) {
            // empty catch block
        }
        this.view.getButton(9).setEnabled(!connected);
        this.view.getButton(1).setEnabled(!connected);
        this.view.getButton(10).setEnabled(connected);
        this.view.getButton(2).setEnabled(connected);
    }

    private void doManageConnection() {
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            if (f.isConnected()) {
                f.shutdown();
                this.synchConnectionButtons();
            } else {
                EventBus bus = this.container.getRegistry().getEventBus();
                bus.post(new ServiceActivationRequest(1));
            }
        }
        catch (DSOutOfServiceException oose) {
            this.synchConnectionButtons();
        }
    }

    private void handleSaveEventResponse(SaveEventResponse e) {
        int v;
        if (e == null) {
            return;
        }
        Agent a = e.getAgent();
        Integer r = this.exitResponses.get(a);
        if (r != null && (v = r - 1) == 0) {
            this.exitResponses.remove(a);
        }
        if (this.exitResponses.size() == 0) {
            this.container.exit();
        }
    }

    private void notAvailable() {
        UserNotifier un = this.container.getRegistry().getUserNotifier();
        un.notifyInfo("Not Available", "Sorry, this functionality is not yet available.");
    }

    private void sendComment() {
        Registry reg = this.container.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        ExperimenterData exp = (ExperimenterData)reg.lookup("/current_user/details");
        String email = "";
        if (exp != null) {
            email = exp.getEmail();
        }
        un.submitMessage(email, "");
    }

    private Map<Agent, AgentSaveInfo> getInstancesToSave() {
        List agents = (List)this.container.getRegistry().lookup("/agents");
        Iterator i = agents.iterator();
        HashMap<Agent, AgentSaveInfo> l = new HashMap<Agent, AgentSaveInfo>();
        while (i.hasNext()) {
            AgentSaveInfo info;
            Agent agent;
            AgentInfo ai = (AgentInfo)i.next();
            if (!ai.isActive() || (agent = ai.getAgent()) == null || (info = agent.getDataToSave()) == null || info.getCount() <= 0) continue;
            l.put(agent, info);
        }
        return l;
    }

    private void handleSwitchUserGroup(SwitchUserGroup evt) {
        if (evt == null) {
            return;
        }
        CheckoutBox box = new CheckoutBox((JFrame)this.view, SWITCH_GROUP_TITLE, SWITCH_GROUP_TEXT, this.getInstancesToSave());
        if (box.centerMsgBox() == 1) {
            Map<Agent, AgentSaveInfo> map = box.getInstancesToSave();
            UserNotifierImpl un = (UserNotifierImpl)this.container.getRegistry().getUserNotifier();
            ArrayList<Object> nodes = new ArrayList<Object>();
            if (map != null) {
                Iterator<AgentSaveInfo> i = map.values().iterator();
                while (i.hasNext()) {
                    nodes.add(i.next());
                }
            }
            nodes.add(evt.getExperimenterData());
            un.notifySaving(nodes, null);
            Registry reg = this.container.getRegistry();
            SwitchUserLoader loader = new SwitchUserLoader(reg.getUserNotifier(), reg, evt.getExperimenterData(), evt.getGroupID());
            ((UserNotifierLoader)loader).load();
        }
    }

    private void doExit(boolean askQuestion) {
        IconManager icons = IconManager.getInstance(this.container.getRegistry());
        int option = 1;
        Map<Agent, AgentSaveInfo> instances = this.getInstancesToSave();
        CheckoutBox msg = null;
        if (askQuestion) {
            msg = new CheckoutBox(this.view, CLOSE_APP_TITLE, CLOSE_APP_TEXT, icons.getIcon(10), instances);
            option = msg.centerMsgBox();
        }
        if (option == 1) {
            if (msg == null) {
                this.exitApplication();
            } else {
                Map<Agent, AgentSaveInfo> map = msg.getInstancesToSave();
                if (map == null || map.size() == 0) {
                    this.exitApplication();
                } else {
                    ArrayList<Object> nodes = new ArrayList<Object>();
                    Iterator<AgentSaveInfo> i = map.values().iterator();
                    while (i.hasNext()) {
                        nodes.add(i.next());
                    }
                    UserNotifierImpl un = (UserNotifierImpl)this.container.getRegistry().getUserNotifier();
                    un.notifySaving(nodes, this);
                }
            }
        }
    }

    private void exitApplication() {
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            f.exitApplication();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void softwareAbout() {
        String aboutFile = (String)this.container.getRegistry().lookup("AboutFile");
        String refFile = this.container.resolveFilePath(aboutFile, "config");
        String message = this.loadAbout(refFile);
        String title = (String)this.container.getRegistry().lookup("SoftwareName");
        this.suDialog = new SoftwareUpdateDialog(this.view, message, refFile);
        this.suDialog.setTitle("About " + title + "...");
        this.suDialog.addPropertyChangeListener("openURL", this);
        UIUtilities.centerAndShow(this.suDialog);
    }

    private void help() {
        String path = (String)this.container.getRegistry().lookup("HelpOnLine");
        this.openURL(path);
    }

    private void forum() {
        String path = (String)this.container.getRegistry().lookup("Forum");
        this.openURL(path);
    }

    private void logFile() {
        String logDirName = (String)this.container.getRegistry().lookup("/services/LOG/dir");
        String name = (String)this.container.getRegistry().lookup("/user/home/omero");
        String path = name + File.separator + logDirName;
        this.container.getRegistry().getUserNotifier().openApplication(new ApplicationData(""), path);
    }

    private void attachMIListeners() {
        ActionListener noOp = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.notAvailable();
            }
        };
        this.view.getButton(3).addActionListener(noOp);
        this.view.getButton(4).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.help();
            }
        });
        this.view.getButton(5).addActionListener(noOp);
        this.view.getButton(6).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.softwareAbout();
            }
        });
        this.view.getButton(7).addActionListener(noOp);
        this.view.getButton(11).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.help();
            }
        });
        this.view.getButton(12).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.sendComment();
            }
        });
        this.view.getButton(13).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.forum();
            }
        });
        this.view.getButton(14).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ((UserNotifierImpl)TaskBarManager.this.container.getRegistry().getUserNotifier()).showActivity();
            }
        });
        this.view.getButton(15).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.logFile();
            }
        });
    }

    private void attachConnectionListeners() {
        ActionListener conx = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.doManageConnection();
            }
        };
        this.view.getButton(9).addActionListener(conx);
        this.view.getButton(1).addActionListener(conx);
        this.view.getButton(10).addActionListener(conx);
        this.view.getButton(2).addActionListener(conx);
    }

    private void attachOpenExitListeners() {
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                TaskBarManager.this.doExit(true);
            }

            public void windowOpened(WindowEvent we) {
                TaskBarManager.this.synchConnectionButtons();
            }
        });
    }

    private void attachListeners() {
        this.attachOpenExitListeners();
        this.attachConnectionListeners();
        this.attachMIListeners();
        EventBus bus = this.container.getRegistry().getEventBus();
        bus.register((AgentEventListener)this, ServiceActivationResponse.class);
        bus.register((AgentEventListener)this, ExitApplication.class);
        bus.register((AgentEventListener)this, SaveEventResponse.class);
        bus.register((AgentEventListener)this, SwitchUserGroup.class);
        if (UIUtilities.isMacOS()) {
            try {
                MacOSMenuHandler handler = new MacOSMenuHandler(this.view);
                handler.initialize();
                this.view.addPropertyChangeListener(this);
            }
            catch (Throwable e) {
                Logger logger = this.container.getRegistry().getLogger();
                LogMessage message = new LogMessage();
                message.print(e);
                logger.info((Object)this, message);
            }
        }
    }

    private void collectCredentials(LoginCredentials lc) {
        UserCredentials uc = new UserCredentials(lc.getUserName(), lc.getPassword(), lc.getHostName(), lc.getSpeedLevel());
        uc.setPort(lc.getPort());
        uc.setEncrypted(lc.isEncrypted());
        LoginService svc = (LoginService)this.container.getRegistry().lookup("/services/Login");
        switch (svc.login(uc)) {
            case 1: {
                this.container.getRegistry().bind("/user/credentials", uc);
                this.login.close();
                this.success = true;
                break;
            }
            case 2: {
                this.success = false;
                svc.notifyLoginTimeout();
                if (this.login == null) break;
                this.login.cleanField(1);
                this.login.requestFocusOnField();
                break;
            }
            case 0: {
                this.success = false;
                svc.notifyLoginFailure();
                if (this.login == null) break;
                this.login.cleanField(1);
                this.login.requestFocusOnField();
            }
        }
    }

    TaskBarManager(Container c) {
        this.container = c;
        this.view = new TaskBarView(this, IconManager.getInstance(c.getRegistry()));
        this.attachListeners();
    }

    TaskBar getView() {
        return this.view;
    }

    String getSoftwareName() {
        return (String)this.container.getRegistry().lookup("SoftwareName");
    }

    void openURL(String url) {
        BrowserLauncher launcher = new BrowserLauncher(AbstractIconManager.getOMEIcon());
        launcher.openURL(url);
        if (this.suDialog != null) {
            this.suDialog.close();
        }
    }

    boolean login() {
        try {
            DataServicesFactory factory = DataServicesFactory.getInstance(this.container);
            if (factory.isConnected()) {
                return true;
            }
            if (this.login == null) {
                Image img = IconManager.getOMEImageIcon();
                Object version = this.container.getRegistry().lookup("Version");
                String v = "";
                if (version != null && version instanceof String) {
                    v = (String)version;
                }
                OMEROInfo omeroInfo = (OMEROInfo)this.container.getRegistry().lookup("/services/OMERODS");
                String port = "" + omeroInfo.getPortSSL();
                String f = this.container.resolveFilePath(null, "config");
                String n = (String)this.container.getRegistry().lookup("SplashScreenLogin");
                Icon splashLogin = Factory.createIcon(n, f);
                if (splashLogin == null) {
                    splashLogin = IconManager.getLoginBackground();
                }
                this.login = new ScreenLoginDialog("Open Microscopy Environment", splashLogin, img, v, port);
                this.login.showConnectionSpeed(true);
                this.login.addPropertyChangeListener(this);
            }
            UIUtilities.centerAndShow(this.login);
            return this.success;
        }
        catch (Exception exception) {
            return this.success;
        }
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof ServiceActivationResponse) {
            this.synchConnectionButtons();
        } else if (e instanceof ExitApplication) {
            this.doExit(((ExitApplication)e).isAskQuestion());
        } else if (e instanceof SwitchUserGroup) {
            this.handleSwitchUserGroup((SwitchUserGroup)e);
        } else if (e instanceof SaveEventResponse) {
            this.handleSaveEventResponse((SaveEventResponse)e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Boolean value;
        String name = evt.getPropertyName();
        if ("openURL".equals(name)) {
            String refFile = (String)evt.getNewValue();
            if (refFile != null) {
                this.openURL(this.parse(refFile));
            }
        } else if ("aboutApplication".equals(name)) {
            this.softwareAbout();
        } else if ("quitpplication".equals(name)) {
            Registry reg = this.container.getRegistry();
            Object exp = reg.lookup("/current_user/details");
            if (exp == null) {
                this.container.exit();
            } else {
                this.doExit(true);
            }
        } else if ("login".equals(name)) {
            LoginCredentials lc = (LoginCredentials)evt.getNewValue();
            if (lc != null) {
                this.collectCredentials(lc);
            }
        } else if ("quit".equals(name)) {
            this.login.close();
            this.success = false;
        } else if ("Done".equals(name) && (value = (Boolean)evt.getNewValue()).booleanValue()) {
            this.exitApplication();
        }
    }
}

