/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.svc.transport;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.openmicroscopy.shoola.svc.proxy.Reply;
import org.openmicroscopy.shoola.svc.proxy.Request;
import org.openmicroscopy.shoola.svc.transport.TransportException;

public abstract class HttpChannel {
    public static final int DEFAULT = 0;
    public static final int CONNECTION_PER_REQUEST = 1;
    static final String PROXY_HOST = "http.proxyHost";
    static final String PROXY_PORT = "http.proxyPort";

    protected abstract HttpClient getCommunicationLink();

    protected abstract String getRequestPath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchange(Request out, Reply in) throws TransportException, IOException {
        if (out == null) {
            throw new NullPointerException("No request.");
        }
        if (in == null) {
            throw new NullPointerException("No reply.");
        }
        HttpClient comLink = this.getCommunicationLink();
        HttpMethod method = null;
        try {
            method = out.marshal();
            method.setPath(this.getRequestPath());
            comLink.executeMethod(method);
            in.unmarshal(method, this);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

