/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.geom.BezierPath;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.LineTextFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureLineFigure
extends LineTextFigure
implements ROIFigure {
    private boolean readOnly;
    private boolean clientObject;
    private boolean dirty;
    private List<Rectangle2D> boundsArray = new ArrayList<Rectangle2D>();
    private List<Double> lengthArray = new ArrayList<Double>();
    private List<Double> angleArray = new ArrayList<Double>();
    private List<Double> pointArrayX = new ArrayList<Double>();
    private List<Double> pointArrayY = new ArrayList<Double>();
    protected ROI roi = null;
    protected ROIShape shape = null;
    private MeasurementUnits units;
    private int status = 0;

    private Point2D.Double getPt(int i) {
        if (this.units.isInMicrons()) {
            Point2D.Double pt = this.getPoint(i);
            return new Point2D.Double(pt.getX() * this.units.getMicronsPixelX(), pt.getY() * this.units.getMicronsPixelY());
        }
        return this.getPoint(i);
    }

    public MeasureLineFigure() {
        this("Text", false, true);
    }

    public MeasureLineFigure(boolean readOnly, boolean clientObject) {
        this("Text", readOnly, clientObject);
    }

    public MeasureLineFigure(String text, boolean readOnly, boolean clientObject) {
        super(text);
        this.setReadOnly(readOnly);
        this.setClientObject(clientObject);
    }

    public void draw(Graphics2D g) {
        super.draw(g);
        this.boundsArray.clear();
        this.lengthArray.clear();
        this.angleArray.clear();
        if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue()) {
            double sz;
            int x;
            Rectangle2D.Double bounds;
            Point2D.Double lengthPoint;
            if (this.getPointCount() == 2) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                double angle = this.getAngle(0, 1);
                if (angle > 90.0) {
                    angle = Math.abs(angle - 180.0);
                }
                this.angleArray.add(angle);
                String lineAngle = formatter.format(angle);
                lineAngle = this.addDegrees(lineAngle);
                double sz2 = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz2));
                Rectangle2D rect = g.getFontMetrics().getStringBounds(lineAngle, g);
                lengthPoint = this.getLengthPosition(0, 1);
                bounds = new Rectangle2D.Double(lengthPoint.x, lengthPoint.y + rect.getHeight() * 2.0, rect.getWidth(), rect.getHeight());
                g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(lineAngle, (int)((RectangularShape)bounds).getX(), (int)((RectangularShape)bounds).getY());
                this.boundsArray.add(bounds);
            }
            for (x = 1; x < this.getPointCount() - 1; ++x) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                double angle = this.getAngle(x - 1, x, x + 1);
                this.angleArray.add(angle);
                String lineAngle = formatter.format(angle);
                lineAngle = this.addDegrees(lineAngle);
                sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz));
                Rectangle2D rect = g.getFontMetrics().getStringBounds(lineAngle, g);
                bounds = new Rectangle2D.Double(this.getPoint((int)x).x, this.getPoint((int)x).y, rect.getWidth(), rect.getHeight());
                g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(lineAngle, (int)((RectangularShape)bounds).getX(), (int)((RectangularShape)bounds).getY());
                this.boundsArray.add(bounds);
            }
            for (x = 1; x < this.getPointCount(); ++x) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                double length = this.getLength(x - 1, x);
                this.lengthArray.add(length);
                String lineLength = formatter.format(length);
                lineLength = this.addUnits(lineLength);
                sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz));
                lengthPoint = this.getLengthPosition(x - 1, x);
                Rectangle2D rect = g.getFontMetrics().getStringBounds(lineLength, g);
                Rectangle2D.Double bounds2 = new Rectangle2D.Double(lengthPoint.x - 15.0, lengthPoint.y - 15.0, rect.getWidth() + 30.0, rect.getHeight() + 30.0);
                g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(lineLength, (int)lengthPoint.x, (int)lengthPoint.y);
                this.boundsArray.add(bounds2);
            }
        }
        if (((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
            g.setColor(this.getTextColor());
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.getROI().getID() + "", g);
            bounds = new Rectangle2D.Double(this.path.getCenter().getX() - bounds.getWidth() / 2.0, this.path.getCenter().getY() + bounds.getHeight() / 2.0, bounds.getWidth(), bounds.getHeight());
            g.drawString(this.getROI().getID() + "", (int)bounds.getX(), (int)bounds.getY());
        }
    }

    public void transform(AffineTransform tx) {
        if (!this.readOnly) {
            super.transform(tx);
            this.setObjectDirty(true);
        }
    }

    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (!this.readOnly) {
            super.setBounds(anchor, lead);
            this.setObjectDirty(true);
        }
    }

    public List<Double> getLengthArray() {
        return this.lengthArray;
    }

    public List<Double> getAngleArray() {
        return this.angleArray;
    }

    public String addDegrees(String str) {
        return str + "\u00b0";
    }

    public String addUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m";
        }
        return str + "px";
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.boundsArray != null) {
            for (int i = 0; i < this.boundsArray.size(); ++i) {
                double diff;
                Rectangle2D bounds = this.boundsArray.get(i);
                if (newBounds.getX() > bounds.getX()) {
                    diff = newBounds.x - bounds.getX();
                    newBounds.x = bounds.getX();
                    newBounds.width += diff;
                }
                if (newBounds.getY() > bounds.getY()) {
                    diff = newBounds.y - bounds.getY();
                    newBounds.y = bounds.getY();
                    newBounds.height += diff;
                }
                if (bounds.getX() + bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                    diff = bounds.getX() + bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                    newBounds.width += diff;
                }
                if (!(bounds.getY() + bounds.getHeight() > newBounds.getY() + newBounds.getHeight())) continue;
                diff = bounds.getY() + bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public Point2D.Double getLengthPosition(int i, int j) {
        Point2D.Double p0 = this.getPoint(i);
        Point2D.Double p1 = this.getPoint(j);
        double lx = (p0.x - p1.x) / 2.0;
        double ly = (p0.y - p1.y) / 2.0;
        double x = p0.x - lx;
        double y = p0.y - ly;
        return new Point2D.Double(x, y);
    }

    public double getLength(int i, int j) {
        Point2D.Double pt1 = this.getPt(i);
        Point2D.Double pt2 = this.getPt(j);
        return pt1.distance(pt2);
    }

    public double getAngle(int i, int j, int k) {
        Point2D.Double p0 = this.getPt(i);
        Point2D.Double p1 = this.getPt(j);
        Point2D.Double p2 = this.getPt(k);
        Point2D.Double v0 = new Point2D.Double(((Point2D)p0).getX() - ((Point2D)p1).getX(), ((Point2D)p0).getY() - ((Point2D)p1).getY());
        Point2D.Double v1 = new Point2D.Double(((Point2D)p2).getX() - ((Point2D)p1).getX(), ((Point2D)p2).getY() - ((Point2D)p1).getY());
        return Math.toDegrees(Math.acos(this.dotProd(v0, v1)));
    }

    public double getAngle(int i, int j) {
        Point2D.Double p0 = this.getPt(i);
        Point2D.Double p1 = this.getPt(j);
        Point2D.Double v0 = new Point2D.Double(((Point2D)p0).getX() - ((Point2D)p1).getX(), ((Point2D)p0).getY() - ((Point2D)p1).getY());
        Point2D.Double v1 = new Point2D.Double(1.0, 0.0);
        return Math.toDegrees(Math.acos(this.dotProd(v0, v1)));
    }

    public double dotProd(Point2D p0, Point2D p1) {
        double adotb = p0.getX() * p1.getX() + p0.getY() * p1.getY();
        double normab = Math.sqrt(p0.getX() * p0.getX() + p0.getY() * p0.getY()) * Math.sqrt(p1.getX() * p1.getX() + p1.getY() * p1.getY());
        return adotb / normab;
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        this.pointArrayX.clear();
        this.pointArrayY.clear();
        this.lengthArray.clear();
        this.angleArray.clear();
        for (int i = 0; i < this.getPointCount(); ++i) {
            Point2D.Double pt = this.getPt(i);
            this.pointArrayX.add(pt.getX());
            this.pointArrayY.add(pt.getY());
        }
        if (this.getPointCount() == 2) {
            double angle = this.getAngle(0, 1);
            if (angle > 90.0) {
                angle = Math.abs(angle - 180.0);
            }
            this.angleArray.add(angle);
            AnnotationKeys.ANGLE.set(this.shape, this.angleArray);
            this.lengthArray.add(this.getLength(0, 1));
            AnnotationKeys.LENGTH.set(this.shape, this.lengthArray);
        } else {
            int x;
            for (x = 1; x < this.getPointCount() - 1; ++x) {
                this.angleArray.add(this.getAngle(x - 1, x, x + 1));
            }
            for (x = 1; x < this.getPointCount(); ++x) {
                this.lengthArray.add(this.getLength(x - 1, x));
            }
            AnnotationKeys.ANGLE.set(this.shape, this.angleArray);
            AnnotationKeys.LENGTH.set(this.shape, this.lengthArray);
        }
        AnnotationKeys.STARTPOINTX.set(this.shape, (Double)this.getPt(0).getX());
        AnnotationKeys.STARTPOINTY.set(this.shape, (Double)this.getPt(0).getY());
        AnnotationKeys.ENDPOINTX.set(this.shape, (Double)this.getPt(this.getPointCount() - 1).getX());
        AnnotationKeys.ENDPOINTY.set(this.shape, (Double)this.getPt(this.getPointCount() - 1).getY());
        AnnotationKeys.POINTARRAYX.set(this.shape, this.pointArrayX);
        AnnotationKeys.POINTARRAYY.set(this.shape, this.pointArrayY);
    }

    @Override
    public String getType() {
        return "Line";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public List<Point> getPoints() {
        ArrayList<Point> vector = new ArrayList<Point>();
        for (int i = 0; i < this.getNodeCount() - 1; ++i) {
            Line2D.Double line = new Line2D.Double(this.getPoint(i), this.getPoint(i + 1));
            this.iterateLine(line, vector);
        }
        return vector;
    }

    private void iterateLine(Line2D line, List<Point> vector) {
        Point2D start = line.getP1();
        Point2D end = line.getP2();
        Point2D.Double m = new Point2D.Double(end.getX() - start.getX(), end.getY() - start.getY());
        double lengthM = Math.sqrt(((Point2D)m).getX() * ((Point2D)m).getX() + ((Point2D)m).getY() * ((Point2D)m).getY());
        Point2D.Double mNorm = new Point2D.Double(((Point2D)m).getX() / lengthM, ((Point2D)m).getY() / lengthM);
        LinkedHashMap<Point2D.Double, Boolean> map = new LinkedHashMap<Point2D.Double, Boolean>();
        for (double i = 0.0; i < lengthM; i += 0.1) {
            Point2D pt = new Point2D.Double(start.getX() + i * ((Point2D)mNorm).getX(), start.getY() + i * ((Point2D)mNorm).getY());
            Point2D.Double quantisedPoint = new Point2D.Double(Math.floor(pt.getX()), Math.floor(pt.getY()));
            if (map.containsKey(quantisedPoint)) continue;
            map.put(quantisedPoint, true);
        }
        for (Point2D pt : map.keySet()) {
            vector.add(new Point((int)pt.getX(), (int)pt.getY()));
        }
    }

    public void removeAllNodes() {
        super.removeAllNodes();
        this.setObjectDirty(true);
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEditable(!readOnly);
    }

    @Override
    public boolean isClientObject() {
        return this.clientObject;
    }

    @Override
    public void setClientObject(boolean clientSide) {
        this.clientObject = clientSide;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setObjectDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public MeasureLineFigure clone() {
        MeasureLineFigure that = (MeasureLineFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        return that;
    }

    public void setClosed(boolean newValue) {
        super.setClosed(newValue);
        this.setObjectDirty(true);
    }

    public void setBezierPath(BezierPath newValue) {
        super.setBezierPath(newValue);
        this.setObjectDirty(true);
    }

    public void setEndPoint(Point2D.Double p) {
        super.setEndPoint(p);
        this.setObjectDirty(true);
    }

    public void setNode(int index, BezierPath.Node p) {
        super.setNode(index, p);
        this.setObjectDirty(true);
    }

    public void setPoint(int index, int coord, Point2D.Double p) {
        super.setPoint(index, coord, p);
        this.setObjectDirty(true);
    }

    public void setStartPoint(Point2D.Double p) {
        super.setStartPoint(p);
        this.setObjectDirty(true);
    }

    public int splitSegment(Point2D.Double split) {
        this.setObjectDirty(true);
        return super.splitSegment(split);
    }

    public int splitSegment(Point2D.Double split, float tolerance) {
        this.setObjectDirty(true);
        return super.splitSegment(split, tolerance);
    }

    public int joinSegments(Point2D.Double join, float tolerance) {
        this.setObjectDirty(true);
        return super.joinSegments(join, tolerance);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setObjectDirty(true);
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }
}

