/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;

public class DetailedNotificationDialog
extends NotificationDialog {
    private static final String SHOW_DETAILS = "Details >>";
    private static final String HIDE_DETAILS = "<< Details";
    private static final String SEND = "Send";
    private static final String SEND_DESCRIPTION = "Send the error to the development team.";
    private static final Dimension SCROLL_PANE_SIZE = new Dimension(300, 150);
    private static final Dimension SMALL_V_SPACER_SIZE = new Dimension(1, 6);
    private JButton sendButton;
    private JButton detailsButton;
    private JPanel explanationPanel;
    private boolean isExplanationShowing;

    private void createComponents() {
        this.detailsButton = new JButton(SHOW_DETAILS);
        this.sendButton = new JButton(SEND);
        this.sendButton.setToolTipText(SEND_DESCRIPTION);
        this.explanationPanel = new JPanel();
    }

    private void buildExplanationPanel(String expl) {
        MultilineLabel explanation = new MultilineLabel(expl);
        explanation.setLineWrap(false);
        this.buildExplanationPanel(explanation);
    }

    private void buildExplanationPanel(Component component) {
        JScrollPane scrollPane = new JScrollPane(component);
        scrollPane.setPreferredSize(SCROLL_PANE_SIZE);
        this.explanationPanel.setLayout(new BoxLayout(this.explanationPanel, 1));
        this.explanationPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.explanationPanel.add(Box.createRigidArea(V_SPACER_SIZE));
        this.explanationPanel.add(new JSeparator());
        this.explanationPanel.add(Box.createRigidArea(SMALL_V_SPACER_SIZE));
        this.explanationPanel.add(scrollPane);
    }

    private void attachListeners() {
        this.detailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DetailedNotificationDialog.this.handleClick();
            }
        });
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DetailedNotificationDialog.this.handleSend();
            }
        });
    }

    private void handleClick() {
        if (this.isExplanationShowing) {
            this.detailsButton.setText(SHOW_DETAILS);
            this.contentPanel.remove((Component)this.explanationPanel);
        } else {
            this.detailsButton.setText(HIDE_DETAILS);
            this.contentPanel.add((Component)this.explanationPanel);
        }
        this.isExplanationShowing = !this.isExplanationShowing;
        this.pack();
    }

    private void handleSend() {
    }

    private void buildGUI(String explanation) {
        this.controlsPanel.add(this.detailsButton);
        this.controlsPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        this.buildExplanationPanel(explanation);
    }

    private void buildGUI(Component component) {
        this.controlsPanel.add(this.detailsButton);
        this.controlsPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        this.buildExplanationPanel(component);
    }

    public DetailedNotificationDialog(JFrame owner, String title, String message, Icon messageIcon, String explanation) {
        super(owner, title, message, messageIcon);
        this.createComponents();
        this.attachListeners();
        this.buildGUI(explanation);
        this.isExplanationShowing = false;
    }

    public DetailedNotificationDialog(JFrame owner, String title, String message, Icon messageIcon, Component component) {
        super(owner, title, message, messageIcon);
        this.createComponents();
        this.attachListeners();
        this.buildGUI(component);
        this.isExplanationShowing = false;
    }

    static /* synthetic */ void access$000(DetailedNotificationDialog x0) {
        x0.handleClick();
    }

    static /* synthetic */ void access$100(DetailedNotificationDialog x0) {
        x0.handleSend();
    }
}

