/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.border.LineBorder;

public class PartialLineBorder
extends LineBorder {
    public static final int TOP_REMOVE = 0;
    public static final int BOTTOM_REMOVE = 1;
    public static final int TOP_KEEP = 2;
    public static final int BOTTOM_KEEP = 3;
    private int removeIndex = 1;

    public PartialLineBorder(Color color) {
        super(color);
    }

    public PartialLineBorder(Color color, int thickness) {
        super(color, thickness);
    }

    public void setRemoveIndex(int index) {
        this.removeIndex = index;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(c.getBackground());
        switch (this.removeIndex) {
            case 2: {
                for (int i = 0; i < this.thickness; ++i) {
                    if (!this.roundedCorners) {
                        g.drawRect(x + i, y + i, width - 2 * i - 1, height - 2 * i - 1);
                        continue;
                    }
                    g.drawRoundRect(x + i, y + i, width - 2 * i - 1, height - 2 * i - 1, this.thickness, this.thickness);
                }
                g.setColor(this.getLineColor());
                g.drawLine(x, y, x + width - 1, y);
                break;
            }
            case 3: {
                for (int i = 0; i < this.thickness; ++i) {
                    if (!this.roundedCorners) {
                        g.drawRect(x + i, y + i, width - 2 * i - 1, height - 2 * i - 1);
                        continue;
                    }
                    g.drawRoundRect(x + i, y + i, width - 2 * i - 1, height - 2 * i - 1, this.thickness, this.thickness);
                }
                g.setColor(this.getLineColor());
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
                break;
            }
            case 0: {
                super.paintBorder(c, g, x, y, width, height);
                for (int i = 0; i < this.thickness; ++i) {
                    g.drawLine(x + i, y + i, x + width - i - 1, y + i);
                }
                break;
            }
            default: {
                super.paintBorder(c, g, x, y, width, height);
                for (int i = 0; i < this.thickness; ++i) {
                    g.drawLine(x + width - i - 1, y + height - i - 1, x + i + 1, y + height - i - 1);
                }
            }
        }
    }
}

