/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.clsf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeCheckNode
extends DefaultMutableTreeNode {
    private Icon nodeIcon;
    private boolean selected;
    private Set childrenDisplay;
    private TreeCheckNode parentDisplay;
    private String name;
    private boolean leafNode;

    public TreeCheckNode(Object hierarchyObject, Icon nodeIcon) {
        this(hierarchyObject, nodeIcon, null, false);
    }

    public TreeCheckNode(Object hierarchyObject, Icon nodeIcon, String name, boolean leafNode) {
        if (hierarchyObject == null) {
            throw new IllegalArgumentException("No hierachyObject.");
        }
        this.setUserObject(hierarchyObject);
        this.childrenDisplay = new HashSet();
        this.nodeIcon = nodeIcon;
        this.name = name;
        this.leafNode = leafNode;
    }

    public boolean isLeafNode() {
        return this.leafNode;
    }

    public TreeCheckNode getParentDisplay() {
        return this.parentDisplay;
    }

    public Set getChildrenDisplay() {
        return Collections.unmodifiableSet(this.childrenDisplay);
    }

    public boolean hasChildrenDisplay() {
        return this.childrenDisplay.size() != 0;
    }

    public void addChildDisplay(TreeCheckNode child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenDisplay.contains(child)) {
            return;
        }
        if (child.parentDisplay != null) {
            child.parentDisplay.removeChildDisplay(child);
        }
        child.parentDisplay = this;
        this.childrenDisplay.add(child);
    }

    public void removeChildDisplay(TreeCheckNode child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenDisplay.contains(child)) {
            child.parentDisplay.childrenDisplay.remove(child);
            child.parentDisplay = null;
        }
    }

    public void removeAllChildrenDisplay() {
        Iterator i = this.childrenDisplay.iterator();
        HashSet toRemove = new HashSet(this.childrenDisplay.size());
        while (i.hasNext()) {
            toRemove.add(i.next());
        }
        i = toRemove.iterator();
        while (i.hasNext()) {
            this.removeChildDisplay((TreeCheckNode)i.next());
        }
    }

    public Icon getNodeIcon() {
        return this.nodeIcon;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.getUserObject().toString();
    }
}

