/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.creationtools;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.util.ui.drawingtools.creationtools.DrawingCreationTool;

public class DrawingPointCreationTool
extends CreationTool
implements DrawingCreationTool {
    private boolean resetToSelect;

    private void setBasicBounds(int x, int y) {
        double size = 11.0;
        Point2D.Double p = this.constrainPoint(this.viewToDrawing(new Point((int)((double)x - size), (int)((double)y - size))));
        Point2D.Double p2 = this.constrainPoint(this.viewToDrawing(new Point((int)((double)x + size), (int)((double)y + size))));
        this.createdFigure.willChange();
        this.createdFigure.setBounds(p, p2);
        this.createdFigure.changed();
    }

    public DrawingPointCreationTool(Figure prototype) {
        super(prototype);
    }

    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.setBasicBounds(evt.getX(), evt.getY());
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.createdFigure == null) {
            return;
        }
        this.setBasicBounds(evt.getX(), evt.getY());
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.createdFigure == null) {
            return;
        }
        Rectangle2D.Double bounds = this.createdFigure.getBounds();
        if (bounds.width == 0.0 && bounds.height == 0.0) {
            this.getDrawing().remove(this.createdFigure);
        } else {
            Point2D.Double p = this.createdFigure.getStartPoint();
            Point2D.Double p1 = this.createdFigure.getEndPoint();
            double width = Math.abs(((Point2D)p).getX() - ((Point2D)p1).getX());
            if (width < 22.0) {
                double size = 11.0;
                Point2D.Double centre = new Point2D.Double(this.createdFigure.getBounds().getCenterX(), this.createdFigure.getBounds().getCenterY());
                Point2D.Double newP1 = new Point2D.Double(((Point2D)centre).getX() - size, ((Point2D)centre).getY() - size);
                Point2D.Double newP2 = new Point2D.Double(((Point2D)centre).getX() + size, ((Point2D)centre).getY() + size);
                this.createdFigure.willChange();
                this.createdFigure.setBounds(newP1, newP2);
                this.createdFigure.changed();
            }
            this.getView().addToSelection(this.createdFigure);
        }
        if (this.createdFigure instanceof CompositeFigure) {
            ((CompositeFigure)this.createdFigure).layout();
        }
        Figure addedFigure = this.createdFigure;
        Drawing addedDrawing = this.getDrawing();
        this.getDrawing().fireUndoableEditHappened((UndoableEdit)new AbstractUndoableEdit(){

            public String getPresentationName() {
                return super.getPresentationName();
            }

            public void undo() throws CannotUndoException {
                super.undo();
                addedDrawing.remove(addedFigure);
            }

            public void redo() throws CannotRedoException {
                super.redo();
                addedDrawing.add(addedFigure);
            }
        });
        this.creationFinished(this.createdFigure);
        this.createdFigure = null;
    }

    protected void creationFinished(Figure createdFigure) {
        if (this.resetToSelect) {
            this.fireToolDone();
        }
    }

    public boolean isResetToSelect() {
        return this.resetToSelect;
    }

    public void setResetToSelect(boolean create) {
        this.resetToSelect = create;
    }
}

