/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.openmicroscopy.shoola.util.ui.graphutils.ChartObject;
import org.openmicroscopy.shoola.util.ui.graphutils.CustomBarRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarPlot
extends ChartObject {
    private static final String DEFAULTSERIES = "default";
    private CategoryAxis categoryAxis;
    private DefaultCategoryDataset dataset;
    protected List<Double> data;

    private void initialize() {
        this.data = new ArrayList<Double>();
        this.dataset = new DefaultCategoryDataset();
    }

    public BarPlot() {
        super("");
        this.initialize();
    }

    public BarPlot(String title, List<String> newLegends, List<Double> newData, List<Color> newColours) {
        super(title);
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size() || newLegends.size() == 0) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.initialize();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addValue(newLegends.get(i), newData.get(i), newColours.get(i));
        }
        this.setDefaultAxis();
        this.categoryAxis = new CategoryAxis("X-Axis");
    }

    public int addValue(String legend, double newData, Color color) {
        if (legend == null || color == null) {
            throw new IllegalArgumentException("Illegal argument in addSeries.");
        }
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.dataset.addValue(newData, (Comparable)((Object)DEFAULTSERIES), (Comparable)((Object)legend));
        return this.dataset.getColumnCount();
    }

    @Override
    void createChart() {
        CategoryPlot plot = new CategoryPlot((CategoryDataset)this.dataset, this.categoryAxis, (ValueAxis)this.rangeAxis, (CategoryItemRenderer)new CustomBarRenderer(this.colours));
        this.chart = new JFreeChart(this.title, (Plot)plot);
    }
}

