/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.openmicroscopy.shoola.util.ui.omeeditpane.Position;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiView;

public class ChemicalSymbolsEditer {
    Document doc;
    private Map<String, String> symbols;
    private SimpleAttributeSet plainText;
    private int characterIndex;
    public static final String PUNCTUATION = "[!:,.;)+&@#/%?~_| ]";

    public ChemicalSymbolsEditer(SimpleAttributeSet plainText) {
        this.plainText = plainText;
        this.symbols = new HashMap<String, String>();
    }

    public void addSymbol(String regex, String replacement) {
        this.symbols.put(regex + PUNCTUATION, replacement);
    }

    public void parseRegex(Document document, int index) {
        this.doc = document;
        this.characterIndex = index;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Iterator i = ChemicalSymbolsEditer.this.symbols.keySet().iterator();
                    String text = ChemicalSymbolsEditer.this.doc.getText(0, ChemicalSymbolsEditer.this.doc.getLength());
                    ArrayList<Position> positionList = new ArrayList<Position>();
                    while (i.hasNext()) {
                        String regex = (String)i.next();
                        String replacement = (String)ChemicalSymbolsEditer.this.symbols.get(regex);
                        positionList.clear();
                        WikiView.findExpressions(text, regex, positionList);
                        for (Position p : positionList) {
                            if (ChemicalSymbolsEditer.this.characterIndex > -1 && !p.contains(ChemicalSymbolsEditer.this.characterIndex, ChemicalSymbolsEditer.this.characterIndex)) continue;
                            int start = p.getStart();
                            int end = p.getEnd() - 1;
                            ChemicalSymbolsEditer.this.doc.remove(start, end - start);
                            ChemicalSymbolsEditer.this.doc.insertString(start, replacement, ChemicalSymbolsEditer.this.plainText);
                        }
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    static /* synthetic */ Map access$000(ChemicalSymbolsEditer x0) {
        return x0.symbols;
    }

    static /* synthetic */ int access$100(ChemicalSymbolsEditer x0) {
        return x0.characterIndex;
    }

    static /* synthetic */ SimpleAttributeSet access$200(ChemicalSymbolsEditer x0) {
        return x0.plainText;
    }
}

