/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Position
implements Comparable<Position>,
Comparator {
    private int start;
    private int end;

    Position(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean contains(int p0, int p1) {
        return this.start <= p0 && this.end >= p1;
    }

    boolean contains(Position p) {
        return this.contains(p.start, p.end);
    }

    boolean within(Position p) {
        return this.within(p.start, p.end);
    }

    boolean within(int p0, int p1) {
        return p0 <= this.start && p1 >= this.end;
    }

    boolean overlaps(Position p) {
        if (p.within(this)) {
            return true;
        }
        if (this.within(p)) {
            return true;
        }
        if (p.start > this.start && p.start < this.end) {
            return true;
        }
        return p.end > this.start && p.end < this.end;
    }

    int length() {
        return this.end - this.start + 1;
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof Position) || !(o2 instanceof Position)) {
            return -1;
        }
        Position a = (Position)o1;
        Position b = (Position)o2;
        if (a.start < b.start) {
            return -1;
        }
        if (a.start > b.start) {
            return 1;
        }
        if (a.end < b.end) {
            return -1;
        }
        if (a.end > b.end) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int value = this.start;
        return value;
    }

    public Position clone() {
        return new Position(this.start, this.end);
    }

    public String toString() {
        return "[" + this.start + "," + this.end + "]";
    }

    @Override
    public int compareTo(Position o) {
        return this.compare(this, o);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Position)) {
            return false;
        }
        Position comp = (Position)obj;
        return comp.start == this.start && comp.end == this.end;
    }
}

