/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.List;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchContext {
    public static final int CURRENT_USER = 0;
    public static final int OTHERS = 1;
    public static final int IMAGES = 0;
    public static final int DATASETS = 1;
    public static final int PROJECTS = 2;
    public static final int TEXT_ANNOTATION = 3;
    public static final int TAGS = 4;
    public static final int TAG_SETS = 5;
    public static final int NAME = 6;
    public static final int FILE_ANNOTATION = 7;
    public static final int URL_ANNOTATION = 8;
    public static final int DESCRIPTION = 9;
    public static final int CUSTOMIZED = 10;
    static final int ANY_DATE = 0;
    static final int LAST_TWO_WEEKS = 1;
    static final int LAST_MONTH = 2;
    static final int LAST_TWO_MONTHS = 3;
    static final int ONE_YEAR = 4;
    static final int RANGE = 5;
    static final int MAX = 5;
    static final int LEVEL_ONE = 0;
    static final int LEVEL_TWO = 1;
    static final int LEVEL_THREE = 2;
    static final int LEVEL_FOUR = 3;
    static final int MAX_RESULTS = 3;
    static final int LEVEL_ONE_VALUE = 50;
    static final int LEVEL_TWO_VALUE = 100;
    static final int LEVEL_THREE_VALUE = 250;
    static final int LEVEL_FOUR_VALUE = 500;
    static final int ALL_FORMATS = 0;
    static final int HTML = 1;
    static final int PDF = 2;
    static final int EXCEL = 3;
    static final int POWER_POINT = 4;
    static final int WORD = 5;
    static final int XML = 6;
    static final int TEXT = 7;
    static final int MAX_FORMAT = 8;
    static final int CREATION_TIME = 100;
    static final int UPDATED_TIME = 101;
    private String[] some;
    private String[] must;
    private String[] none;
    private List<Integer> context;
    private List<Integer> type;
    private List<Long> selectedOwners;
    private List<String> excludedOwners;
    private List<String> selectedAnnotators;
    private List<String> excludedAnnotators;
    private Timestamp startTime;
    private Timestamp endTime;
    private List<Integer> ownerSearchContext;
    private List<Integer> annotatorSearchContext;
    private boolean caseSensitive;
    private int numberOfResults;
    private int timeType;
    private int dateIndex;
    private int attachmentType;

    SearchContext(String[] some, String[] must, String[] none, List<Integer> context) {
        this.some = some;
        this.must = must;
        this.none = none;
        this.context = context;
        this.timeType = -1;
        this.attachmentType = 0;
    }

    void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    void setOwnerSearchContext(List<Integer> context) {
        this.ownerSearchContext = context;
    }

    void setAnnotatorSearchContext(List<Integer> context) {
        this.annotatorSearchContext = context;
    }

    void setTime(Timestamp startTime, Timestamp endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        if (startTime != null && endTime != null) {
            this.dateIndex = 5;
        }
    }

    void setOwners(List<Long> users) {
        this.selectedOwners = users;
    }

    void setAnnotators(List<String> users) {
        this.selectedAnnotators = users;
    }

    void setTime(int index) {
        GregorianCalendar gc = new GregorianCalendar();
        this.endTime = UIUtilities.getDefaultTimestamp();
        switch (index) {
            case 0: {
                this.setTime(null, null);
                break;
            }
            case 1: {
                gc = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), 23, 59, 0);
                this.startTime = new Timestamp(gc.getTime().getTime() - 1209600000L);
                break;
            }
            case 2: {
                gc = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), 23, 59, 0);
                this.startTime = new Timestamp(gc.getTime().getTime() - 2592000000L);
                break;
            }
            case 3: {
                gc = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), 23, 59, 0);
                this.startTime = new Timestamp(gc.getTime().getTime() - 5184000000L);
                break;
            }
            case 4: {
                gc = new GregorianCalendar(gc.get(1), 0, 1, 0, 0, 0);
                this.startTime = new Timestamp(gc.getTime().getTime());
            }
        }
        this.dateIndex = index;
    }

    void setExcludedOwners(List<String> users) {
        this.excludedOwners = users;
    }

    void setExcludedAnnotators(List<String> users) {
        this.excludedAnnotators = users;
    }

    void setTimeType(int index) {
        switch (index) {
            case 100: 
            case 101: {
                this.timeType = index;
            }
        }
        this.timeType = -1;
    }

    void setAttachmentType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.attachmentType = type;
            }
        }
        this.attachmentType = 0;
    }

    int getAttachmentType() {
        return this.attachmentType;
    }

    int getDateIndex() {
        return this.dateIndex;
    }

    public int getTimeType() {
        return this.timeType;
    }

    public String[] getSome() {
        return this.some;
    }

    public String[] getMust() {
        return this.must;
    }

    public String[] getNone() {
        return this.none;
    }

    public List<Integer> getContext() {
        return this.context;
    }

    public List<Long> getSelectedOwners() {
        return this.selectedOwners;
    }

    public List<String> getSelectedAnnotators() {
        return this.selectedAnnotators;
    }

    public List<String> getExcludedOwners() {
        return this.excludedOwners;
    }

    public List<String> getExcludedAnnotators() {
        return this.excludedAnnotators;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public List<Integer> getOwnerSearchContext() {
        return this.ownerSearchContext;
    }

    public List<Integer> getAnnotatorSearchContext() {
        return this.annotatorSearchContext;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setType(List<Integer> type) {
        this.type = type;
    }

    public List<Integer> getType() {
        return this.type;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public void setNumberOfResults(int results) {
        this.numberOfResults = results;
    }
}

