/*
 * Decompiled with CFR 0.152.
 */
package ome.model.meta;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IGlobal;
import ome.model.IObject;
import ome.model.enums.EventType;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.EventLog;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.meta.Session;
import ome.util.CBlock;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="event", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_event", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_event"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Event
implements Serializable,
IObject,
IGlobal {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String ID = "ome.model.meta.Event_id";
    protected Long id;
    protected String status = null;
    protected Timestamp time = null;
    protected Experimenter experimenter = null;
    protected ExperimenterGroup experimenterGroup = null;
    protected EventType type = null;
    protected Event containingEvent = null;
    protected Set<EventLog> logs = new HashSet<EventLog>();
    protected Session session = null;
    protected ome.model.internal.Details details = new Details();
    public static final String STATUS = "ome.model.meta.Event_status";
    public static final String TIME = "ome.model.meta.Event_time";
    public static final String EXPERIMENTER = "ome.model.meta.Event_experimenter";
    public static final String EXPERIMENTERGROUP = "ome.model.meta.Event_experimenterGroup";
    public static final String TYPE = "ome.model.meta.Event_type";
    public static final String CONTAININGEVENT = "ome.model.meta.Event_containingEvent";
    public static final String LOGS = "ome.model.meta.Event_logs";
    public static final String SESSION = "ome.model.meta.Event_session";
    public static final String DETAILS = "ome.model.meta.Event_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Event() {
        this(null, true);
    }

    protected Event(Long id) {
        this(id, true);
    }

    public Event(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Event(Timestamp _time, Experimenter _experimenter, Session _session) {
        this(null, true);
        this.setTime(_time);
        this.setExperimenter(_experimenter);
        this.setSession(_session);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_event")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="status", updatable=true)
    public String getStatus() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.status;
    }

    public void setStatus(String status) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.status = status;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="time", updatable=true)
    public Timestamp getTime() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.time;
    }

    public void setTime(Timestamp time) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.time = time;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Experimenter.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="experimenter", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKevent_experimenter_experimenter")
    public Experimenter getExperimenter() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.experimenter;
    }

    public void setExperimenter(Experimenter experimenter) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.experimenter = experimenter;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ExperimenterGroup.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="experimenterGroup", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKevent_experimenterGroup_experimentergroup")
    public ExperimenterGroup getExperimenterGroup() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.experimenterGroup;
    }

    public void setExperimenterGroup(ExperimenterGroup experimenterGroup) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.experimenterGroup = experimenterGroup;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=EventType.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="type", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKevent_type_eventtype")
    public EventType getType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.type;
    }

    public void setType(EventType type) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.type = type;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Event.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="containingEvent", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKevent_containingEvent_event")
    public Event getContainingEvent() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.containingEvent;
    }

    public void setContainingEvent(Event containingEvent) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.containingEvent = containingEvent;
    }

    @OneToMany(mappedBy="event", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    protected Set<EventLog> getLogs() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.logs;
    }

    protected void setLogs(Set<EventLog> logs) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.logs = logs;
    }

    public int sizeOfLogs() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.logs == null ? -1 : this.logs.size();
    }

    public Iterator<EventLog> iterateLogs() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLogs() == null) {
            return new EmptyIterator<EventLog>();
        }
        return this.getLogs().iterator();
    }

    public Collection<EventLog> unmodifiableLogs() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLogs() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getLogs());
    }

    public <E> List<E> collectLogs(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<EventLog> it = this.iterateLogs();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addEventLog(EventLog target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLogs() == null) {
            this.throwNullCollectionException("Logs");
        }
        this.getLogs().add(target);
        if (target != null) {
            target.setEvent(this);
        }
    }

    public void addEventLogSet(Collection<EventLog> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLogs() == null) {
            this.throwNullCollectionException("Logs");
        }
        this.getLogs().addAll(targets);
        for (EventLog target : targets) {
            if (target == null) continue;
            target.setEvent(this);
        }
    }

    public void removeEventLog(EventLog target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLogs() == null) {
            this.throwNullCollectionException("Logs");
        }
        this.getLogs().remove(target);
        target.setEvent(null);
    }

    public void removeEventLogSet(Collection<EventLog> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLogs() == null) {
            this.throwNullCollectionException("Logs");
        }
        this.getLogs().removeAll(targets);
        for (EventLog target : targets) {
            target.setEvent(null);
        }
    }

    public void clearLogs() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLogs() == null) {
            this.throwNullCollectionException("Logs");
        }
        this.getLogs().clear();
        Iterator<EventLog> it = this.iterateLogs();
        while (it.hasNext()) {
            EventLog target = it.next();
            target.setEvent(null);
        }
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Session.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="\"session\"", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKevent_session_session")
    public Session getSession() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.session;
    }

    public void setSession(Session session) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.session = session;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Event newInstance() {
        return new Event();
    }

    public Event proxy() {
        return new Event(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.status = (String)__filter.filter(STATUS, this.status);
            this.time = (Timestamp)__filter.filter(TIME, this.time);
            this.experimenter = (Experimenter)__filter.filter(EXPERIMENTER, this.experimenter);
            this.experimenterGroup = (ExperimenterGroup)__filter.filter(EXPERIMENTERGROUP, this.experimenterGroup);
            this.type = (EventType)__filter.filter(TYPE, this.type);
            this.containingEvent = (Event)__filter.filter(CONTAININGEVENT, this.containingEvent);
            this.logs = (Set)__filter.filter(LOGS, this.logs);
            this.session = (Session)__filter.filter(SESSION, this.session);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(STATUS)) {
            return this.getStatus();
        }
        if (field.equals(TIME)) {
            return this.getTime();
        }
        if (field.equals(EXPERIMENTER)) {
            return this.getExperimenter();
        }
        if (field.equals(EXPERIMENTERGROUP)) {
            return this.getExperimenterGroup();
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(CONTAININGEVENT)) {
            return this.getContainingEvent();
        }
        if (field.equals(LOGS)) {
            return this.getLogs();
        }
        if (field.equals(SESSION)) {
            return this.getSession();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(STATUS)) {
            this.setStatus((String)value);
        } else if (field.equals(TIME)) {
            this.setTime((Timestamp)value);
        } else if (field.equals(EXPERIMENTER)) {
            this.setExperimenter((Experimenter)value);
        } else if (field.equals(EXPERIMENTERGROUP)) {
            this.setExperimenterGroup((ExperimenterGroup)value);
        } else if (field.equals(TYPE)) {
            this.setType((EventType)value);
        } else if (field.equals(CONTAININGEVENT)) {
            this.setContainingEvent((Event)value);
        } else if (field.equals(LOGS)) {
            this.setLogs((Set)value);
        } else if (field.equals(SESSION)) {
            this.setSession((Session)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.status = null;
        this.time = null;
        this.experimenter = null;
        this.experimenterGroup = null;
        this.type = null;
        this.containingEvent = null;
        this.logs = null;
        this.session = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(STATUS);
        raw.add(TIME);
        raw.add(EXPERIMENTER);
        raw.add(EXPERIMENTERGROUP);
        raw.add(TYPE);
        raw.add(CONTAININGEVENT);
        raw.add(LOGS);
        raw.add(SESSION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKevent_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }
    }
}

