/*
 * Decompiled with CFR 0.152.
 */
package omero;

import Glacier2.CannotCreateSessionException;
import Glacier2.PermissionDeniedException;
import Glacier2.RouterPrxHelper;
import Glacier2.SessionPrx;
import Ice.Communicator;
import Ice.ConnectTimeoutException;
import Ice.ConnectionLostException;
import Ice.ConnectionRefusedException;
import Ice.Current;
import Ice.DNSException;
import Ice.Identity;
import Ice.ImplicitContext;
import Ice.InitializationData;
import Ice.Logger;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.RouterPrx;
import Ice.SocketException;
import Ice.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import ome.util.Utils;
import omero.ClientError;
import omero.RType;
import omero.RemovedSessionException;
import omero.ServerError;
import omero.WrappedCreateSessionException;
import omero.api.ClientCallbackPrxHelper;
import omero.api.IAdminPrx;
import omero.api.ISessionPrx;
import omero.api.IUpdatePrx;
import omero.api.RawFileStorePrx;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceFactoryPrxHelper;
import omero.api.ServiceInterfacePrx;
import omero.api.StatefulServiceInterfacePrx;
import omero.api.StatefulServiceInterfacePrxHelper;
import omero.api._ClientCallbackDisp;
import omero.model.DetailsI;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.model.PermissionsI;
import omero.model.SessionI;
import omero.rtypes;
import omero.util.ObjectFactoryRegistrar;
import omero.util.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class client {
    private static final Set<client> CLIENTS = Collections.synchronizedSet(new HashSet());
    private volatile String __agent = "OMERO.java";
    private volatile String __uuid;
    private volatile InitializationData __previous;
    private volatile ObjectAdapter __oa;
    private volatile Communicator __ic;
    private volatile ServiceFactoryPrx __sf;
    private volatile Resources __resources;
    private final boolean insecure;

    private static Properties defaultRouter(String host, int port) {
        Properties p = new Properties();
        p.setProperty("omero.host", host);
        p.setProperty("omero.port", Integer.toString(port));
        return p;
    }

    public client() {
        this(new InitializationData());
    }

    public client(InitializationData id) {
        this.insecure = false;
        this.init(id);
    }

    public client(String host) {
        this(client.defaultRouter(host, 4064));
    }

    public client(String host, int port) {
        this(client.defaultRouter(host, port));
    }

    public client(String[] args) {
        this(args, new InitializationData());
    }

    public client(String[] args, InitializationData id) {
        this.insecure = false;
        if (id.properties == null) {
            id.properties = Util.createProperties(args);
        }
        args = id.properties.parseIceCommandLineOptions(args);
        args = id.properties.parseCommandLineOptions("omero", args);
        this.init(id);
    }

    public client(File ... files) {
        this.insecure = false;
        InitializationData id = new InitializationData();
        id.properties = Util.createProperties(new String[0]);
        for (File file : files) {
            id.properties.load(file.getAbsolutePath());
        }
        this.init(id);
    }

    public client(Map p) {
        this(p, true);
    }

    private client(Map p, boolean secure) {
        this.insecure = !secure;
        InitializationData id = new InitializationData();
        id.properties = Util.createProperties(new String[0]);
        if (p != null) {
            for (Object key : p.keySet()) {
                id.properties.setProperty(key.toString(), p.get(key).toString());
            }
        }
        this.init(id);
    }

    private void init(InitializationData id) {
        String threadpool;
        if (id == null) {
            throw new ClientError("No initialization data provided.");
        }
        if (id.properties == null) {
            id.properties = Util.createProperties(new String[0]);
        }
        id.properties.setProperty("Ice.ImplicitContext", "Shared");
        id.properties.setProperty("Ice.ACM.Client", "0");
        id.properties.setProperty("Ice.RetryIntervals", "-1");
        id.properties.setProperty("Ice.Default.EndpointSelection", "Ordered");
        id.properties.setProperty("Ice.Default.PreferSecure", "1");
        id.properties.setProperty("Ice.Plugin.IceSSL", "IceSSL.PluginFactory");
        id.properties.setProperty("IceSSL.Ciphers", "NONE (DH_anon)");
        id.properties.setProperty("IceSSL.VerifyPeer", "0");
        String messageSize = id.properties.getProperty("Ice.MessageSizeMax");
        if (messageSize == null || messageSize.length() == 0) {
            id.properties.setProperty("Ice.MessageSizeMax", Integer.toString(65536));
        }
        this.parseAndSetInt(id, "Ice.Override.ConnectTimeout", 5000);
        String endpoints = id.properties.getProperty("omero.ClientCallback.Endpoints");
        if (endpoints == null || endpoints.length() == 0) {
            id.properties.setProperty("omero.ClientCallback.Endpoints", "tcp");
        }
        if ((threadpool = id.properties.getProperty("omero.ClientCallback.ThreadPool.Size")) == null || threadpool.length() == 0) {
            id.properties.setProperty("omero.ClientCallback.ThreadPool.Size", Integer.toString(5));
        }
        String port = this.parseAndSetInt(id, "omero.port", 4064);
        String router = id.properties.getProperty("Ice.Default.Router");
        if (router == null || router.length() == 0) {
            router = "OMERO.Glacier2/router:ssl -p @omero.port@ -h @omero.host@";
        }
        String host = id.properties.getPropertyWithDefault("omero.host", "<\"omero.host\" not set>");
        router = router.replaceAll("@omero.port@", port);
        router = router.replaceAll("@omero.host@", host);
        id.properties.setProperty("Ice.Default.Router", router);
        String dump = id.properties.getProperty("omero.dump");
        if (dump != null && dump.length() > 0) {
            Map<String, String> propertyMap = this.getPropertyMap(id.properties);
            for (String key : propertyMap.keySet()) {
                System.out.println(String.format("%s=%s", key, propertyMap.get(key)));
            }
        }
        if (this.__ic != null) {
            throw new ClientError("Client already initialized.");
        }
        this.__ic = Util.initialize(id);
        if (this.__ic == null) {
            throw new ClientError("Improper initialization");
        }
        ObjectFactoryRegistrar.registerObjectFactory(this.__ic, ObjectFactoryRegistrar.INSTANCE);
        for (rtypes.ObjectFactory of : rtypes.ObjectFactories.values()) {
            of.register(this.__ic);
        }
        this.__ic.addObjectFactory(DetailsI.Factory, DetailsI.ice_staticId());
        this.__ic.addObjectFactory(PermissionsI.Factory, PermissionsI.ice_staticId());
        this.__uuid = UUID.randomUUID().toString();
        ImplicitContext ctx = this.__ic.getImplicitContext();
        if (ctx == null) {
            throw new ClientError("Ice.ImplicitContext not set to Shared");
        }
        ctx.put("omero.client.uuid", this.__uuid);
        String group = id.properties.getPropertyWithDefault("omero.group", "");
        if (group.length() > 0) {
            ctx.put("omero.group", group);
        }
        this.__oa = this.__ic.createObjectAdapter("omero.ClientCallback");
        CallbackI cb = new CallbackI(this.__ic, this.__oa);
        this.__oa.add(cb, Util.stringToIdentity("ClientCallback/" + this.__uuid));
        this.__oa.activate();
        CLIENTS.add(this);
    }

    public void setAgent(String agent) {
        this.__agent = agent;
    }

    public boolean isSecure() {
        return !this.insecure;
    }

    public client createClient(boolean secure) throws ServerError, CannotCreateSessionException, PermissionDeniedException {
        Map<String, String> props = this.getPropertyMap();
        if (!secure) {
            String insecure = this.getSession().getConfigService().getConfigValue("omero.router.insecure");
            if (insecure != null && insecure.length() != 0) {
                props.put("Ice.Default.Router", insecure);
            } else {
                this.getCommunicator().getLogger().warning("Could not retrieve \"omero.router.insecure\"");
            }
        }
        client nClient = new client(props, secure);
        nClient.setAgent(this.__agent + ";secure=" + secure);
        nClient.joinSession(this.getSessionId());
        return nClient;
    }

    public void __del__() {
        try {
            this.closeSession();
        }
        catch (Exception e) {
            System.out.println("Ignoring error in client.__del__()");
            e.printStackTrace();
        }
    }

    public Communicator getCommunicator() {
        Communicator ic = this.__ic;
        if (ic == null) {
            throw new ClientError("No Ice.Communicator active; call createSession() or create a new client instance.");
        }
        return ic;
    }

    public ObjectAdapter getAdapter() {
        ObjectAdapter oa = this.__oa;
        if (oa == null) {
            throw new ClientError("No ObjectAdapter; call createSession()");
        }
        return oa;
    }

    public ServiceFactoryPrx getSession() {
        ServiceFactoryPrx sf = this.__sf;
        if (this.__sf == null) {
            throw new ClientError("Call createSession() to login.");
        }
        return sf;
    }

    public String getSessionId() {
        return this.getSession().ice_getIdentity().name;
    }

    @Deprecated
    public ServiceFactoryPrx getServiceFactory() {
        return this.getSession();
    }

    public ImplicitContext getImplicitContext() {
        return this.getCommunicator().getImplicitContext();
    }

    public Ice.Properties getProperties() {
        return this.getCommunicator().getProperties();
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public Map<String, String> getPropertyMap() {
        return this.getPropertyMap(this.getProperties());
    }

    public Map<String, String> getPropertyMap(Ice.Properties properties) {
        HashMap<String, String> rv = new HashMap<String, String>();
        for (String prefix : Arrays.asList("omero", "Ice")) {
            Map<String, String> prefixed = properties.getPropertiesForPrefix(prefix);
            rv.putAll(prefixed);
        }
        return rv;
    }

    public ServiceFactoryPrx joinSession(String session) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        return this.createSession(session, session);
    }

    public ServiceFactoryPrx createSession() throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        return this.createSession(null, null);
    }

    public ServiceFactoryPrx createSession(String username, String password) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        if (this.__sf != null) {
            throw new ClientError("Session already active. Create a new omero.client or closeSession()");
        }
        if (this.__ic == null) {
            if (this.__previous == null) {
                throw new ClientError("No previous data to recreate communicator.");
            }
            this.init(this.__previous);
            this.__previous = null;
        }
        if (username == null && ((username = this.getProperty("omero.user")) == null || "".equals(username))) {
            throw new ClientError("No username specified");
        }
        if (password == null && (password = this.getProperty("omero.pass")) == null) {
            throw new ClientError("No password specified");
        }
        SessionPrx prx = null;
        int retries = 0;
        while (retries < 3) {
            String reason = null;
            if (retries > 0) {
                this.__ic.getLogger().warning(reason + " - createSession retry: " + retries);
            }
            try {
                HashMap<String, String> ctx = new HashMap<String, String>(this.getImplicitContext().getContext());
                ctx.put("omero.agent", this.__agent);
                prx = client.getRouter(this.__ic).createSession(username, password, ctx);
                break;
            }
            catch (WrappedCreateSessionException wrapped) {
                if (!wrapped.concurrency) {
                    throw wrapped;
                }
                reason = wrapped.type + ":" + wrapped.reason;
                ++retries;
            }
            catch (ConnectTimeoutException cte) {
                reason = "Ice.ConnectTimeoutException:" + cte.getMessage();
                ++retries;
            }
        }
        if (null == prx) {
            throw new ClientError("Obtained null object proxy");
        }
        this.__sf = ServiceFactoryPrxHelper.uncheckedCast(prx);
        if (this.__sf == null) {
            throw new ClientError("Obtained object proxy is not a ServiceFactory");
        }
        String keep_alive = this.__ic.getProperties().getPropertyWithDefault("omero.keep_alive", "-1");
        try {
            int i = Integer.valueOf(keep_alive);
            this.enableKeepAlive(i);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            Identity id = this.__ic.stringToIdentity("ClientCallback/" + this.__uuid);
            ObjectPrx raw = this.__oa.createProxy(id);
            this.__sf.setCallback(ClientCallbackPrxHelper.uncheckedCast(raw));
        }
        catch (RuntimeException e) {
            this.__del__();
            throw e;
        }
        catch (Exception e) {
            this.__del__();
            throw new RuntimeException(e);
        }
        this.getImplicitContext().put("omero.session.uuid", this.getSessionId());
        return this.__sf;
    }

    public static Glacier2.RouterPrx getRouter(Communicator comm) {
        RouterPrx prx = comm.getDefaultRouter();
        if (prx == null) {
            throw new ClientError("No default router found.");
        }
        Glacier2.RouterPrx router = RouterPrxHelper.checkedCast(prx);
        if (router == null) {
            throw new ClientError("Error obtaining Glacier2 router");
        }
        router = RouterPrxHelper.uncheckedCast(router.ice_context(comm.getImplicitContext().getContext()));
        return router;
    }

    public void enableKeepAlive(int seconds) {
        Communicator ic = this.getCommunicator();
        ic.getProperties().setProperty("omero.keep_alive", "" + seconds);
        if (this.__resources == null && seconds > 0) {
            this.__resources = new Resources(seconds);
            this.__resources.add(new Resources.Entry(){

                public boolean check() {
                    block3: {
                        ServiceFactoryPrx prx = client.this.__sf;
                        Communicator ic = client.this.__ic;
                        if (prx != null) {
                            try {
                                prx.keepAlive(null);
                            }
                            catch (Exception e) {
                                if (ic == null) break block3;
                                ic.getLogger().warning("Proxy keep alive failed.");
                            }
                        }
                    }
                    return true;
                }

                public void cleanup() {
                }
            });
        }
    }

    public List<StatefulServiceInterfacePrx> getStatefulServices() throws ServerError {
        ArrayList<StatefulServiceInterfacePrx> rv = new ArrayList<StatefulServiceInterfacePrx>();
        ServiceFactoryPrx sf = this.getSession();
        List<String> services = sf.activeServices();
        for (String srv : services) {
            try {
                ServiceInterfacePrx prx = sf.getByName(srv);
                StatefulServiceInterfacePrx sPrx = StatefulServiceInterfacePrxHelper.checkedCast(prx);
                if (sPrx == null) continue;
                rv.add(sPrx);
            }
            catch (Exception e) {
                this.getCommunicator().getLogger().warning("Error looking up proxy: " + srv);
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession() {
        ServiceFactoryPrx oldSf = this.__sf;
        this.__sf = null;
        ObjectAdapter oldOa = this.__oa;
        this.__oa = null;
        Communicator oldIc = this.__ic;
        this.__ic = null;
        if (oldIc == null) {
            return;
        }
        if (oldOa != null) {
            try {
                oldOa.deactivate();
            }
            catch (Exception e) {
                oldIc.getLogger().warning("While deactivating adapter: " + e.getMessage());
            }
        }
        this.__previous = new InitializationData();
        this.__previous.properties = oldIc.getProperties()._clone();
        this.__previous.logger = oldIc.getLogger();
        this.__previous.stats = oldIc.getStats();
        Resources oldR = this.__resources;
        this.__resources = null;
        if (oldR != null) {
            try {
                oldR.cleanup();
            }
            catch (Exception e) {
                oldIc.getLogger().warning("While cleaning up resources: " + e.getMessage());
            }
        }
        try {
            if (oldSf != null) {
                oldSf = ServiceFactoryPrxHelper.uncheckedCast(oldSf.ice_oneway());
            }
        }
        catch (ConnectionLostException cle) {
            try {
                oldIc.destroy();
            }
            finally {
                CLIENTS.remove(this);
            }
        }
        catch (ConnectionRefusedException cle) {
            try {
                oldIc.destroy();
            }
            finally {
                CLIENTS.remove(this);
            }
        }
        catch (ConnectTimeoutException cte) {
            try {
                oldIc.destroy();
            }
            finally {
                CLIENTS.remove(this);
            }
        }
        catch (DNSException dns) {
            try {
                oldIc.destroy();
            }
            finally {
                CLIENTS.remove(this);
            }
        }
        catch (SocketException se) {
            try {
                oldIc.destroy();
            }
            finally {
                CLIENTS.remove(this);
            }
        }
        finally {
            try {
                oldIc.destroy();
            }
            finally {
                CLIENTS.remove(this);
            }
        }
    }

    public int killSession() {
        ServiceFactoryPrx sf = this.getSession();
        Logger __logger = this.getCommunicator().getLogger();
        SessionI s = new SessionI();
        s.setUuid(rtypes.rstring(this.getSessionId()));
        ISessionPrx prx = null;
        try {
            prx = sf.getSessionService();
        }
        catch (Exception e) {
            __logger.warning("Cannot get session service for killSession. Using closeSession: " + e);
            this.closeSession();
            return -1;
        }
        int count = 0;
        try {
            int r = 1;
            while (r > 0) {
                ++count;
                r = prx.closeSession(s);
            }
        }
        catch (RemovedSessionException rse) {
        }
        catch (Exception e) {
            __logger.warning("Unknown exception while closing all references:" + e);
        }
        this.closeSession();
        return count;
    }

    public String sha1(File file) {
        return Utils.bytesToHex(Utils.pathToSha1(file.getAbsolutePath()));
    }

    public OriginalFile upload(File file) throws ServerError, IOException {
        return this.upload(file, null);
    }

    public OriginalFile upload(File file, OriginalFile fileObject) throws ServerError, IOException {
        return this.upload(file, fileObject, 262144);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OriginalFile upload(File file, OriginalFile fileObject, Integer blockSize) throws ServerError, IOException {
        OriginalFile originalFile;
        ServiceFactoryPrx sf = this.getSession();
        if (file == null) {
            throw new ClientError("Non-null file must be provided");
        }
        if (!file.exists() || !file.canRead()) {
            throw new ClientError("File does not exist or is not readable: " + file.getAbsolutePath());
        }
        if (blockSize == null) {
            blockSize = 262144;
        }
        long size = file.length();
        if ((long)blockSize.intValue() > size) {
            blockSize = (int)size;
        }
        if (fileObject == null) {
            fileObject = new OriginalFileI();
        }
        fileObject.setSize(rtypes.rlong(size));
        fileObject.setSha1(rtypes.rstring(this.sha1(file)));
        if (fileObject.getName() == null) {
            fileObject.setName(rtypes.rstring(file.getName()));
        }
        if (fileObject.getPath() == null) {
            String path = file.getParent() == null ? File.separator : file.getParent() + File.separator;
            fileObject.setPath(rtypes.rstring(path));
        }
        if (fileObject.getMimetype() == null) {
            fileObject.setMimetype(rtypes.rstring("application/octet-stream"));
        }
        IUpdatePrx up = sf.getUpdateService();
        fileObject = (OriginalFile)up.saveAndReturnObject(fileObject);
        byte[] buf = new byte[blockSize.intValue()];
        RawFileStorePrx rfs = sf.createRawFileStore();
        FileInputStream stream = null;
        try {
            int rlen;
            rfs.setFileId(fileObject.getId().getValue());
            stream = new FileInputStream(file);
            long pos = 0L;
            while ((rlen = stream.read(buf)) > 0) {
                rfs.write(buf, pos, rlen);
                pos += (long)rlen;
                ByteBuffer bbuf = ByteBuffer.wrap(buf);
                bbuf.limit(rlen);
            }
            originalFile = rfs.save();
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(stream);
            if (rfs != null) {
                rfs.close();
            }
            throw throwable;
        }
        Utils.closeQuietly(stream);
        if (rfs != null) {
            rfs.close();
        }
        return originalFile;
    }

    public void download(long fileId, File file) throws ServerError, IOException {
        this.download(fileId, file, 262144);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(long fileId, File file, int blockSize) throws ServerError, IOException {
        ServiceFactoryPrx sf = this.getSession();
        OriginalFile obj = (OriginalFile)sf.getQueryService().get("OriginalFile", fileId);
        RawFileStorePrx store = sf.createRawFileStore();
        FileOutputStream stream = new FileOutputStream(file);
        long size = obj.getSize().getValue();
        int offset = 0;
        int length = (int)size;
        store.setFileId(fileId);
        try {
            offset = 0;
            while ((long)(offset + blockSize) < size) {
                stream.write(store.read(offset, blockSize));
                offset += blockSize;
            }
            stream.write(store.read(offset, length - offset));
        }
        finally {
            Utils.closeQuietly(stream);
            store.close();
        }
    }

    public RType getInput(String key) throws ServerError {
        return this.env().getInput(this.sess(), key);
    }

    public RType getOutput(String key) throws ServerError {
        return this.env().getOutput(this.sess(), key);
    }

    public void setInput(String key, RType value) throws ServerError {
        this.env().setInput(this.sess(), key, value);
    }

    public void setOutput(String key, RType value) throws ServerError {
        this.env().setOutput(this.sess(), key, value);
    }

    public List<String> getInputKeys() throws ServerError {
        return this.env().getInputKeys(this.sess());
    }

    public List<String> getOutputKeys() throws ServerError {
        return this.env().getOutputKeys(this.sess());
    }

    protected String parseAndSetInt(InitializationData data, String key, int newValue) {
        String currentValue = data.properties.getProperty(key);
        if (currentValue == null || currentValue.length() == 0) {
            String newStr = Integer.toString(newValue);
            data.properties.setProperty(key, newStr);
            currentValue = newStr;
        }
        return currentValue;
    }

    protected static String filesToString(File ... files) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < files.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(files[i].getAbsolutePath());
        }
        return sb.toString();
    }

    protected ISessionPrx env() throws ServerError {
        ISessionPrx s = this.getSession().getSessionService();
        return s;
    }

    protected String sess() throws ServerError {
        IAdminPrx a = this.getSession().getAdminService();
        String u = a.getEventContext().sessionUuid;
        return u;
    }

    private CallbackI _getCb() {
        Ice.Object obj = this.__oa.find(Util.stringToIdentity("ClientCallback/" + this.__uuid));
        if (!(obj instanceof CallbackI)) {
            throw new ClientError("Cannot find CallbackI in ObjectAdapter");
        }
        return (CallbackI)obj;
    }

    public void onHearbeat(Runnable runnable) {
        this._getCb().onHeartbeat = runnable;
    }

    public void onSessionClosed(Runnable runnable) {
        this._getCb().onSessionClosed = runnable;
    }

    public void onShutdown(Runnable runnable) {
        this._getCb().onShutdown = runnable;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                HashSet clients = new HashSet(CLIENTS);
                for (client client2 : clients) {
                    try {
                        client2.__del__();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static class CallbackI
    extends _ClientCallbackDisp {
        private final Communicator ic;
        private final ObjectAdapter oa;
        private Runnable _noop = new Runnable(){

            public void run() {
            }
        };
        private Runnable _closeSession = new Runnable(){

            public void run() {
                try {
                    CallbackI.this.oa.deactivate();
                }
                catch (Exception e) {
                    System.err.println("On session closed: " + e.getMessage());
                }
            }
        };
        private Runnable onHeartbeat = this._noop;
        private Runnable onSessionClosed = this._noop;
        private Runnable onShutdown = this._noop;

        public CallbackI(Communicator ic, ObjectAdapter oa) {
            this.ic = ic;
            this.oa = oa;
        }

        public void requestHeartbeat(Current __current) {
            this.execute(this.onHeartbeat, "heartbeat");
        }

        public void shutdownIn(long milliseconds, Current __current) {
            this.execute(this.onShutdown, "shutdown");
        }

        public void sessionClosed(Current __current) {
            this.execute(this.onSessionClosed, "sessionClosed");
        }

        protected void execute(Runnable runnable, String action) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                try {
                    this.ic.getLogger().error("Error performing " + action + ": " + e.getMessage());
                }
                catch (Exception e2) {
                    System.err.println("Error performing " + action + " :" + e.getMessage());
                    System.err.println("(Stderr due to: " + e2.getMessage() + ")");
                }
            }
        }
    }
}

