// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public interface MonitorServerPrx extends Ice.ObjectPrx
{
    public String createMonitor(EventType eType, String pathString, String[] whitelist, String[] blacklist, PathMode pMode, MonitorClientPrx proxy)
        throws OmeroFSError;
    public String createMonitor(EventType eType, String pathString, String[] whitelist, String[] blacklist, PathMode pMode, MonitorClientPrx proxy, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public void startMonitor(String id)
        throws OmeroFSError;
    public void startMonitor(String id, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public void stopMonitor(String id)
        throws OmeroFSError;
    public void stopMonitor(String id, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public void destroyMonitor(String id)
        throws OmeroFSError;
    public void destroyMonitor(String id, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public MonitorState getMonitorState(String id)
        throws OmeroFSError;
    public MonitorState getMonitorState(String id, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public String[] getMonitorDirectory(String id, String relPath, String filter)
        throws OmeroFSError;
    public String[] getMonitorDirectory(String id, String relPath, String filter, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public String[] getDirectory(String absPath, String filter)
        throws OmeroFSError;
    public String[] getDirectory(String absPath, String filter, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public String getBaseName(String fileId)
        throws OmeroFSError;
    public String getBaseName(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public FileStats getStats(String fileId)
        throws OmeroFSError;
    public FileStats getStats(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public long getSize(String fileId)
        throws OmeroFSError;
    public long getSize(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public String getOwner(String fileId)
        throws OmeroFSError;
    public String getOwner(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public float getCTime(String fileId)
        throws OmeroFSError;
    public float getCTime(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public float getMTime(String fileId)
        throws OmeroFSError;
    public float getMTime(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public float getATime(String fileId)
        throws OmeroFSError;
    public float getATime(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public boolean isDir(String fileId)
        throws OmeroFSError;
    public boolean isDir(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public boolean isFile(String fileId)
        throws OmeroFSError;
    public boolean isFile(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public String getSHA1(String fileId)
        throws OmeroFSError;
    public String getSHA1(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError;

    public byte[] readBlock(String fileId, long offset, int size)
        throws OmeroFSError;
    public byte[] readBlock(String fileId, long offset, int size, java.util.Map<String, String> __ctx)
        throws OmeroFSError;
}
