// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public final class EventInfo implements java.lang.Cloneable
{
    public String fileId;

    public EventType type;

    public EventInfo()
    {
    }

    public EventInfo(String fileId, EventType type)
    {
        this.fileId = fileId;
        this.type = type;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        EventInfo _r = null;
        try
        {
            _r = (EventInfo)rhs;
        }
        catch(ClassCastException ex)
        {
        }

        if(_r != null)
        {
            if(fileId != _r.fileId && fileId != null && !fileId.equals(_r.fileId))
            {
                return false;
            }
            if(type != _r.type && type != null && !type.equals(_r.type))
            {
                return false;
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int __h = 0;
        if(fileId != null)
        {
            __h = 5 * __h + fileId.hashCode();
        }
        if(type != null)
        {
            __h = 5 * __h + type.hashCode();
        }
        return __h;
    }

    public java.lang.Object
    clone()
    {
        java.lang.Object o = null;
        try
        {
            o = super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return o;
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeString(fileId);
        type.__write(__os);
    }

    public void
    __read(IceInternal.BasicStream __is)
    {
        fileId = __is.readString();
        type = EventType.__read(__is);
    }
}
