// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public interface _MonitorServerDel extends Ice._ObjectDel
{
    String createMonitor(EventType eType, String pathString, String[] whitelist, String[] blacklist, PathMode pMode, MonitorClientPrx proxy, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    void startMonitor(String id, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    void stopMonitor(String id, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    void destroyMonitor(String id, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    MonitorState getMonitorState(String id, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    String[] getMonitorDirectory(String id, String relPath, String filter, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    String[] getDirectory(String absPath, String filter, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    String getBaseName(String fileId, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    FileStats getStats(String fileId, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    long getSize(String fileId, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    String getOwner(String fileId, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    float getCTime(String fileId, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    float getMTime(String fileId, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    float getATime(String fileId, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    boolean isDir(String fileId, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    boolean isFile(String fileId, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    String getSHA1(String fileId, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;

    byte[] readBlock(String fileId, long offset, int size, java.util.Map<String, String> __ctx)
        throws IceInternal.LocalExceptionWrapper,
               OmeroFSError;
}
