// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public abstract class _MonitorServerDisp extends Ice.ObjectImpl implements MonitorServer
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Ice::Object",
        "::monitors::MonitorServer"
    };

    public boolean
    ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean
    ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[]
    ice_ids()
    {
        return __ids;
    }

    public String[]
    ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String
    ice_id()
    {
        return __ids[1];
    }

    public String
    ice_id(Ice.Current __current)
    {
        return __ids[1];
    }

    public static String
    ice_staticId()
    {
        return __ids[1];
    }

    public final String
    createMonitor(EventType eType, String pathString, String[] whitelist, String[] blacklist, PathMode pMode, MonitorClientPrx proxy)
        throws OmeroFSError
    {
        return createMonitor(eType, pathString, whitelist, blacklist, pMode, proxy, null);
    }

    public final void
    destroyMonitor(String id)
        throws OmeroFSError
    {
        destroyMonitor(id, null);
    }

    public final float
    getATime(String fileId)
        throws OmeroFSError
    {
        return getATime(fileId, null);
    }

    public final String
    getBaseName(String fileId)
        throws OmeroFSError
    {
        return getBaseName(fileId, null);
    }

    public final float
    getCTime(String fileId)
        throws OmeroFSError
    {
        return getCTime(fileId, null);
    }

    public final String[]
    getDirectory(String absPath, String filter)
        throws OmeroFSError
    {
        return getDirectory(absPath, filter, null);
    }

    public final float
    getMTime(String fileId)
        throws OmeroFSError
    {
        return getMTime(fileId, null);
    }

    public final String[]
    getMonitorDirectory(String id, String relPath, String filter)
        throws OmeroFSError
    {
        return getMonitorDirectory(id, relPath, filter, null);
    }

    public final MonitorState
    getMonitorState(String id)
        throws OmeroFSError
    {
        return getMonitorState(id, null);
    }

    public final String
    getOwner(String fileId)
        throws OmeroFSError
    {
        return getOwner(fileId, null);
    }

    public final String
    getSHA1(String fileId)
        throws OmeroFSError
    {
        return getSHA1(fileId, null);
    }

    public final long
    getSize(String fileId)
        throws OmeroFSError
    {
        return getSize(fileId, null);
    }

    public final FileStats
    getStats(String fileId)
        throws OmeroFSError
    {
        return getStats(fileId, null);
    }

    public final boolean
    isDir(String fileId)
        throws OmeroFSError
    {
        return isDir(fileId, null);
    }

    public final boolean
    isFile(String fileId)
        throws OmeroFSError
    {
        return isFile(fileId, null);
    }

    public final byte[]
    readBlock(String fileId, long offset, int size)
        throws OmeroFSError
    {
        return readBlock(fileId, offset, size, null);
    }

    public final void
    startMonitor(String id)
        throws OmeroFSError
    {
        startMonitor(id, null);
    }

    public final void
    stopMonitor(String id)
        throws OmeroFSError
    {
        stopMonitor(id, null);
    }

    public static Ice.DispatchStatus
    ___createMonitor(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        EventType eType;
        eType = EventType.__read(__is);
        String pathString;
        pathString = __is.readString();
        String[] whitelist;
        whitelist = Ice.StringSeqHelper.read(__is);
        String[] blacklist;
        blacklist = Ice.StringSeqHelper.read(__is);
        PathMode pMode;
        pMode = PathMode.__read(__is);
        MonitorClientPrx proxy;
        proxy = MonitorClientPrxHelper.__read(__is);
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            String __ret = __obj.createMonitor(eType, pathString, whitelist, blacklist, pMode, proxy, __current);
            __os.writeString(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___startMonitor(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id;
        id = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            __obj.startMonitor(id, __current);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___stopMonitor(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id;
        id = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            __obj.stopMonitor(id, __current);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___destroyMonitor(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id;
        id = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            __obj.destroyMonitor(id, __current);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getMonitorState(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id;
        id = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            MonitorState __ret = __obj.getMonitorState(id, __current);
            __ret.__write(__os);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getMonitorDirectory(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id;
        id = __is.readString();
        String relPath;
        relPath = __is.readString();
        String filter;
        filter = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            String[] __ret = __obj.getMonitorDirectory(id, relPath, filter, __current);
            Ice.StringSeqHelper.write(__os, __ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getDirectory(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String absPath;
        absPath = __is.readString();
        String filter;
        filter = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            String[] __ret = __obj.getDirectory(absPath, filter, __current);
            Ice.StringSeqHelper.write(__os, __ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getBaseName(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            String __ret = __obj.getBaseName(fileId, __current);
            __os.writeString(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getStats(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            FileStats __ret = __obj.getStats(fileId, __current);
            __ret.__write(__os);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getSize(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            long __ret = __obj.getSize(fileId, __current);
            __os.writeLong(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getOwner(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            String __ret = __obj.getOwner(fileId, __current);
            __os.writeString(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getCTime(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            float __ret = __obj.getCTime(fileId, __current);
            __os.writeFloat(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getMTime(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            float __ret = __obj.getMTime(fileId, __current);
            __os.writeFloat(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getATime(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            float __ret = __obj.getATime(fileId, __current);
            __os.writeFloat(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___isDir(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            boolean __ret = __obj.isDir(fileId, __current);
            __os.writeBool(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___isFile(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            boolean __ret = __obj.isFile(fileId, __current);
            __os.writeBool(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getSHA1(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            String __ret = __obj.getSHA1(fileId, __current);
            __os.writeString(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___readBlock(MonitorServer __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId;
        fileId = __is.readString();
        long offset;
        offset = __is.readLong();
        int size;
        size = __is.readInt();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            byte[] __ret = __obj.readBlock(fileId, offset, size, __current);
            Ice.ByteSeqHelper.write(__os, __ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(OmeroFSError ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    private final static String[] __all =
    {
        "createMonitor",
        "destroyMonitor",
        "getATime",
        "getBaseName",
        "getCTime",
        "getDirectory",
        "getMTime",
        "getMonitorDirectory",
        "getMonitorState",
        "getOwner",
        "getSHA1",
        "getSize",
        "getStats",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "isDir",
        "isFile",
        "readBlock",
        "startMonitor",
        "stopMonitor"
    };

    public Ice.DispatchStatus
    __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return ___createMonitor(this, in, __current);
            }
            case 1:
            {
                return ___destroyMonitor(this, in, __current);
            }
            case 2:
            {
                return ___getATime(this, in, __current);
            }
            case 3:
            {
                return ___getBaseName(this, in, __current);
            }
            case 4:
            {
                return ___getCTime(this, in, __current);
            }
            case 5:
            {
                return ___getDirectory(this, in, __current);
            }
            case 6:
            {
                return ___getMTime(this, in, __current);
            }
            case 7:
            {
                return ___getMonitorDirectory(this, in, __current);
            }
            case 8:
            {
                return ___getMonitorState(this, in, __current);
            }
            case 9:
            {
                return ___getOwner(this, in, __current);
            }
            case 10:
            {
                return ___getSHA1(this, in, __current);
            }
            case 11:
            {
                return ___getSize(this, in, __current);
            }
            case 12:
            {
                return ___getStats(this, in, __current);
            }
            case 13:
            {
                return ___ice_id(this, in, __current);
            }
            case 14:
            {
                return ___ice_ids(this, in, __current);
            }
            case 15:
            {
                return ___ice_isA(this, in, __current);
            }
            case 16:
            {
                return ___ice_ping(this, in, __current);
            }
            case 17:
            {
                return ___isDir(this, in, __current);
            }
            case 18:
            {
                return ___isFile(this, in, __current);
            }
            case 19:
            {
                return ___readBlock(this, in, __current);
            }
            case 20:
            {
                return ___startMonitor(this, in, __current);
            }
            case 21:
            {
                return ___stopMonitor(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeTypeId(ice_staticId());
        __os.startWriteSlice();
        __os.endWriteSlice();
        super.__write(__os);
    }

    public void
    __read(IceInternal.BasicStream __is, boolean __rid)
    {
        if(__rid)
        {
            __is.readTypeId();
        }
        __is.startReadSlice();
        __is.endReadSlice();
        super.__read(__is, true);
    }

    public void
    __write(Ice.OutputStream __outS)
    {
        Ice.MarshalException ex = new Ice.MarshalException();
        ex.reason = "type monitors::MonitorServer was not generated with stream support";
        throw ex;
    }

    public void
    __read(Ice.InputStream __inS, boolean __rid)
    {
        Ice.MarshalException ex = new Ice.MarshalException();
        ex.reason = "type monitors::MonitorServer was not generated with stream support";
        throw ex;
    }
}
