/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailProvider;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileData;
import pojos.ImageData;
import pojos.MultiImageData;
import pojos.PermissionData;
import pojos.ProjectData;
import pojos.TagAnnotationData;
import pojos.WellData;
import pojos.WellSampleData;

public class DataBrowserTranslator {
    private static final String LEFT = "[";
    private static final String RIGHT = "]";

    private static void formatToolTipFor(ImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        String toolTip = UIUtilities.formatToolTipText(node.getTitle());
        node.getTitleBar().setToolTipText(toolTip);
    }

    private static ImageDisplay getFirstElement(Set set) {
        if (set == null || set.size() == 0) {
            return null;
        }
        ImageDisplay display = null;
        Iterator i = set.iterator();
        if (i.hasNext()) {
            display = (ImageDisplay)i.next();
        }
        return display;
    }

    private static ImageNode linkImageTo(ImageData is, ImageSet parent) {
        long id = is.getId();
        String name = "";
        if (id >= 0L) {
            name = is.getName();
        }
        ThumbnailProvider provider = new ThumbnailProvider((DataObject)is);
        ImageNode node = new ImageNode(name, is, provider);
        provider.setImageNode(node);
        if (parent != null) {
            parent.addChildDisplay(node);
        }
        return node;
    }

    private static ImageNode linkExperimenterTo(ExperimenterData is, ImageSet parent) {
        long id = is.getId();
        String name = "";
        if (id >= 0L) {
            name = is.getFirstName() + " " + is.getLastName();
        }
        ThumbnailProvider provider = new ThumbnailProvider((DataObject)is);
        ImageNode node = new ImageNode(name, is, provider);
        provider.setImageNode(node);
        if (parent != null) {
            parent.addChildDisplay(node);
        }
        return node;
    }

    private static ImageNode linkFileTo(FileData is, ImageSet parent) {
        long id = is.getId();
        String name = "";
        if (id >= 0L) {
            name = is.getName();
        }
        ThumbnailProvider provider = new ThumbnailProvider((DataObject)is);
        ImageNode node = new ImageNode(name, is, provider);
        provider.setImageNode(node);
        if (parent != null) {
            parent.addChildDisplay(node);
        }
        return node;
    }

    private static void linkImagesTo(Set images, ImageSet parent, long userID, long groupID) {
        if (images == null || parent == null) {
            return;
        }
        for (ImageData child : images) {
            if (!DataBrowserTranslator.isReadable((DataObject)child, userID, groupID)) continue;
            DataBrowserTranslator.linkImageTo(child, parent);
        }
    }

    private static ImageDisplay linkImages(DataObject uo, long userID, long groupID) {
        ImageSet node = null;
        if (uo instanceof DatasetData) {
            DatasetData ds = (DatasetData)uo;
            Set images = ds.getImages();
            String note = "";
            if (images != null) {
                note = LEFT + images.size() + RIGHT;
            }
            node = new ImageSet(ds.getName(), note, ds);
            DataBrowserTranslator.formatToolTipFor(node);
            DataBrowserTranslator.linkImagesTo(images, node, userID, groupID);
        }
        return node;
    }

    private static Set transformProjects(Set projects, long userID, long groupID) {
        if (projects == null) {
            throw new IllegalArgumentException("No projects.");
        }
        HashSet<ImageSet> results = new HashSet<ImageSet>();
        for (ProjectData ps : projects) {
            StringBuffer buffer = new StringBuffer();
            if (!DataBrowserTranslator.isReadable((DataObject)ps, userID, groupID)) continue;
            Set datasets = ps.getDatasets();
            if (datasets != null) {
                buffer.append(LEFT);
                buffer.append(datasets.size());
                buffer.append(RIGHT);
            }
            ImageSet project = new ImageSet(ps.getName(), buffer.toString(), ps);
            DataBrowserTranslator.formatToolTipFor(project);
            if (datasets != null) {
                for (DataObject child : datasets) {
                    if (!DataBrowserTranslator.isReadable(child, userID, groupID)) continue;
                    project.addChildDisplay(DataBrowserTranslator.linkImages(child, userID, groupID));
                }
            }
            results.add(project);
        }
        return results;
    }

    private static ImageDisplay transformWell(WellData data, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("No well.");
        }
        if (!DataBrowserTranslator.isReadable((DataObject)data, userID, groupID)) {
            return null;
        }
        WellImageSet node = new WellImageSet(data);
        List samples = data.getWellSamples();
        int index = 0;
        if (samples == null || samples.size() == 0) {
            ImageData img = new ImageData();
            img.setId(-1L);
            WellSampleData wsd = new WellSampleData();
            wsd.setId(-1L);
            wsd.setImage(img);
            WellSampleNode child = DataBrowserTranslator.createWellImage(wsd, index, node);
            node.addWellSample(child);
        } else {
            for (WellSampleData wsd : samples) {
                ImageData img = wsd.getImage();
                WellSampleNode child = DataBrowserTranslator.createWellImage(wsd, index, node);
                node.addWellSample(child);
                ++index;
            }
        }
        return node;
    }

    private static WellSampleNode createWellImage(WellSampleData wsd, int index, WellImageSet parent) {
        String name = "";
        ImageData is = wsd.getImage();
        if (is != null && is.getId() >= 0L) {
            name = is.getName();
        }
        ThumbnailProvider provider = new ThumbnailProvider((DataObject)is);
        WellSampleNode node = new WellSampleNode(name, wsd, provider, index, parent);
        provider.setImageNode(node);
        return node;
    }

    private static ImageDisplay transformTag(TagAnnotationData tag, long userID, long groupID) {
        if (tag == null) {
            throw new IllegalArgumentException("No tag.");
        }
        if (!DataBrowserTranslator.isReadable((DataObject)tag, userID, groupID)) {
            return null;
        }
        ImageSet data = null;
        Set tags = tag.getTags();
        Set dataObjects = tag.getDataObjects();
        String note = "";
        if (tags != null && tags.size() > 0) {
            note = note + LEFT + tags.size() + RIGHT;
            data = new ImageSet(tag.getTagValue(), note, tag);
            for (TagAnnotationData child : tags) {
                data.addChildDisplay(DataBrowserTranslator.transformTag(child, userID, groupID));
            }
        }
        if (dataObjects != null && dataObjects.size() > 0) {
            note = note + LEFT + dataObjects.size() + RIGHT;
            data = new ImageSet(tag.getTagValue(), note, tag);
            for (TagAnnotationData child : dataObjects) {
                ProjectData p;
                Set datasets;
                if (child instanceof ImageData) {
                    DataBrowserTranslator.linkImageTo((ImageData)child, data);
                    continue;
                }
                if (child instanceof DatasetData) {
                    data.addChildDisplay(DataBrowserTranslator.linkImages((DataObject)child, userID, groupID));
                    continue;
                }
                if (!(child instanceof ProjectData) || (datasets = (p = (ProjectData)child).getDatasets()) == null) continue;
                for (DataObject dataset : datasets) {
                    if (!DataBrowserTranslator.isReadable(dataset, userID, groupID)) continue;
                    data.addChildDisplay(DataBrowserTranslator.linkImages(dataset, userID, groupID));
                }
            }
        } else {
            data = new ImageSet(tag.getTagValue(), "", tag);
        }
        DataBrowserTranslator.formatToolTipFor(data);
        return data;
    }

    private static Set transformProject(DataObject project, long userID, long groupID) {
        HashSet<DataObject> set = new HashSet<DataObject>(1);
        set.add(project);
        return DataBrowserTranslator.transformProjects(set, userID, groupID);
    }

    private static Set transformDatasets(Set datasets, long userID, long groupID) {
        if (datasets == null) {
            throw new IllegalArgumentException("No datasets.");
        }
        HashSet<ImageDisplay> results = new HashSet<ImageDisplay>();
        for (DataObject ho : datasets) {
            if (!DataBrowserTranslator.isReadable(ho, userID, groupID)) continue;
            results.add(DataBrowserTranslator.linkImages(ho, userID, groupID));
        }
        return results;
    }

    private static Set transformDataset(DataObject dataset, long userID, long groupID) {
        HashSet<DataObject> set = new HashSet<DataObject>(1);
        set.add(dataset);
        return DataBrowserTranslator.transformDatasets(set, userID, groupID);
    }

    private static ImageDisplay transformMultiImage(MultiImageData img) {
        ImageSet node = new ImageSet(img.getName(), img);
        DataBrowserTranslator.formatToolTipFor(node);
        List images = img.getComponents();
        for (ImageData child : images) {
            DataBrowserTranslator.linkImageTo(child, node);
        }
        return node;
    }

    public static Set transformHierarchy(Collection dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageDisplay> results = new HashSet<ImageDisplay>();
        for (DataObject ho : dataObjects) {
            ImageDisplay child;
            if (ho instanceof ProjectData) {
                results.add(DataBrowserTranslator.getFirstElement(DataBrowserTranslator.transformProject(ho, userID, groupID)));
                continue;
            }
            if (ho instanceof DatasetData) {
                results.add(DataBrowserTranslator.getFirstElement(DataBrowserTranslator.transformDataset(ho, userID, groupID)));
                continue;
            }
            if (ho instanceof ImageData) {
                if (!DataBrowserTranslator.isReadable(ho, userID, groupID)) continue;
                results.add(DataBrowserTranslator.linkImageTo((ImageData)ho, null));
                continue;
            }
            if (ho instanceof TagAnnotationData) {
                child = DataBrowserTranslator.transformTag((TagAnnotationData)ho, userID, groupID);
                if (child == null) continue;
                results.add(child);
                continue;
            }
            if (!(ho instanceof WellData) || (child = DataBrowserTranslator.transformWell((WellData)ho, userID, groupID)) == null) continue;
            results.add(child);
        }
        return results;
    }

    public static Set transformObjects(Collection dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageNode> results = new HashSet<ImageNode>();
        for (DataObject ho : dataObjects) {
            if (!DataBrowserTranslator.isReadable(ho, userID, groupID) || !(ho instanceof ImageData)) continue;
            results.add(DataBrowserTranslator.linkImageTo((ImageData)ho, null));
        }
        return results;
    }

    public static Set transformImages(Collection dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageNode> results = new HashSet<ImageNode>();
        for (DataObject ho : dataObjects) {
            if (!DataBrowserTranslator.isReadable(ho, userID, groupID) || !(ho instanceof ImageData)) continue;
            results.add(DataBrowserTranslator.linkImageTo((ImageData)ho, null));
        }
        return results;
    }

    public static Set transformExperimenters(Collection dataObjects) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageNode> results = new HashSet<ImageNode>();
        for (DataObject ho : dataObjects) {
            if (!(ho instanceof ExperimenterData)) continue;
            results.add(DataBrowserTranslator.linkExperimenterTo((ExperimenterData)ho, null));
        }
        return results;
    }

    public static Set transformFSFolder(Collection dataObjects) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageDisplay> results = new HashSet<ImageDisplay>();
        for (DataObject ho : dataObjects) {
            if (ho instanceof MultiImageData) {
                results.add(DataBrowserTranslator.transformMultiImage((MultiImageData)ho));
                continue;
            }
            if (!(ho instanceof ImageData)) continue;
            results.add(DataBrowserTranslator.linkImageTo((ImageData)ho, null));
        }
        return results;
    }

    public static Set transform(DataObject ho, long userID, long groupID) {
        if (ho == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<DataObject> s = new HashSet<DataObject>(1);
        s.add(ho);
        return DataBrowserTranslator.transformHierarchy(s, userID, groupID);
    }

    public static boolean isReadable(DataObject ho, long userID, long groupID) {
        return true;
    }

    public static boolean isWritable(DataObject ho, long userID, long groupID) {
        PermissionData permissions = ho.getPermissions();
        if (userID == ho.getOwner().getId()) {
            return permissions.isUserWrite();
        }
        return permissions.isGroupWrite();
    }
}

