/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.DataObject;
import pojos.RatingAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateFilter
extends DataBrowserLoader {
    public static final int RATE_ONE = 1;
    public static final int RATE_TWO = 2;
    public static final int RATE_THREE = 3;
    public static final int RATE_FOUR = 4;
    public static final int RATE_FIVE = 5;
    public static final int UNRATED = 0;
    private List<Long> nodeIds;
    private Map<Long, DataObject> nodes;
    private Class nodeType;
    private int ratingLevel;
    private CallHandle handle;

    private void checkRate(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Rate type not supported.");
            }
        }
    }

    public RateFilter(DataBrowser viewer, int rate, Collection<DataObject> nodes) {
        super(viewer);
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No nodes to filter.");
        }
        this.checkRate(rate);
        this.ratingLevel = rate;
        this.nodes = new HashMap<Long, DataObject>();
        this.nodeIds = new ArrayList<Long>();
        for (DataObject data : nodes) {
            this.nodeIds.add(data.getId());
            this.nodeType = data.getClass();
            this.nodes.put(data.getId(), data);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void load() {
        long userID = -1L;
        this.handle = this.mhView.loadRatings(this.nodeType, this.nodeIds, userID, this);
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 5) {
            return;
        }
        Map map = (Map)result;
        Iterator<Object> i = map.keySet().iterator();
        ArrayList<DataObject> filteredNodes = new ArrayList<DataObject>();
        if (this.ratingLevel == 0) {
            while (i.hasNext()) {
                long id = (Long)i.next();
                this.nodes.remove(id);
            }
            i = this.nodes.keySet().iterator();
            while (i.hasNext()) {
                filteredNodes.add(this.nodes.get(i.next()));
            }
        } else {
            while (i.hasNext()) {
                int rate;
                long id = (Long)i.next();
                List ratings = (List)map.get(id);
                if (ratings.size() <= 0 || (rate = ((RatingAnnotationData)ratings.get(0)).getRating()) < this.ratingLevel) continue;
                filteredNodes.add(this.nodes.get(id));
            }
        }
        this.viewer.setFilteredNodes(filteredNodes, null);
    }
}

